/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.helper;

import java.net.URI;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.cache.CacheUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.GlobalConstants;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.model.ApiInfo;
import org.dromara.mendmix.common.model.AuthUser;
import org.dromara.mendmix.common.util.DigestUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.ParameterUtils;
import org.dromara.mendmix.common.util.TokenGenerator;
import org.dromara.mendmix.common.util.WebUtils;
import org.dromara.mendmix.gateway.CurrentSystemHolder;
import org.dromara.mendmix.gateway.GatewayConfigs;
import org.dromara.mendmix.gateway.GatewayConstants;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class RequestContextHelper {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.adapter.gateway");
    private static final String WEBSOCKET_KEYS = "sec-websocket-key";
    private static final String CACHED_REQUEST_BODY_STR = "cachedRequestBodyString";
    private static final String OAUTH_TOKEN_CHECK_KEY_PREFIX = "oauth-token-check:";
    private static List<String> browerUserAgentKeys = Arrays.asList("Mozilla", "Windows", "Chrome", "Safari", "Opera", "Android", "AppleWebKit");
    private static String[] mobileUserAgentKeys = new String[]{"Android", "iPhone", "iPad"};
    private static String wxUserAgentKey = "MicroMessenger";
    private static String miniProgramUserAgentKey = "miniProgram";

    public static GatewayConstants.UserClientType getUserClientType(ServerHttpRequest request) {
        String userAgent = request.getHeaders().getFirst("User-Agent");
        if (userAgent == null) {
            return GatewayConstants.UserClientType.pc;
        }
        if (userAgent.contains(wxUserAgentKey)) {
            if (userAgent.contains(miniProgramUserAgentKey)) {
                return GatewayConstants.UserClientType.miniProgram;
            }
            return GatewayConstants.UserClientType.wxh5;
        }
        for (String key : mobileUserAgentKeys) {
            if (!userAgent.contains(key)) continue;
            return GatewayConstants.UserClientType.app;
        }
        return GatewayConstants.UserClientType.pc;
    }

    public static String getOriginRequestUri(ServerWebExchange exchange) {
        String uri = (String)exchange.getAttribute("ctx-current-uri");
        if (uri != null) {
            return uri;
        }
        return exchange.getRequest().getPath().value();
    }

    public static String getOriginDomain(ServerHttpRequest request) {
        String originUrl = request.getHeaders().getFirst("Referer");
        if (originUrl == null) {
            originUrl = request.getHeaders().getOrigin();
        }
        String originDomain = null;
        if (originUrl != null) {
            originDomain = WebUtils.getDomain((String)originUrl);
        }
        return StringUtils.defaultString((String)originDomain, (String)request.getURI().getAuthority());
    }

    public static String getIpAddr(ServerHttpRequest request) {
        String ip = (String)ThreadLocalContext.get((String)"ctx-current-ip");
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            return ip;
        }
        ip = request.getHeaders().getFirst("x-forwarded-for");
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeaders().getFirst("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeaders().getFirst("WL-Proxy-Client-IP");
        }
        if (ip != null && ip.length() > 15) {
            String _ip;
            String[] ips;
            String[] stringArray = ips = StringUtils.split((String)ip, (String)",");
            int n = stringArray.length;
            for (int i = 0; i < n && "unknown".equalsIgnoreCase(ip = StringUtils.trimToNull((String)(_ip = stringArray[i]))); ++i) {
            }
        }
        if (ip == null) {
            ip = request.getRemoteAddress().getAddress().getHostAddress();
        }
        if (ip.contains(":")) {
            ip = "127.0.0.1";
        }
        ThreadLocalContext.set((String)"ctx-current-ip", (Object)ip);
        return ip;
    }

    public static String getRequestId(ServerWebExchange exchange) {
        String requestId = exchange.getRequest().getHeaders().getFirst("x-request-id");
        if (StringUtils.isBlank((CharSequence)requestId) && exchange.getAttributes().containsKey("x-request-id")) {
            requestId = (String)exchange.getAttribute("x-request-id");
        }
        if (StringUtils.isBlank((CharSequence)requestId)) {
            requestId = CurrentRuntimeContext.getRequestId();
        } else {
            CurrentRuntimeContext.setRequestId((String)requestId);
        }
        if (requestId != null) {
            exchange.getAttributes().put("x-request-id", requestId);
        }
        return requestId;
    }

    public static String getCurrentRouteName(ServerWebExchange exchange) {
        String currentRoute = (String)exchange.getAttribute("ctx-current-route");
        if (currentRoute != null) {
            return currentRoute;
        }
        currentRoute = RequestContextHelper.resolveRouteName(exchange.getRequest().getPath().value());
        exchange.getAttributes().put("ctx-current-route", currentRoute);
        return currentRoute;
    }

    public static String resolveRouteName(String uri) {
        String contextPath = GatewayConfigs.PATH_PREFIX;
        int indexOf = StringUtils.indexOf((CharSequence)uri, (CharSequence)GlobalConstants.PATH_SEPARATOR, (int)contextPath.length());
        uri = uri.substring(indexOf + 1);
        List<String> routeNames = CurrentSystemHolder.getRouteNames();
        for (String routeName : routeNames) {
            if (!uri.startsWith(routeName + "/")) continue;
            return routeName;
        }
        return GlobalContext.APPID;
    }

    public static BizSystemModule getCurrentModule(ServerWebExchange exchange) {
        BizSystemModule module = (BizSystemModule)exchange.getAttribute("ctx-current-module");
        if (module != null) {
            return module;
        }
        String routeName = RequestContextHelper.getCurrentRouteName(exchange);
        module = CurrentSystemHolder.getModule(routeName);
        if (module != null) {
            exchange.getAttributes().put("ctx-current-module", module);
        }
        return module;
    }

    public static ApiInfo getCurrentApi(ServerWebExchange exchange) {
        ApiInfo api = (ApiInfo)exchange.getAttribute("ctx-current-api");
        if (api != null) {
            return api;
        }
        BizSystemModule module = RequestContextHelper.getCurrentModule(exchange);
        String uri = RequestContextHelper.getOriginRequestUri(exchange);
        ApiInfo apiInfo = module.getApiInfo(exchange.getRequest().getMethodValue(), uri);
        if (apiInfo != null) {
            exchange.getAttributes().put("ctx-current-api", apiInfo);
        }
        return apiInfo;
    }

    public static boolean isWebSocketRequest(ServerHttpRequest request) {
        return request.getHeaders().containsKey((Object)WEBSOCKET_KEYS);
    }

    public static boolean isJsonRequest(ServerHttpRequest request) {
        if (request.getMethod() == HttpMethod.GET) {
            return false;
        }
        MediaType contentType = request.getHeaders().getContentType();
        return contentType != null && contentType.includes(MediaType.APPLICATION_JSON);
    }

    public static boolean isServerSendEventRequest(ServerHttpRequest request) {
        List accept = request.getHeaders().getAccept();
        if (accept == null || accept.isEmpty()) {
            return false;
        }
        return MediaType.TEXT_EVENT_STREAM.equals(accept.get(0));
    }

    public static final boolean isMultipartContent(ServerHttpRequest request) {
        if (!HttpMethod.POST.name().equalsIgnoreCase(request.getMethodValue())) {
            return false;
        }
        MediaType contentType = request.getHeaders().getContentType();
        if (contentType == null) {
            return false;
        }
        return MediaType.MULTIPART_FORM_DATA.getType().equals(contentType.getType());
    }

    public static boolean isBackendCall(ServerWebExchange exchange) {
        boolean res;
        if (exchange.getAttributes().containsKey("ctx-backend-request")) {
            return (Boolean)exchange.getAttributes().get("ctx-backend-request");
        }
        HttpHeaders headers = exchange.getRequest().getHeaders();
        boolean bl = res = GatewayConfigs.openApiEnabled && headers.containsKey((Object)"x-open-sign");
        if (!res) {
            String userAgent = headers.getFirst("User-Agent");
            boolean bl2 = res = StringUtils.isBlank((CharSequence)userAgent) || !browerUserAgentKeys.stream().anyMatch(o -> userAgent.contains((CharSequence)o));
            if (RequestContextHelper.isDebugMode(exchange)) {
                logger.info("<trace_logging> current userAgent:{},isBackendCall:{}", (Object)userAgent, (Object)res);
            }
        }
        exchange.getAttributes().put("ctx-backend-request", res);
        return res;
    }

    public static boolean withValidatedOAuthToken(ServerHttpRequest request) {
        String token = (String)request.getQueryParams().getFirst((Object)"auth_code");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = request.getHeaders().getFirst("x-invoke-token");
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        try {
            long expiredAt = TokenGenerator.validate((String)token, (boolean)true);
            String reCheckKey = OAUTH_TOKEN_CHECK_KEY_PREFIX + DigestUtils.md5((Object)token);
            long timeout = (expiredAt - System.currentTimeMillis() + 1L) / 1000L;
            String lastValue = CacheUtils.getStr((String)reCheckKey);
            String currentValue = request.getPath().value();
            if (CurrentRuntimeContext.isDebugMode()) {
                logger.info("<trace_logging> reCheckKey:{},lastValue:{},currentValue:{}", new Object[]{reCheckKey, lastValue, currentValue});
            }
            if (lastValue == null) {
                CacheUtils.setStr((String)reCheckKey, (String)currentValue, (long)timeout);
            } else if (!lastValue.equals(currentValue)) {
                logger.info(">>token \u91cd\u590d\u4f7f\u7528,reCheckKey:{},lastValue:{},currentValue:{}", new Object[]{reCheckKey, lastValue, currentValue});
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getCachingBodyString(ServerWebExchange exchange) {
        if (exchange.getRequest().getMethod() == HttpMethod.GET || RequestContextHelper.isMultipartContent(exchange.getRequest())) {
            return null;
        }
        String bodyString = (String)exchange.getAttribute(CACHED_REQUEST_BODY_STR);
        if (bodyString != null) {
            return bodyString;
        }
        DataBuffer dataBuffer = (DataBuffer)exchange.getAttribute("cachedRequestBody");
        if (dataBuffer == null) {
            return null;
        }
        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(dataBuffer.asByteBuffer());
        bodyString = charBuffer.toString();
        exchange.getAttributes().put(CACHED_REQUEST_BODY_STR, bodyString);
        exchange.getAttributes().put("ctx-request-body-size", charBuffer.length());
        if (exchange.getAttributes().containsKey("_debug_trace_context")) {
            logger.info(">>>>>>>>request body>>>>>>>>\n:{}", (Object)bodyString);
        }
        return bodyString;
    }

    public static String getCurrentRequestHitKey(ServerWebExchange exchange, boolean isolatingUser) {
        AuthUser authUser;
        String cachingBody;
        String hitKey = (String)exchange.getAttribute("ctx-current-hitKey");
        if (hitKey != null) {
            return hitKey;
        }
        ServerHttpRequest request = exchange.getRequest();
        StringBuilder builder = new StringBuilder();
        builder.append(request.getMethodValue()).append(RequestContextHelper.getOriginRequestUri(exchange));
        HashMap paramMap = new HashMap();
        request.getQueryParams().forEach((k, v) -> {
            if (!v.isEmpty()) {
                paramMap.put(k, v.get(0));
            }
        });
        if (request.getMethod() != HttpMethod.GET && StringUtils.isNotBlank((CharSequence)(cachingBody = RequestContextHelper.getCachingBodyString(exchange))) && cachingBody.length() > 2) {
            paramMap.putAll(JsonUtils.toHashMap((String)cachingBody, Object.class));
        }
        if (!paramMap.isEmpty()) {
            builder.append(ParameterUtils.mapToQueryParams(paramMap));
        }
        builder.append(CurrentRuntimeContext.getSystemId());
        builder.append(CurrentRuntimeContext.getTenantId());
        if (isolatingUser && (authUser = CurrentRuntimeContext.getCurrentUser()) != null) {
            builder.append(authUser.getId());
        }
        hitKey = builder.length() <= 64 ? builder.toString() : DigestUtils.md5((Object)builder.toString());
        exchange.getAttributes().put("ctx-current-hitKey", hitKey);
        return hitKey;
    }

    public static Locale getLocale(ServerHttpRequest request) {
        List locales = request.getHeaders().getAcceptLanguageAsLocales();
        if (locales != null && !locales.isEmpty()) {
            return (Locale)locales.get(0);
        }
        return Locale.CHINA;
    }

    public static String getTimestamp(ServerWebExchange exchange) {
        String timestamp = exchange.getRequest().getHeaders().getFirst("timestamp");
        if (timestamp == null) {
            timestamp = String.valueOf(System.currentTimeMillis());
            exchange.getAttributes().put("timestamp", timestamp);
        }
        return timestamp;
    }

    public static boolean isDebugMode(ServerWebExchange exchange) {
        if (exchange == null) {
            return ThreadLocalContext.exists((String)"_debug_trace_context");
        }
        return exchange.getAttributes().containsKey("_debug_trace_context");
    }

    public static Mono<Void> writeData(ServerWebExchange exchange, byte[] data, int statusCode) {
        ServerHttpResponse response = exchange.getResponse();
        response.setRawStatusCode(Integer.valueOf(statusCode));
        response.getHeaders().add("Content-Type", "application/json; charset=utf-8");
        return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(data)));
    }

    public static void clearContextAttributes(ServerWebExchange exchange) {
        PooledDataBuffer dataBuffer;
        if (ThreadLocalContext.exists((String)"ctx-clearContextAttributes")) {
            ThreadLocalContext.remove((String[])new String[]{"ctx-clearContextAttributes"});
            return;
        }
        Object attribute = exchange.getAttributes().remove("cachedRequestBody");
        if (attribute != null && attribute instanceof PooledDataBuffer && (dataBuffer = (PooledDataBuffer)attribute).isAllocated()) {
            dataBuffer.release();
        }
        exchange.getAttributes().clear();
        ThreadLocalContext.unset();
    }

    public static void clearCustomContextAttributes(ServerWebExchange exchange) {
        Set keys = exchange.getAttributes().keySet();
        for (String key : keys) {
            if (!key.startsWith("ctx-") && !key.startsWith("x-")) continue;
            exchange.getAttributes().remove(key);
        }
    }

    public static void setContextAttr(ServerWebExchange exchange, String key, Object value) {
        if (exchange != null) {
            exchange.getAttributes().put(key, value);
        }
        ThreadLocalContext.set((String)key, (Object)value);
    }

    public static <T> T getContextAttr(ServerWebExchange exchange, String key, T ... defValue) {
        Object val = ThreadLocalContext.get((String)key);
        if (val == null && exchange != null) {
            val = exchange.getAttribute(key);
        }
        if (val == null && defValue != null && defValue.length > 0) {
            val = defValue[0];
        }
        return (T)val;
    }

    public static boolean hasContextAttr(ServerWebExchange exchange, String key) {
        boolean has = false;
        if (exchange != null) {
            has = exchange.getAttributes().containsKey(key);
        }
        if (!has) {
            has = ThreadLocalContext.exists((String)key);
        }
        return has;
    }

    public static URI rewriteRouteUri(ServerWebExchange exchange, BizSystemModule module, String rewriteBaseUrl) {
        String newPath;
        URI newUri;
        URI orignUri = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String path = orignUri.getPath();
        String query = orignUri.getQuery();
        if (StringUtils.isBlank((CharSequence)rewriteBaseUrl)) {
            newUri = orignUri;
            newPath = module.getContextPath();
        } else {
            newUri = URI.create(rewriteBaseUrl);
            newPath = newUri.getPath();
        }
        String uriPrefix = module.getUriPrefix();
        if (module.getResolveRouteNames().size() > 1) {
            uriPrefix = GatewayConfigs.PATH_PREFIX + GlobalConstants.PATH_SEPARATOR + module.getCurrentRouteName(exchange);
        }
        if (module.getRewriteUriPrefix() != null) {
            path = StringUtils.isBlank((CharSequence)GatewayConfigs.PATH_PREFIX) ? module.getRewriteUriPrefix() + path : (module.getRewriteUriPrefix().equals(module.getContextPath()) ? (module.isSubGateway() ? StringUtils.replace((String)path, (String)GatewayConfigs.PATH_PREFIX, (String)module.getRewriteUriPrefix(), (int)1) : StringUtils.replace((String)path, (String)module.getCurrentRouteName(exchange), (String)module.getRewriteUriPrefix(), (int)1)) : StringUtils.replace((String)path, (String)uriPrefix, (String)module.getRewriteUriPrefix(), (int)1));
        } else if (!path.startsWith(uriPrefix)) {
            path = uriPrefix.startsWith(newPath) ? uriPrefix + path : (StringUtils.isBlank((CharSequence)GatewayConfigs.PATH_PREFIX) ? newPath + uriPrefix + path : StringUtils.replace((String)uriPrefix, (String)GatewayConfigs.PATH_PREFIX, (String)newPath, (int)1) + path);
        }
        newUri = UriComponentsBuilder.fromUri((URI)orignUri).scheme(newUri.getScheme()).host(newUri.getHost()).port(newUri.getPort()).replacePath(path).replaceQuery(query).build(false).toUri();
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, newUri);
        if (RequestContextHelper.isDebugMode(exchange)) {
            logger.info(">>rewriteRouteUri>> \n -orignUri:{}\n -mappingUri:{}\n -newUri:{}", new Object[]{orignUri, rewriteBaseUrl, newUri});
        }
        return newUri;
    }

    public static String getRequestTenantId(ServerWebExchange exchange) {
        String tenantId = CurrentRuntimeContext.getTenantId();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            String bodyString;
            ServerHttpRequest request = exchange.getRequest();
            tenantId = request.getHeaders().getFirst("x-tenant-id");
            if (StringUtils.isBlank((CharSequence)tenantId) && CurrentRuntimeContext.getCurrentUser() == null && StringUtils.isBlank((CharSequence)(tenantId = (String)request.getQueryParams().getFirst((Object)"tenantId"))) && RequestContextHelper.isJsonRequest(request) && JsonUtils.isJsonObjectString((String)(bodyString = RequestContextHelper.getCachingBodyString(exchange)))) {
                tenantId = JsonUtils.getJsonNodeValue((String)bodyString, (String)"tenantId");
            }
            if (tenantId != null) {
                CurrentRuntimeContext.setTenantId((String)tenantId);
            }
        }
        return tenantId;
    }

    public static String buildServiceChainHeader(HttpHeaders headers) {
        String newHeaderVal = headers.getFirst("x-forwarded-service-chain");
        String curNode = GlobalContext.APPID + "@" + GlobalContext.getNodeName();
        newHeaderVal = StringUtils.isBlank((CharSequence)newHeaderVal) ? curNode : newHeaderVal + "," + curNode;
        return newHeaderVal;
    }
}

