/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.helper;

import java.util.HashMap;
import java.util.Map;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.http.HttpMethod;
import org.dromara.mendmix.common.http.HttpRequestEntity;
import org.dromara.mendmix.common.http.HttpResponseEntity;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public class RequestFallbackHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.adapter.gateway");

    public static Map<String, Object> handleForwardUrl(ServerWebExchange exchange, String forwardUrl) {
        Map<String, Object> result;
        ServerHttpRequest request = exchange.getRequest();
        if (!forwardUrl.startsWith("http")) {
            HashMap<String, Object> result2 = new HashMap<String, Object>(2);
            result2.put("code", 200);
            result2.put("data", JsonUtils.toHashMap((String)forwardUrl, Object.class));
            return result2;
        }
        boolean traceMode = logger.isTraceEnabled() || exchange.getAttributes().containsKey("_debug_trace_context");
        String requestUri = RequestContextHelper.getOriginRequestUri(exchange);
        logger.debug("<startup-logging> request[{}] forward to[{}] Begin...", (Object)requestUri, (Object)forwardUrl);
        HttpRequestEntity requestEntity = HttpRequestEntity.create((HttpMethod)HttpMethod.valueOf((String)request.getMethodValue())).uri(forwardUrl);
        MultiValueMap queryParams = request.getQueryParams();
        if (!queryParams.isEmpty()) {
            for (String paramName : queryParams.keySet()) {
                requestEntity.queryParam(paramName, queryParams.getFirst((Object)paramName));
            }
        }
        if (!request.getMethodValue().equals(HttpMethod.GET.name())) {
            String body = RequestContextHelper.getCachingBodyString(exchange);
            requestEntity.body(body);
            if (traceMode) {
                logger.info("handleForwardUrl request body:\n{}", (Object)body);
            }
        }
        if (request.getHeaders().containsKey((Object)"User-Agent")) {
            requestEntity.header("User-Agent", request.getHeaders().getFirst("User-Agent"));
        }
        HttpResponseEntity responseEntity = requestEntity.useContext().execute();
        if (traceMode) {
            logger.info("handleForwardUrl response:\n -statusCode:{}\n -body:{}", (Object)responseEntity.getStatusCode(), (Object)responseEntity.getBody());
        }
        if (!responseEntity.httpOk()) {
            throw new MendmixBaseException(responseEntity.getStatusCode(), responseEntity.getBizCode(), responseEntity.getMessage());
        }
        if (!JsonUtils.isJsonString((String)responseEntity.getBody())) {
            HashMap<String, Object> nullValue = new HashMap<String, Object>(1);
            nullValue.put("__NULL_BODY_", null);
            return nullValue;
        }
        if (JsonUtils.isJsonArrayString((String)responseEntity.getBody())) {
            result = new HashMap<String, Object>(2);
            result.put("code", 200);
            result.put("data", JsonUtils.toList((String)responseEntity.getBody(), Map.class));
        } else {
            Map respMap = JsonUtils.toHashMap((String)responseEntity.getBody(), Object.class);
            if (respMap.containsKey("code") && (respMap.size() == 1 || respMap.containsKey("data") || respMap.containsKey("msg"))) {
                result = respMap;
            } else {
                result = new HashMap(2);
                result.put("code", 200);
                result.put("data", respMap);
            }
        }
        if (traceMode) {
            logger.info("<startup-logging> request[{}] forward successed", (Object)requestUri);
        }
        return result;
    }
}

