/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.model.ApiInfo;
import org.dromara.mendmix.common.util.BeanUtils;
import org.dromara.mendmix.common.util.PathMatcher;
import org.dromara.mendmix.common.util.WebUtils;
import org.dromara.mendmix.gateway.GatewayConfigs;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.web.server.ServerWebExchange;

public class BizSystemModule {
    private static Map<String, String> routeMetadataDefines = ImmutableMap.of((Object)"connectTimeout", (Object)"connect-timeout", (Object)"responseTimeout", (Object)"response-timeout");
    private String id;
    private String serviceId;
    private String routeName;
    private String proxyUri;
    private String anonymousUris;
    private String systemId;
    private String name;
    private boolean global;
    private boolean local;
    private int stripPrefix = -1;
    private boolean withMetadata;
    private boolean stdResponse;
    private boolean apiLogging;
    private boolean subGateway;
    private String rewriteUriPrefix;
    private boolean disabledApis;
    private Boolean ignoreApiPerm;
    private String serviceBaseUrl;
    private String contextPath;
    private String uriPrefix;
    private Map<String, Object> metadata;
    private List<String> resolveRouteNames;
    private RouteDefinition routeDefinition;
    @JsonIgnore
    private Map<Pattern, ApiInfo> wildcardUris = new HashMap<Pattern, ApiInfo>();
    private Map<String, ApiInfo> apiInfos;
    @JsonIgnore
    private PathMatcher anonymousUriMatcher = new PathMatcher();
    @JsonIgnore
    private List<Pattern> sortedWildcardPatterns = new ArrayList<Pattern>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        if (serviceId != null) {
            serviceId = serviceId.toLowerCase();
        }
        this.serviceId = serviceId;
    }

    @Deprecated
    public String getRouteName() {
        return this.routeName;
    }

    public String getCurrentRouteName(ServerWebExchange exchange) {
        return StringUtils.defaultString((String)RequestContextHelper.getCurrentRouteName(exchange), (String)this.routeName);
    }

    public String getFirstRouteName() {
        if (this.getResolveRouteNames() == null || this.getResolveRouteNames().isEmpty()) {
            return null;
        }
        return this.getResolveRouteNames().get(0);
    }

    public void setRouteName(String routeName) {
        this.routeName = StringUtils.trimToNull((String)routeName);
        if (this.routeName == null) {
            this.resolveRouteNames = new ArrayList<String>(0);
        } else {
            List<String> subs = Arrays.asList(StringUtils.split((String)this.routeName, (String)","));
            this.resolveRouteNames = new ArrayList<String>(subs.size());
            for (String sub : subs) {
                if (sub.startsWith("/")) {
                    sub = sub.substring(1);
                }
                this.resolveRouteNames.add(sub);
            }
        }
    }

    public List<String> getResolveRouteNames() {
        return this.resolveRouteNames;
    }

    public void setResolveRouteNames(List<String> resolveRouteNames) {
        this.resolveRouteNames = resolveRouteNames;
        this.routeName = resolveRouteNames == null || resolveRouteNames.isEmpty() ? null : StringUtils.join(resolveRouteNames, (String)",");
    }

    public String getAnonymousUris() {
        return this.anonymousUris;
    }

    public void setAnonymousUris(String anonymousUris) {
        this.anonymousUris = anonymousUris;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public int getStripPrefix() {
        return this.stripPrefix;
    }

    public void setStripPrefix(int stripPrefix) {
        this.stripPrefix = stripPrefix;
    }

    public boolean isWithMetadata() {
        return this.withMetadata;
    }

    public void setWithMetadata(boolean withMetadata) {
        this.withMetadata = withMetadata;
    }

    public boolean isDisabledApis() {
        return this.disabledApis;
    }

    public void setDisabledApis(boolean disabledApis) {
        this.disabledApis = disabledApis;
    }

    public boolean isStdResponse() {
        return this.stdResponse;
    }

    public void setStdResponse(boolean stdResponse) {
        this.stdResponse = stdResponse;
    }

    public boolean isApiLogging() {
        return this.apiLogging;
    }

    public void setApiLogging(boolean apiLogging) {
        this.apiLogging = apiLogging;
    }

    public void setProxyUri(String proxyUri) {
        if (StringUtils.isNotBlank((CharSequence)proxyUri)) {
            if (proxyUri.contains("?")) {
                String[] parts = StringUtils.split((String)proxyUri, (String)"?", (int)2);
                proxyUri = parts[0];
                for (String part : parts = StringUtils.split((String)parts[1], (String)"&")) {
                    String[] subParts = StringUtils.split((String)part, (String)"=", (int)2);
                    if (subParts.length < 2) continue;
                    this.getMetadata().put(subParts[0], subParts[1]);
                }
            }
            if (!proxyUri.contains("://")) {
                proxyUri = "http://" + proxyUri;
            }
            if (proxyUri.endsWith("/")) {
                proxyUri = proxyUri.substring(0, proxyUri.length() - 1);
            }
        }
        this.proxyUri = StringUtils.trimToNull((String)proxyUri);
    }

    public String getProxyUri() {
        if (this.proxyUri == null && this.serviceId != null) {
            this.proxyUri = this.serviceId.contains(":") ? this.serviceId : "lb://" + this.serviceId;
        }
        return this.proxyUri;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getServiceBaseUrl() {
        return this.serviceBaseUrl;
    }

    public void setServiceBaseUrl(String serviceBaseUrl) {
        this.serviceBaseUrl = serviceBaseUrl;
    }

    public String getUriPrefix() {
        if (this.uriPrefix == null) {
            if (this.isGateway() || this.stripPrefix == 0 && this.getResolveRouteNames().size() > 1) {
                return GatewayConfigs.PATH_PREFIX;
            }
            this.uriPrefix = GatewayConfigs.PATH_PREFIX + "/" + this.getFirstRouteName();
            return this.uriPrefix;
        }
        return this.uriPrefix;
    }

    public void setUriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }

    public boolean isSubGateway() {
        return this.subGateway;
    }

    public void setSubGateway(boolean subGateway) {
        this.subGateway = subGateway;
    }

    public String getRewriteUriPrefix() {
        return this.rewriteUriPrefix;
    }

    public void setRewriteUriPrefix(String rewriteUriPrefix) {
        this.rewriteUriPrefix = rewriteUriPrefix;
    }

    public boolean isIgnoreApiPerm() {
        return this.ignoreApiPerm == null ? this.subGateway : this.ignoreApiPerm;
    }

    public void setIgnoreApiPerm(boolean ignoreApiPerm) {
        this.ignoreApiPerm = ignoreApiPerm;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata == null ? (this.metadata = new HashMap<String, Object>()) : this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void setApiInfos(Map<String, ApiInfo> apiInfos) {
        this.apiInfos = apiInfos;
    }

    public Map<String, ApiInfo> getApiInfos() {
        return this.apiInfos;
    }

    public RouteDefinition getRouteDefinition() {
        return this.routeDefinition;
    }

    public void setRouteDefinition(RouteDefinition routeDefinition) {
        this.routeDefinition = routeDefinition;
    }

    @JsonIgnore
    public boolean isGateway() {
        return GlobalContext.APPID.equals(this.getFirstRouteName());
    }

    public void updateOnApiListRefresh() {
        if (this.wildcardUris.isEmpty()) {
            return;
        }
        this.sortedWildcardPatterns = this.wildcardUris.keySet().stream().sorted((o1, o2) -> o2.pattern().length() - o1.pattern().length()).collect(Collectors.toList());
    }

    public void addApiInfo(ApiInfo apiInfo) {
        String identifier;
        if (this.apiInfos == null) {
            this.apiInfos = new HashMap<String, ApiInfo>();
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{apiInfo.getMethod(), apiInfo.getUri()})) {
            System.err.println(String.format("\u2718\u2718\u2718\u2718\u2718 Ignore_nullvalue_api -> routeName:%s,apiInfo:%s", this.routeName, apiInfo));
            return;
        }
        String uniqueKey = BizSystemModule.buildApiIdentifier(apiInfo.getMethod(), BizSystemModule.resolveFullUri(this, apiInfo.getUri()));
        String uri = apiInfo.getUri();
        if (this.isGateway()) {
            if (uri.startsWith(GatewayConfigs.PATH_PREFIX + "/")) {
                uri = apiInfo.getUri().substring(GatewayConfigs.PATH_PREFIX.length());
            }
            identifier = BizSystemModule.buildApiIdentifier(apiInfo.getMethod(), uri);
        } else if (this.getStripPrefix() == 1) {
            if (!uri.startsWith("/" + this.getFirstRouteName() + "/")) {
                uri = "/" + this.getFirstRouteName() + uri;
            }
            identifier = BizSystemModule.buildApiIdentifier(apiInfo.getMethod(), uri);
        } else {
            identifier = BizSystemModule.buildApiIdentifier(apiInfo.getMethod(), uri);
        }
        apiInfo.setIdentifier(identifier);
        apiInfo.setRoutedIdentifier(uniqueKey);
        this.apiInfos.put(uniqueKey, apiInfo);
        if (uniqueKey.contains("{")) {
            Pattern pattern = Pattern.compile(uniqueKey.replaceAll("\\{[^/]+?\\}", ".+"));
            this.wildcardUris.put(pattern, apiInfo);
        }
    }

    public ApiInfo getApiInfo(String method, String uri) {
        if (this.apiInfos == null) {
            return null;
        }
        String uniqueKey = BizSystemModule.buildApiIdentifier(method, uri);
        ApiInfo apiInfo = this.apiInfos.get(uniqueKey);
        if (apiInfo != null) {
            return apiInfo;
        }
        for (Pattern pattern : this.sortedWildcardPatterns) {
            if (!pattern.matcher(uniqueKey).matches()) continue;
            return this.wildcardUris.get(pattern);
        }
        return null;
    }

    public static String resolveFullUri(BizSystemModule module, String uri) {
        String routePath = "/" + module.getFirstRouteName() + "/";
        if (module.isGateway()) {
            if (uri.startsWith(GatewayConfigs.PATH_PREFIX + "/")) {
                return uri;
            }
            return GatewayConfigs.PATH_PREFIX + uri;
        }
        if (module.getStripPrefix() == 1) {
            if (uri.startsWith(module.getUriPrefix() + "/")) {
                return uri;
            }
            if (uri.startsWith(routePath)) {
                return GatewayConfigs.PATH_PREFIX + uri;
            }
            return module.getUriPrefix() + uri;
        }
        if (uri.startsWith(module.getUriPrefix())) {
            return uri;
        }
        if (module.contextPath != null && uri.startsWith(module.contextPath)) {
            uri = uri.substring(module.contextPath.length() + 1);
        }
        uri = String.format("%s/%s", module.getUriPrefix(), uri);
        return uri.replace("//", "/");
    }

    public static String buildApiIdentifier(String method, String uri) {
        return method + "_" + uri;
    }

    public String getMetadataUri() {
        if (this.getServiceBaseUrl() == null || this.isSubGateway()) {
            return null;
        }
        return this.getServiceBaseUrl() + "/metadata";
    }

    public String getInfoUri() {
        if (this.getServiceBaseUrl() == null || this.isSubGateway()) {
            return null;
        }
        return this.getServiceBaseUrl() + "/exporter/info";
    }

    public String getHealthUri() {
        if (this.getServiceBaseUrl() == null) {
            return null;
        }
        return this.getServiceBaseUrl() + "/actuator/health";
    }

    public boolean isGlobalAnonymous(String uri) {
        return this.anonymousUriMatcher.match(uri);
    }

    public void format() {
        String firstRoute = this.getResolveRouteNames().get(0);
        if (this.getMetadata().containsKey("StripPrefix")) {
            this.getMetadata().put("stripPrefix", this.getMetadata().remove("StripPrefix"));
        }
        if (!this.getMetadata().isEmpty()) {
            Field[] fields;
            BeanUtils.copy(this.getMetadata(), (Object)this);
            for (Field field : fields = FieldUtils.getAllFields(this.getClass())) {
                this.getMetadata().remove(field.getName());
            }
        }
        if (!this.getMetadata().isEmpty()) {
            HashMap<String, Object> _metadata = new HashMap<String, Object>();
            this.getMetadata().forEach((k, v) -> {
                if (routeMetadataDefines.containsKey(k)) {
                    _metadata.put(routeMetadataDefines.get(k), v);
                } else {
                    _metadata.put((String)k, v);
                }
            });
            this.metadata = _metadata;
        }
        if (StringUtils.countMatches((CharSequence)this.proxyUri, (CharSequence)"/") > 2) {
            String removeSchema = StringUtils.splitByWholeSeparator((String)this.proxyUri, (String)"://")[1];
            this.contextPath = removeSchema.substring(removeSchema.indexOf("/"));
        }
        if (this.stripPrefix < 0) {
            this.stripPrefix = StringUtils.countMatches((CharSequence)firstRoute, (CharSequence)"/") + 1;
            if (StringUtils.isNotBlank((CharSequence)GatewayConfigs.PATH_PREFIX)) {
                this.stripPrefix += StringUtils.countMatches((CharSequence)GatewayConfigs.PATH_PREFIX, (CharSequence)"/");
            }
            if (this.contextPath != null) {
                this.stripPrefix = this.stripPrefix - StringUtils.countMatches((CharSequence)firstRoute.replace(this.contextPath, ""), (CharSequence)"/") - 1;
            }
        }
        if (!this.isGateway() && !this.getProxyUri().contains("ws://")) {
            if (this.getProxyUri().startsWith("http")) {
                this.serviceBaseUrl = this.getProxyUri();
            } else if (this.getProxyUri().startsWith("lb://")) {
                this.serviceBaseUrl = this.getProxyUri().replace("lb://", "http://");
            }
            if (this.serviceBaseUrl != null) {
                String rootUrl = WebUtils.getBaseUrl((String)this.serviceBaseUrl);
                if (this.stripPrefix == 0) {
                    this.serviceBaseUrl = rootUrl + GatewayConfigs.PATH_PREFIX;
                } else {
                    int fromPathIndex = this.stripPrefix - StringUtils.countMatches((CharSequence)GatewayConfigs.PATH_PREFIX, (CharSequence)"/");
                    String[] routeParts = StringUtils.split((String)this.getFirstRouteName(), (String)"/");
                    this.serviceBaseUrl = rootUrl;
                    boolean buildContextPath = this.contextPath == null;
                    for (int i = fromPathIndex; i < routeParts.length; ++i) {
                        this.serviceBaseUrl = this.serviceBaseUrl + "/" + routeParts[i];
                        if (!buildContextPath) continue;
                        this.contextPath = StringUtils.trimToEmpty((String)this.contextPath) + "/" + routeParts[i];
                    }
                }
            }
        }
        if (!this.isGateway() && !this.proxyUri.contains("ws://")) {
            URI uri = URI.create(this.proxyUri);
            this.proxyUri = uri.getScheme() + "://" + uri.getAuthority();
        }
        if (this.contextPath != null && this.rewriteUriPrefix == null) {
            if (this.isSubGateway()) {
                if (!GatewayConfigs.PATH_PREFIX.equals(this.contextPath) && this.stripPrefix == 0) {
                    this.rewriteUriPrefix = this.contextPath;
                }
            } else if (!this.getUriPrefix().endsWith(this.contextPath)) {
                this.rewriteUriPrefix = this.contextPath;
            }
        }
        this.formatGlobalAnonymousUris();
    }

    private void formatGlobalAnonymousUris() {
        if (this.isGateway()) {
            this.anonymousUriMatcher.addUriPattern(GatewayConfigs.PATH_PREFIX, "/error");
            this.anonymousUriMatcher.addUriPattern(GatewayConfigs.PATH_PREFIX, "/logout");
        }
        if (this.anonymousUris != null) {
            ArrayList<String> uriPatterns = new ArrayList<String>(Arrays.asList(StringUtils.split((String)this.anonymousUris, (String)";,")));
            for (String uriPattern : uriPatterns) {
                if (StringUtils.isBlank((CharSequence)uriPattern)) continue;
                String fullPattern = BizSystemModule.resolveFullUri(this, uriPattern);
                this.anonymousUriMatcher.addUriPattern("", fullPattern);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.routeName == null ? 0 : this.routeName.hashCode());
        result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BizSystemModule other = (BizSystemModule)obj;
        if (this.routeName == null ? other.routeName != null : !this.routeName.equals(other.routeName)) {
            return false;
        }
        return !(this.serviceId == null ? other.serviceId != null : !this.serviceId.equals(other.serviceId));
    }

    public String toString() {
        return "BizSystemModule [id=" + this.id + ", serviceId=" + this.serviceId + ", routeName=" + this.routeName + ", stripPrefix=" + this.stripPrefix + ", global=" + this.global + ", contextPath=" + this.contextPath + ", uriPrefix=" + this.uriPrefix + "]";
    }
}

