/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.model;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.gateway.GatewayConstants;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.springframework.web.server.ServerWebExchange;

public class FallbackRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String serviceId;
    private String uriKey;
    private boolean breakerMode;
    private String strategy;
    private String fallbackSourceKey;
    private String fallbackContent;
    private String hitType;
    private List<String> hitValues;

    public FallbackRule() {
    }

    public FallbackRule(GatewayConstants.FallbackStrategy strategy) {
        this.strategy = strategy.name();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getUriKey() {
        return this.uriKey;
    }

    public void setUriKey(String uriKey) {
        this.uriKey = uriKey;
    }

    public boolean isBreakerMode() {
        return this.breakerMode;
    }

    public void setBreakerMode(boolean breakerMode) {
        this.breakerMode = breakerMode;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getFallbackSourceKey() {
        return this.fallbackSourceKey;
    }

    public void setFallbackSourceKey(String fallbackSourceKey) {
        this.fallbackSourceKey = fallbackSourceKey;
    }

    public String getFallbackContent() {
        return this.fallbackContent;
    }

    public void setFallbackContent(String fallbackContent) {
        this.fallbackContent = fallbackContent;
    }

    public String getHitType() {
        return this.hitType;
    }

    public void setHitType(String hitType) {
        this.hitType = hitType;
    }

    public List<String> getHitValues() {
        return this.hitValues;
    }

    public void setHitValues(List<String> hitValues) {
        this.hitValues = hitValues;
    }

    public boolean currentMatch(ServerWebExchange exchange) {
        String currentKey = null;
        if (this.hitType == null || GatewayConstants.HitType.any.name().equals(this.hitType)) {
            return true;
        }
        if (GatewayConstants.HitType.clientIp.name().equals(this.hitType)) {
            currentKey = RequestContextHelper.getIpAddr(exchange.getRequest());
        } else if (GatewayConstants.HitType.user.name().equals(this.hitType)) {
            currentKey = CurrentRuntimeContext.getCurrentUserId();
        } else if (GatewayConstants.HitType.tenant.name().equals(this.hitType)) {
            currentKey = CurrentRuntimeContext.getTenantId();
        } else if (GatewayConstants.HitType.system.name().equals(this.hitType) && (currentKey = CurrentRuntimeContext.getSystemId()) == null) {
            currentKey = exchange.getRequest().getHeaders().getFirst("x-open-clientId");
        }
        if (currentKey == null) {
            return false;
        }
        return this.hitValues == null || this.hitValues.isEmpty() || this.hitValues.contains(currentKey);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hitType == null ? 0 : this.hitType.hashCode());
        result = 31 * result + (this.uriKey == null ? 0 : this.uriKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FallbackRule other = (FallbackRule)obj;
        if (this.hitType == null ? other.hitType != null : !this.hitType.equals(other.hitType)) {
            return false;
        }
        return !(this.uriKey == null ? other.uriKey != null : !this.uriKey.equals(other.uriKey));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }
}

