/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.model.ApiInfo;
import org.dromara.mendmix.gateway.GatewayConstants;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.springframework.web.server.ServerWebExchange;

public class RatelimitStrategy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String serviceId;
    private String uriKey;
    private double permitsPerSecond = 1.0;
    private String hitType;
    private List<String> hitValues;
    @JsonIgnore
    private Pattern uriPattern;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getUriKey() {
        return this.uriKey;
    }

    public void setUriKey(String uriKey) {
        this.uriKey = uriKey;
        if (uriKey != null && uriKey.contains("/*") && uriKey.length() > 2) {
            String regex = StringUtils.replace((String)uriKey, (String)"/*", (String)"/.*");
            this.uriPattern = Pattern.compile(regex);
        }
    }

    public double getPermitsPerSecond() {
        return this.permitsPerSecond;
    }

    public void setPermitsPerSecond(double permitsPerSecond) {
        this.permitsPerSecond = permitsPerSecond;
    }

    public String getHitType() {
        return this.hitType;
    }

    public void setHitType(String hitType) {
        this.hitType = hitType;
    }

    public List<String> getHitValues() {
        return this.hitValues;
    }

    public void setHitValues(List<String> hitValues) {
        this.hitValues = hitValues;
    }

    public Pattern getUriPattern() {
        return this.uriPattern;
    }

    public String resolveHitKey(ServerWebExchange exchange, String serviceId, ApiInfo apiInfo) {
        if (this.hitType == null || GatewayConstants.HitType.any.name().equals(this.hitType)) {
            return GatewayConstants.HitType.any.name();
        }
        String currentKey = null;
        if (GatewayConstants.HitType.clientIp.name().equals(this.hitType)) {
            currentKey = RequestContextHelper.getIpAddr(exchange.getRequest());
        } else if (GatewayConstants.HitType.user.name().equals(this.hitType)) {
            currentKey = CurrentRuntimeContext.getCurrentUserId();
        } else if (GatewayConstants.HitType.tenant.name().equals(this.hitType)) {
            currentKey = CurrentRuntimeContext.getTenantId();
        } else if (GatewayConstants.HitType.system.name().equals(this.hitType) && (currentKey = CurrentRuntimeContext.getSystemId()) == null) {
            currentKey = exchange.getRequest().getHeaders().getFirst("x-open-clientId");
        }
        if (currentKey == null || this.hitValues != null && !this.hitValues.isEmpty() && !this.hitValues.contains(currentKey)) {
            return null;
        }
        return serviceId + apiInfo.getIdentifier() + this.hitType + currentKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hitType == null ? 0 : this.hitType.hashCode());
        result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
        result = 31 * result + (this.uriKey == null ? 0 : this.uriKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RatelimitStrategy other = (RatelimitStrategy)obj;
        if (this.hitType == null ? other.hitType != null : !this.hitType.equals(other.hitType)) {
            return false;
        }
        if (this.serviceId == null ? other.serviceId != null : !this.serviceId.equals(other.serviceId)) {
            return false;
        }
        return !(this.uriKey == null ? other.uriKey != null : !this.uriKey.equals(other.uriKey));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }
}

