/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.router;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.gateway.CurrentSystemHolder;
import org.dromara.mendmix.gateway.GatewayConfigs;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.dromara.mendmix.spring.CommonApplicationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionRepository;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.context.ApplicationListener;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CustomRouteDefinitionRepository
implements RouteDefinitionRepository,
ApplicationListener<CommonApplicationEvent> {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.adapter.gateway");
    private static AtomicReference<Map<String, RouteDefinition>> routeHub = new AtomicReference();
    private volatile boolean refreshable = true;

    public Flux<RouteDefinition> getRouteDefinitions() {
        if (!this.refreshable) {
            return Flux.fromIterable(routeHub.get().values());
        }
        List<BizSystemModule> modules = CurrentSystemHolder.getAndLoadModules();
        HashMap<String, RouteDefinition> routeDefs = new HashMap<String, RouteDefinition>(modules.size());
        ArrayList<String> existsPathDefs = new ArrayList<String>();
        for (BizSystemModule module : modules) {
            if (GlobalContext.APPID.equals(module.getServiceId()) || routeDefs.containsKey(module.getServiceId())) continue;
            this.loadDynamicRouteDefinition(module, routeDefs, existsPathDefs);
        }
        if (!routeDefs.isEmpty()) {
            routeHub.set(routeDefs);
            StringBuilder message = new StringBuilder("\n================final RouteMapping begin===============\n");
            for (RouteDefinition route : routeHub.get().values()) {
                this.buildRouteLogMessage(message, route);
            }
            message.append("================final RouteMapping end===============\n");
            logger.info(message.toString());
        } else {
            routeHub.set(new HashMap());
        }
        this.refreshable = false;
        return Flux.fromIterable(routeHub.get().values());
    }

    public Mono<Void> save(Mono<RouteDefinition> routes) {
        if (routeHub.get() == null) {
            routeHub.set(new HashMap());
        }
        routes.flatMap(routeDef -> {
            routeHub.get().put(routeDef.getId(), (RouteDefinition)routeDef);
            return Mono.empty();
        });
        return Mono.empty();
    }

    public void loadDynamicRouteDefinition(BizSystemModule module, Map<String, RouteDefinition> routeDefs, List<String> existsPathDefs) {
        String proxyUri = module.getProxyUri();
        int stripPrefix = module.getStripPrefix();
        RouteDefinition routeDef = new RouteDefinition();
        if (module.isSubGateway()) {
            routeDef.setId(module.getServiceId());
        } else {
            String id = String.format("%s_%s_%s", module.getServiceId(), module.getFirstRouteName(), StringUtils.trimToEmpty((String)module.getId()));
            routeDef.setId(id);
        }
        routeDef.setUri(URI.create(proxyUri));
        routeDef.setPredicates(new ArrayList(1));
        List<String> subRoutes = module.getResolveRouteNames();
        StringBuilder pathBuilder = new StringBuilder("Path=");
        for (String sub : subRoutes) {
            String pathDefinition = stripPrefix == 0 && ("/" + sub).startsWith(GatewayConfigs.PATH_PREFIX + "/") ? String.format("/%s/**", sub) : String.format("%s/%s/**", GatewayConfigs.PATH_PREFIX, sub);
            if (existsPathDefs.contains(pathDefinition)) {
                logger.warn("<startup-logging>  \u5ffd\u7565\u91cd\u590d\u8f6c\u53d1\u8def\u5f84:{} for module:{}", (Object)pathDefinition, (Object)module.getServiceId());
                continue;
            }
            pathBuilder.append(pathDefinition);
            pathBuilder.append(",");
            existsPathDefs.add(pathDefinition);
        }
        if (pathBuilder.length() == 5) {
            return;
        }
        pathBuilder.deleteCharAt(pathBuilder.length() - 1);
        routeDef.getPredicates().add(new PredicateDefinition(pathBuilder.toString()));
        routeDef.setFilters(new ArrayList(1));
        routeDef.getFilters().add(new FilterDefinition("StripPrefix=" + stripPrefix));
        if (!module.getMetadata().isEmpty()) {
            routeDef.getMetadata().putAll(module.getMetadata());
        }
        module.setRouteDefinition(routeDef);
        routeDefs.put(routeDef.getId(), routeDef);
    }

    public Mono<Void> delete(Mono<String> routeId) {
        return routeId.flatMap(id -> {
            if (routeHub.get() != null && routeHub.get().containsKey(id)) {
                routeHub.get().remove(id);
                return Mono.empty();
            }
            return Mono.defer(() -> Mono.error((Throwable)new NotFoundException("RouteDefinition not found: " + routeId)));
        });
    }

    private void buildRouteLogMessage(StringBuilder message, RouteDefinition route) {
        FilterDefinition stripPrefixDef;
        message.append(route.getId()).append(":[");
        message.append("url:").append(route.getUri()).append(",");
        PredicateDefinition pathDef = route.getPredicates().stream().filter(p -> "Path".equals(p.getName())).findFirst().orElse(null);
        String routeName = "";
        if (pathDef != null) {
            String argValue = (String)pathDef.getArgs().get("_genkey_0");
            routeName = argValue.substring(GatewayConfigs.PATH_PREFIX.length() + 1);
            routeName = routeName.substring(0, routeName.lastIndexOf("/"));
            message.append("routeName:").append(routeName);
            message.append(",path:").append(argValue);
        }
        if ((stripPrefixDef = (FilterDefinition)route.getFilters().stream().filter(p -> "StripPrefix".equals(p.getName())).findFirst().orElse(null)) != null) {
            message.append(",stripPrefix:").append((String)stripPrefixDef.getArgs().get("_genkey_0"));
        }
        message.append("]\n");
    }

    public void reload() {
        this.refreshable = true;
        CurrentSystemHolder.reload();
        this.getRouteDefinitions();
    }

    public void onApplicationEvent(CommonApplicationEvent event) {
        if (routeHub.get() == null) {
            return;
        }
        List configs = (List)event.getEventData();
        if (configs.stream().anyMatch(o -> o.getName().startsWith("spring.cloud.gateway.routes"))) {
            this.reload();
            logger.info(">> \u6536\u5230ConfigChangeEvent,route refresh ok");
        }
    }
}

