/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dromara.mendmix.common.async.AsyncInitializer;
import org.dromara.mendmix.common.http.HttpMethod;
import org.dromara.mendmix.common.model.ApiInfo;
import org.dromara.mendmix.common.model.ApiModel;
import org.dromara.mendmix.gateway.CurrentSystemHolder;
import org.dromara.mendmix.gateway.GatewayConfigs;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.dromara.mendmix.security.SecurityDecisionProvider;
import org.dromara.mendmix.security.SecurityDelegating;
import org.dromara.mendmix.security.model.ApiPermission;
import org.dromara.mendmix.security.util.ApiPermssionHelper;
import org.dromara.mendmix.spring.DataChangeEvent;
import org.springframework.context.ApplicationListener;

public abstract class GatewaySecurityDecisionProvider
extends SecurityDecisionProvider
implements AsyncInitializer,
ApplicationListener<DataChangeEvent> {
    public boolean isServletType() {
        return false;
    }

    public List<ApiModel> anonymousUris() {
        ArrayList<ApiModel> apis = new ArrayList<ApiModel>();
        apis.add(new ApiModel(HttpMethod.GET, GatewayConfigs.PATH_PREFIX + "/actuator/health"));
        apis.add(new ApiModel(HttpMethod.GET, GatewayConfigs.PATH_PREFIX + "/oauth2/*"));
        return apis;
    }

    public List<ApiPermission> getAllApiPermissions() {
        List<BizSystemModule> modules = CurrentSystemHolder.getModules();
        ArrayList<ApiPermission> result = new ArrayList<ApiPermission>();
        for (BizSystemModule module : modules) {
            if (module.getApiInfos() == null) continue;
            Collection<ApiInfo> apis = module.getApiInfos().values();
            for (ApiInfo apiInfo : apis) {
                ApiPermission apiPermission = new ApiPermission();
                apiPermission.setPermissionLevel(apiInfo.getPermissionLevel());
                apiPermission.setMethod(apiInfo.getMethod());
                apiPermission.setUri(apiInfo.getUri());
                result.add(apiPermission);
            }
        }
        return result;
    }

    public void doInitialize() {
        SecurityDelegating.init();
    }

    public void onApplicationEvent(DataChangeEvent event) {
        if (event.getDataType().equals("moduleApis")) {
            ApiPermssionHelper.reload();
        }
    }
}

