/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.security;

import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.util.TokenGenerator;
import org.dromara.mendmix.gateway.GatewayConfigs;
import org.dromara.mendmix.gateway.helper.RequestContextHelper;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class SpecUnauthorizedHandler {
    public boolean customAuthentication(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        boolean pass = false;
        if (!RequestContextHelper.getCurrentModule(exchange).isGateway()) {
            boolean bl = pass = GatewayConfigs.openApiEnabled && request.getHeaders().containsKey((Object)"x-open-sign");
        }
        if (!pass) {
            pass = this.isIpWhilelistAccess(request);
        }
        if (!pass) {
            pass = this.isInternalTrustedAccess(request);
        }
        if (!pass) {
            pass = this.isCrossClusterTrustedAccess(request);
        }
        return pass;
    }

    private boolean isIpWhilelistAccess(ServerHttpRequest request) {
        String clientIp;
        return !GatewayConfigs.anonymousIpWhilelist.isEmpty() && GatewayConfigs.anonymousIpWhilelist.contains(clientIp = RequestContextHelper.getIpAddr(request));
    }

    private boolean isInternalTrustedAccess(ServerHttpRequest request) {
        String header = request.getHeaders().getFirst("x-internal-request");
        if (Boolean.parseBoolean(header) && this.validateInvokeToken(request)) {
            ThreadLocalContext.set((String)"ctx-trusted-request", (Object)Boolean.TRUE);
            return true;
        }
        return false;
    }

    private boolean isCrossClusterTrustedAccess(ServerHttpRequest request) {
        boolean crossCluster = false;
        try {
            String clusterName = request.getHeaders().getFirst("x-cluster-id");
            if (StringUtils.isNotBlank((CharSequence)clusterName) && this.validateInvokeToken(request)) {
                ThreadLocalContext.set((String)"ctx-trusted-request", (Object)Boolean.TRUE);
                crossCluster = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return crossCluster;
    }

    private boolean validateInvokeToken(ServerHttpRequest request) {
        String token = request.getHeaders().getFirst("x-invoke-token");
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        try {
            TokenGenerator.validate((String)token, (boolean)true);
            return true;
        }
        catch (Exception e) {
            System.err.println("validate [x-invoke-token = " + token + "] error" + e.getMessage());
            return false;
        }
    }
}

