/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.gateway.task;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.http.HttpRequestEntity;
import org.dromara.mendmix.common.model.ApiInfo;
import org.dromara.mendmix.common.task.SubTimerTask;
import org.dromara.mendmix.common.util.DateUtils;
import org.dromara.mendmix.gateway.CurrentSystemHolder;
import org.dromara.mendmix.gateway.model.BizSystem;
import org.dromara.mendmix.gateway.model.BizSystemModule;
import org.dromara.mendmix.spring.DataChangeEvent;
import org.dromara.mendmix.spring.InstanceFactory;
import org.dromara.mendmix.springweb.exporter.AppMetadataHolder;
import org.dromara.mendmix.springweb.model.AppMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class ModuleApiRefreshTask
implements SubTimerTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.gateway");
    private static Date lastUpdateTime = new Date();

    public void doSchedule() {
        List<BizSystem> systems = CurrentSystemHolder.getSystems();
        boolean changed = false;
        for (BizSystem system : systems) {
            for (BizSystemModule module : system.getModules()) {
                if (module.getApiInfos() != null && !this.moduleMetaChanged(module)) continue;
                ModuleApiRefreshTask.initModuleApiInfos(module);
                changed = true;
            }
        }
        if (changed) {
            InstanceFactory.getContext().publishEvent((ApplicationEvent)new DataChangeEvent("moduleApis", new Object()));
        }
    }

    public long delay() {
        return 30000L;
    }

    public long interval() {
        return 30000L;
    }

    protected boolean moduleMetaChanged(BizSystemModule module) {
        if (!module.isWithMetadata()) {
            return false;
        }
        try {
            Date currentTime = new Date();
            String value = HttpRequestEntity.get((String)module.getInfoUri()).backendInternalCall().execute().toValue("startTime");
            Date newUpdateTime = DateUtils.parseDate((String)value);
            boolean changed = newUpdateTime.after(lastUpdateTime);
            if (changed) {
                logger.info(">> service:{} version changed", (Object)module.getServiceId());
            }
            lastUpdateTime = currentTime;
            return changed;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean initModuleApiInfos(BizSystemModule module) {
        List apiInfos = null;
        try {
            if (module.isGateway()) {
                apiInfos = AppMetadataHolder.getMetadata().getApis();
            } else {
                String url = module.getMetadataUri();
                if (url == null) {
                    return true;
                }
                logger.debug("MENDMIX-TRACE-LOGGGING-->> initModuleApiInfos begin -> serviceId:{},url:{}", (Object)module.getServiceId(), (Object)url);
                apiInfos = ((AppMetadata)HttpRequestEntity.get((String)url).execute().toObject(AppMetadata.class)).getApis();
            }
        }
        catch (Exception e) {
            boolean ignore = e instanceof NullPointerException;
            if (!ignore && e instanceof MendmixBaseException) {
                MendmixBaseException ex = (MendmixBaseException)((Object)e);
                boolean bl = ignore = ex.getCode() == 404 || ex.getCode() == 401 || ex.getCode() == 403;
            }
            if (!ignore) {
                return false;
            }
            logger.warn("MENDMIX-TRACE-LOGGGING-->> initModuleApiInfos error -> serviceId:{},error:{}", (Object)module.getServiceId(), (Object)e.getMessage());
        }
        if (apiInfos != null) {
            for (ApiInfo api : apiInfos) {
                module.addApiInfo(api);
            }
            if (module.getApiInfos() == null) {
                module.setApiInfos(new HashMap<String, ApiInfo>(0));
            }
            module.updateOnApiListRefresh();
            logger.info("MENDMIX-TRACE-LOGGGING-->> initModuleApiInfos end -> serviceId:{},apiNums:{}", (Object)module.getServiceId(), (Object)module.getApiInfos().size());
        }
        return true;
    }
}

