/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.common.util.TimeConvertUtils;

public class LogConstants {
    public static final String BASIC = "basic";
    public static final String CONTEXT = "context";
    public static final String TRACE_ID = "traceId";
    public static final String ENV = "env";
    public static final String MAIN_SYSTEM_ID = "mainSystemId";
    public static final String SYSTEM_KEY = "systemKey";
    public static final String SYSTEM_ID = "systemId";
    public static final String SERVICE_ID = "serviceId";
    public static final String DEPLOY_GROUP = "deployGroup";
    public static final String DEPLOY_NAME = "deployName";
    public static final String POD_IP = "podIp";
    public static final String POD_NAME = "podName";
    public static final String TIME_ZONE = "timezone";
    public static final String TIME_OFFSET = "timeOffset";
    public static final String GATEWAY = "gateway";
    public static final String TENANT_ID = "tenantId";
    public static final String USER_NAME = "userName";
    public static final String USER_ID = "userId";
    public static final String SUBJECT_ID = "subjectId";
    public static final String PLATFORM_TYPE = "platformType";
    public static final String CLIENT_TYPE = "clientType";
    public static final String MESSAGE = "message";
    public static final String THROWN = "thrown";
    public static final String FILE_LINE = "fileLine";
    public static final String THREAD = "thread";
    public static final String LEVEL = "level";
    public static final String TIMESTAMP = "timestamp";
    public static final Map<String, Object> SERVICE_INFO = new LinkedHashMap<String, Object>();
    public static final List<String> LOGGING_REQUEST_HEADERS = new ArrayList<String>(Arrays.asList("Content-Type", "x-tenant-id", "x-request-id", "x-client-type", "x-system-id", "x-bunit-id", "x-forwarded-service-chain", "Accept-Language", "x-timezone", "x-referer-permGroup", "x-forwarded-gateway", "x-trace-logging"));
    public static final List<String> LOGGING_GATEWAY_REQUEST_HEADERS = new ArrayList<String>(Arrays.asList("Referer", "User-Agent", "x-forwarded-gateway", "x-forwarded-service-chain"));
    public static final List<String> LOGGING_RESPONSE_HEADERS = new ArrayList<String>(Arrays.asList("Content-Type", "Content-Length"));

    static {
        SERVICE_INFO.put(ENV, GlobalContext.ENV.toUpperCase());
        SERVICE_INFO.put(SYSTEM_KEY, GlobalContext.SYSTEM_KEY);
        SERVICE_INFO.put(SERVICE_ID, GlobalContext.APPID);
        SERVICE_INFO.put(GATEWAY, GlobalContext.isGateway());
        SERVICE_INFO.put(TIME_ZONE, TimeConvertUtils.localTimeZoneId);
        SERVICE_INFO.put(TIME_OFFSET, TimeConvertUtils.TIME_ZONE_OFFSET);
        SERVICE_INFO.put(POD_IP, ResourceUtils.getAnyProperty((String[])new String[]{"POD_IP"}));
        SERVICE_INFO.put(POD_NAME, ResourceUtils.getAnyProperty((String[])new String[]{"POD_NAME"}));
    }

    public static enum LogSubType {
        userBehaviorLog,
        pageTraceLog,
        requestTraceLog,
        appBizLog,
        userEnvLog;

    }
}

