/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.logging;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.StringSerializer;
import org.dromara.mendmix.cache.CacheUtils;
import org.dromara.mendmix.common.util.ExceptionFormatUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class LogKafkaClient
implements InitializingBean,
DisposableBean {
    private KafkaProducer<String, String> kafkaProducer;
    private String kafkaServers;

    public LogKafkaClient(String kafkaServers) {
        this.kafkaServers = kafkaServers;
    }

    public void send(String topic, String logJson) {
        ProducerRecord producerRecord = new ProducerRecord(topic, (Object)logJson);
        this.kafkaProducer.send(producerRecord, new Callback(){

            public void onCompletion(RecordMetadata recordMetadata, Exception e) {
                if (e != null && CacheUtils.setIfAbsent((String)"kafka_send_error_counter", (Object)"1", (long)30L, (TimeUnit)TimeUnit.SECONDS)) {
                    System.err.println("send_log_error:" + ExceptionFormatUtils.buildExceptionMessages((Throwable)e, (int)2));
                }
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)ResourceUtils.getMappingValues((String)"mendmix-cloud.logging.loghandle.kafka"));
        props.put("bootstrap.servers", this.kafkaServers);
        if (!props.containsKey("key.serializer")) {
            props.put("key.serializer", StringSerializer.class.getName());
        }
        if (!props.containsKey("value.serializer")) {
            props.put("value.serializer", StringSerializer.class.getName());
        }
        if (!props.containsKey("retries")) {
            props.setProperty("retries", "0");
        }
        if (!props.containsKey("acks")) {
            props.setProperty("acks", "0");
        }
        if (!props.containsKey("compression.type")) {
            props.setProperty("compression.type", "lz4");
        }
        if (!props.containsKey("buffer.memory")) {
            props.setProperty("buffer.memory", "33554432");
        }
        if (!props.containsKey("max.block.ms")) {
            props.setProperty("max.block.ms", "60000");
        }
        if (!props.containsKey("batch.size")) {
            props.setProperty("batch.size", "16384");
        }
        if (!props.containsKey("linger.ms")) {
            props.setProperty("linger.ms", "5");
        }
        if (!props.containsKey("max.in.flight.requests.per.connection")) {
            props.setProperty("max.in.flight.requests.per.connection", "5");
        }
        this.kafkaProducer = new KafkaProducer(props);
    }

    public void destroy() throws Exception {
        this.kafkaProducer.close();
    }
}

