/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.logging.applog;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.util.IpUtils;
import org.dromara.mendmix.common.util.ResourceUtils;

public class LogProfileManager {
    private static JarFile jarFile;
    private static long lastTime;
    private static final long PERIOD = 300000L;
    private static final String TRACE_KEY = "trace_0d8gstj";
    private static Method lcsMethod;

    public static void initialize() {
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        InputStream in = LogProfileManager.loadFileInputStream("log4j2.xml");
        if (in != null) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        LogProfileManager.initLog4j2WithoutConfigFile();
    }

    private static void initLog4j2WithoutConfigFile() {
        System.out.println("no local log4j2.xml file found,init logContext");
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.DEBUG);
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d [%t] %c{2} %-5level: %msg%n%throwable"));
        appenderBuilder.add((FilterComponentBuilder)builder.newFilter("MarkerFilter", Filter.Result.DENY, Filter.Result.NEUTRAL).addAttribute("marker", "FLOW"));
        builder.add(appenderBuilder);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("com.zy", Level.DEBUG).add(builder.newAppenderRef("Stdout"))).addAttribute("additivity", true));
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("com.jeesuite", Level.TRACE).add(builder.newAppenderRef("Stdout"))).addAttribute("additivity", true));
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.ibatis", Level.DEBUG).add(builder.newAppenderRef("Stdout"))).addAttribute("additivity", true));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.INFO).add(builder.newAppenderRef("Stdout")));
        Configurator.initialize((Configuration)((Configuration)builder.build()));
    }

    public static void trace() {
        block4: {
            if (lcsMethod == null) {
                return;
            }
            if (ThreadLocalContext.exists((String)TRACE_KEY) || System.currentTimeMillis() - lastTime < 300000L) {
                return;
            }
            try {
                lcsMethod.invoke(null, new Object[0]);
                lastTime = System.currentTimeMillis();
                ThreadLocalContext.set((String)TRACE_KEY, (Object)TRACE_KEY);
            }
            catch (Exception e) {
                Throwable throwable = ExceptionUtils.getRootCause((Throwable)e);
                if (!(throwable instanceof MendmixBaseException)) break block4;
                throw (MendmixBaseException)throwable;
            }
        }
    }

    public static void reload() {
        if (!ResourceUtils.getBoolean((String)"log.reload.enabled", (boolean)true)) {
            return;
        }
        System.setProperty("systemId", GlobalContext.SYSTEM_KEY);
        System.setProperty("appId", GlobalContext.APPID);
        System.setProperty("env", GlobalContext.ENV);
        String nodeName = System.getenv("POD_IP");
        if (StringUtils.isBlank((CharSequence)nodeName)) {
            nodeName = IpUtils.getLocalIpAddr();
        }
        System.setProperty("nodeName", nodeName);
        String logBasePath = ResourceUtils.getAnyProperty((String[])new String[]{"log.output.dir", "mendmix-cloud.data.dir"});
        if (StringUtils.isBlank((CharSequence)logBasePath)) {
            logBasePath = "./logs";
        }
        if (logBasePath.endsWith("/")) {
            logBasePath = logBasePath.substring(0, logBasePath.length() - 1);
        }
        System.setProperty("log.output.dir", logBasePath);
        LogProfileManager.reloadLog4j2WithXmlConfigFile();
    }

    private static void reloadLog4j2WithXmlConfigFile() {
        LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
        String profile = ResourceUtils.getProperty((String)"log.profile", (String)"default");
        if (profile.startsWith("${")) {
            profile = "default";
        }
        System.out.println(">>Reload log4j2 Configs:");
        System.out.println(" - log.profile          =    " + profile);
        if ("file".equals(profile)) {
            System.out.println("log.output.dir =    " + System.getProperty("log.output.dir"));
        }
        Properties properties = ResourceUtils.getAllProperties((String)"log.");
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        boolean withLogLevelItem = false;
        for (Map.Entry<Object, Object> entry : entrySet) {
            String key = entry.getKey().toString();
            if (!key.endsWith(".level")) continue;
            withLogLevelItem = true;
            System.setProperty(key, entry.getValue().toString());
            System.out.println(" - " + key + "   =   " + entry.getValue());
        }
        if ("default".equals(profile)) {
            if (withLogLevelItem) {
                logContext.reconfigure();
                System.out.println("LoggerContext[" + logContext.getName() + "] reconfigured!");
            }
            return;
        }
        String log4jConfFileName = "log4j2-" + profile + ".xml";
        try {
            InputStream in = LogProfileManager.loadFileInputStream(log4jConfFileName);
            if (in == null) {
                System.err.println("not found log4j configure file[" + log4jConfFileName + "] in classpath");
                return;
            }
            System.out.println("reload log4j from config:" + log4jConfFileName);
            XmlConfigurationFactory factory = new XmlConfigurationFactory();
            LogManager.shutdown((boolean)true, (boolean)true);
            Configuration configuration = null;
            while (logContext.isStopping()) {
            }
            configuration = factory.getConfiguration(logContext, new ConfigurationSource(in));
            URI uri = Thread.currentThread().getContextClassLoader().getResource(log4jConfFileName).toURI();
            logContext.setConfigLocation(uri);
            StatusLogger.getLogger().reset();
            logContext.start(configuration);
            System.out.println("LoggerContext[" + logContext.getName() + "] reload...");
            while (logContext.isStarting()) {
            }
            if (logContext.isStarted()) {
                System.out.println("LoggerContext[" + logContext.getName() + "] is started!");
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            jarFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static InputStream loadFileInputStream(String fileName) {
        URL url = Thread.currentThread().getContextClassLoader().getResource("");
        try {
            if (url.getProtocol().equals("file")) {
                File logConfigFile = new File(url.getPath(), fileName);
                if (!logConfigFile.exists()) {
                    return null;
                }
                return new FileInputStream(logConfigFile);
            }
            if (url.getProtocol().equals("jar")) {
                String jarFilePath = url.getFile();
                if (jarFilePath.contains("war!")) {
                    jarFilePath = StringUtils.splitByWholeSeparator((String)jarFilePath, (String)"war!")[0] + "war";
                } else if (jarFilePath.contains("jar!")) {
                    jarFilePath = StringUtils.splitByWholeSeparator((String)jarFilePath, (String)"jar!")[0] + "jar";
                }
                jarFilePath = jarFilePath.substring("file:".length());
                jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
                jarFile = new JarFile(jarFilePath);
                Enumeration<JarEntry> entries = jarFile.entries();
                InputStream inputStream = null;
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(fileName)) continue;
                    inputStream = jarFile.getInputStream(jarFile.getJarEntry(entry.getName()));
                    break;
                }
                return inputStream;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

