/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.logging.applog.appender;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.JsonLayout;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.model.AuthUser;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.logging.LogConstants;
import org.dromara.mendmix.logging.LogKafkaClient;
import org.dromara.mendmix.spring.InstanceFactory;

@Plugin(name="PlatfromAppender", category="Core", elementType="appender", printObject=true)
public class PlatfromAppender
extends AbstractAppender {
    private static final String LOG_SEPARATOR = "|";
    private static String topicName = ResourceUtils.getProperty((String)"mendmix-cloud.logging.applog.topicName", (String)"mendmix_topic_appLog");
    private static int maxMessageSizeLimit = 1024;
    private static LogKafkaClient logKafkaClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogKafkaClient getLogKafkaClient() {
        if (logKafkaClient != null) {
            return logKafkaClient;
        }
        Class<PlatfromAppender> clazz = PlatfromAppender.class;
        synchronized (PlatfromAppender.class) {
            if (logKafkaClient != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return logKafkaClient;
            }
            logKafkaClient = (LogKafkaClient)InstanceFactory.getInstance(LogKafkaClient.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return logKafkaClient;
        }
    }

    protected PlatfromAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public void append(LogEvent event) {
        if (PlatfromAppender.getLogKafkaClient() == null) {
            if (!GlobalContext.isStarting()) {
                System.err.println("logKafkaClient not init!!!");
            }
            return;
        }
        byte[] bytes = this.getLayout().toByteArray(event);
        String msg = new String(bytes);
        String[] parts = StringUtils.split((String)msg, (String)LOG_SEPARATOR, (int)5);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("timestamp", parts[0]);
        map.put("level", parts[1]);
        map.put("thread", parts[2]);
        map.put("fileLine", parts[3]);
        String message = parts[4];
        if (message != null && message.length() > maxMessageSizeLimit) {
            message = message.substring(0, maxMessageSizeLimit);
        }
        map.put("message", message);
        this.appendContextParams(map);
        PlatfromAppender.getLogKafkaClient().send(topicName, JsonUtils.toJson(map));
    }

    private void appendContextParams(Map<String, Object> map) {
        AuthUser currentUser;
        map.put("traceId", CurrentRuntimeContext.getRequestId());
        map.put("basic", LogConstants.SERVICE_INFO);
        LinkedHashMap<String, String> context = new LinkedHashMap<String, String>(10);
        String contextVal = CurrentRuntimeContext.getClientType();
        if (contextVal != null) {
            context.put("clientType", contextVal);
        }
        if ((contextVal = CurrentRuntimeContext.getSystemId()) != null) {
            context.put("systemId", contextVal);
        }
        if ((contextVal = CurrentRuntimeContext.getTenantId()) != null) {
            context.put("tenantId", contextVal);
        }
        if ((currentUser = CurrentRuntimeContext.getCurrentUser()) != null) {
            map.put("userId", currentUser.getId());
            map.put("userName", currentUser.getName());
            map.put("subjectId", currentUser.getPrincipalId());
        }
        map.put("context", context);
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        this.setStopped();
        return stopped;
    }

    @PluginFactory
    public static PlatfromAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="queueCapacity") String queueCapacity, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions) {
        if (layout == null) {
            layout = ((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)new JsonLayout.Builder().setCompact(true)).setLocationInfo(true)).setStacktraceAsString(true)).build();
        }
        Validate.notEmpty((CharSequence)name, (String)"name \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return new PlatfromAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, new Property[0]);
    }
}

