/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.logging.reqlog;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.model.ApiInfo;
import org.dromara.mendmix.common.model.WrapperResponse;
import org.dromara.mendmix.common.util.ExceptionFormatUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.LogMessageFormat;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.logging.LogConfigs;
import org.dromara.mendmix.logging.LogConstants;
import org.dromara.mendmix.logging.LogKafkaClient;
import org.dromara.mendmix.logging.reqlog.ApiRequestLog;
import org.dromara.mendmix.spring.InstanceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class RequestLogCollector {
    private static Logger log = LoggerFactory.getLogger((String)"org.dromara.mendmix");
    public static final String CURRENT_API_LOG_CONTEXT_NAME = "ctx_cur_apilog";
    public static final String CURRENT_TRACE_LOG_CONTEXT_NAME = "ctx_cur_tracelog";
    private static boolean taskLogEnabled = ResourceUtils.getBoolean((String)"mendmix-cloud.task.log.enabled", (boolean)true);
    private static LogKafkaClient logKafkaClient;
    private static String apiLogTopic;

    public static ApiRequestLog onRequestStart(HttpServletRequest request, ApiInfo apiInfo) {
        if (logKafkaClient == null) {
            return null;
        }
        if (request.getHeader("x-forwarded-gateway") == null && request.getHeader("x-auth-user") == null) {
            return null;
        }
        ApiRequestLog log = ApiRequestLog.build(request, apiInfo);
        ThreadLocalContext.set((String)CURRENT_API_LOG_CONTEXT_NAME, (Object)log);
        return log;
    }

    public static ApiRequestLog onRequestStart(ServerHttpRequest request, ApiInfo apiInfo) {
        if (logKafkaClient == null) {
            return null;
        }
        HttpHeaders headers = request.getHeaders();
        String userAgent = headers.getFirst("User-Agent");
        if ("backend-client".equals(userAgent)) {
            return null;
        }
        if (!headers.containsKey((Object)"Referer")) {
            return null;
        }
        ApiRequestLog log = ApiRequestLog.build(request, apiInfo);
        return log;
    }

    public static void setApiLogResponseBody(Object body) {
        if (body == null) {
            return;
        }
        if (logKafkaClient == null) {
            return;
        }
        ApiInfo apiInfo = (ApiInfo)ThreadLocalContext.get((String)"_cxt_current_api_");
        boolean withException = false;
        if (!(apiInfo == null || apiInfo.isResponseLog() || CurrentRuntimeContext.hasContextVal((String)"x-requestBody-logging") || (withException = ThreadLocalContext.exists((String)"_context_exception")))) {
            return;
        }
        ApiRequestLog requestLog = (ApiRequestLog)ThreadLocalContext.get((String)CURRENT_API_LOG_CONTEXT_NAME);
        if (requestLog != null) {
            ApiRequestLog.ResponseInfo response = requestLog.getResponse();
            if (response == null) {
                response = new ApiRequestLog.ResponseInfo();
                requestLog.setResponse(response);
            }
            if (withException && body instanceof WrapperResponse) {
                WrapperResponse _body = (WrapperResponse)body;
                body = WrapperResponse.fail((int)_body.getCode(), (String)_body.getBizCode(), (String)_body.getMsg());
            }
            response.body = body;
        }
    }

    public static void onResponseEnd(ApiRequestLog requestLog, Throwable throwable, int httpStatus, Map<String, String> headers) {
        if (throwable != null) {
            if (httpStatus == 0) {
                httpStatus = 500;
            }
            if (throwable instanceof MendmixBaseException) {
                MendmixBaseException be = (MendmixBaseException)throwable;
                if (be.getCode() != 401 && be.getCode() != 403) {
                    log.warn("bizError" + LogMessageFormat.buildLogTail() + ":{}", (Object)ExceptionFormatUtils.buildExceptionMessages((Throwable)throwable, (int)5));
                }
            } else {
                log.error("systemError" + LogMessageFormat.buildLogTail() + ":{}", (Object)ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }
        if (requestLog != null && httpStatus != 404) {
            requestLog.end(throwable, httpStatus, headers, null);
            if (throwable != null && !(throwable instanceof MendmixBaseException)) {
                requestLog.setExceptions(ExceptionFormatUtils.buildExceptionMessages((Throwable)throwable, (int)5));
            }
            if (logKafkaClient != null) {
                logKafkaClient.send(apiLogTopic, JsonUtils.toJson((Object)requestLog));
            }
        }
    }

    public static void onResponseEnd(HttpServletResponse response, Throwable throwable) {
        ApiRequestLog requestLog = (ApiRequestLog)ThreadLocalContext.get((String)CURRENT_API_LOG_CONTEXT_NAME);
        HashMap<String, String> headers = null;
        if (requestLog != null) {
            Collection headerNames = response.getHeaderNames();
            headers = new HashMap<String, String>(headerNames.size());
            for (String name : headerNames) {
                if (!LogConstants.LOGGING_RESPONSE_HEADERS.contains(name)) continue;
                headers.put(name, response.getHeader(name));
            }
        }
        RequestLogCollector.onResponseEnd(requestLog, throwable, response.getStatus(), headers);
    }

    public static void onSystemBackendTaskStart(String actionGroup, String actionKey, String actionName) {
        if (!taskLogEnabled) {
            return;
        }
        ApiRequestLog log = ApiRequestLog.build(actionGroup, actionKey, actionName);
        ThreadLocalContext.set((String)CURRENT_API_LOG_CONTEXT_NAME, (Object)log);
    }

    public static void onSystemBackendTaskEnd(Throwable throwable) {
        ApiRequestLog log = (ApiRequestLog)ThreadLocalContext.get((String)CURRENT_API_LOG_CONTEXT_NAME);
        if (log != null) {
            RequestLogCollector.onResponseEnd(log, throwable, 0, null);
        }
    }

    public static void destroy() {
    }

    static {
        apiLogTopic = ResourceUtils.getProperty((String)"mendmix-cloud.logging.apilog.topicName", (String)"mendmix_topic_apiLog");
        if (LogConfigs.API_LOGGING) {
            logKafkaClient = (LogKafkaClient)InstanceFactory.getInstance(LogKafkaClient.class);
        }
    }
}

