/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.datasource.DataSourceConfig;
import org.dromara.mendmix.mybatis.datasource.DataSoureConfigHolder;
import org.dromara.mendmix.mybatis.datasource.DatabaseType;

public class MybatisConfigs {
    private static Map<String, Properties> groupProperties = new HashMap<String, Properties>();
    private static final String DEFAULT_CONFIG_PREFIX = "mendmix-cloud.";
    public static final String DB_TYPE = "mendmix-cloud.mybatis.dbType";
    public static final String CACHE_ENABLED = "mendmix-cloud.mybatis.cache.enabled";
    public static final String DATA_PERM_ENABLED = "mendmix-cloud.mybatis.dataPermission.enabled";
    public static final String CACHE_EXPIRE_SECONDS = "mendmix-cloud.mybatis.cache.expireSeconds";
    public static final String TENANT_COLUMN_NAME = "mendmix-cloud.mybatis.tenant.columnName";
    public static final String BUNIT_COLUMN_NAME = "mendmix-cloud.mybatis.bUnit.columnName";
    public static final String TENANT_IGNORE_USER_TYPE = "mendmix-cloud.mybatis.tenant.ignoreUserType";
    public static final String INTERCEPTOR_HANDLERCLASS = "mendmix-cloud.mybatis.interceptorHandlerClass";
    public static final String SOFT_DELETE_COLUMN_NAME = "mendmix-cloud.mybatis.softDelete.columnName";
    public static final String SOFT_DELETE_FALSE_VALUE = "mendmix-cloud.mybatis.softDelete.falseValue";
    public static final String CREATED_BY_COLUMN_NAME = "mendmix-cloud.mybatis.createdBy.columnName";
    public static final String DEPT_COLUMN_NAME = "mendmix-cloud.mybatis.department.columnName";
    private static final List<String> ignoreTenantMappperPackages = ResourceUtils.getList((String)"mendmix-cloud.mybatis.ignoreTenantMappperPackages");
    public static final String ORG_DATA_PERM_NAME = ResourceUtils.getProperty((String)"mendmix-cloud.mybatis.dataPermission.orgPermName", (String)"orgPermName");
    public static final boolean DATA_PERM_ALL_MATCH_MODE_ENABLED = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.dataPermission.allMatchMode.enabled", (boolean)true);
    public static final boolean DATA_PERM_HANDLE_OWNER = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.dataPermission.defaultHandleOwner", (boolean)false);
    public static final boolean DATA_PERM_ORG_USING_FULL_CODE_MODE = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.dataPermission.orgUsingFullCodeMode", (boolean)false);
    public static final boolean DATA_PERM_USING_GROUP_MODE = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.dataPermission.groupMode", (boolean)false);
    public static final boolean DATA_PERM_GROUP_MISSING_MATCH_NONE = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.dataPermission.groupMissingMatchNone", (boolean)true);
    public static final boolean DATA_PERM_ORG_ID_USING_CODE = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.dataPermission.orgIdUsingCode", (boolean)false);
    public static final boolean DATA_PERM_MULTI_SCOPE_MODE = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.dataPermission.multiScopeMode");
    public static final boolean DATA_PERM_STRICT_MODE = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.dataPermission.strictMode");
    public static final boolean DATA_PERM_INNER_JOIN_USING_ON = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.dataPermission.innerJoinUsingOn", (boolean)true);
    public static final int DB_OFFSET = ResourceUtils.getInt((String)"mendmix-cloud.using-db-time.offset", (int)0);
    public static final int QUERY_MAX_LIMIT = ResourceUtils.getInt((String)"mendmix-cloud.mybatis.query.maxLimit", (int)10000);
    public static final int UPDATE_MAX_LIMIT = ResourceUtils.getInt((String)"mendmix-cloud.mybatis.update.maxLimit", (int)5000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String group, String key, String defaultValue) {
        if (!groupProperties.containsKey(group)) {
            Map<String, Properties> map = groupProperties;
            synchronized (map) {
                String prefix = DataSourceConfig.DEFAULT_GROUP_NAME.equals(group) ? "mendmix-cloud.mybatis" : group + ".mybatis";
                MybatisConfigs.addProperties(group, ResourceUtils.getAllProperties((String)prefix));
            }
        }
        String value = groupProperties.get(group).getProperty(key);
        String fixedKey = null;
        if (value == null) {
            if (DataSourceConfig.DEFAULT_GROUP_NAME.equals(group) && !key.startsWith(DEFAULT_CONFIG_PREFIX)) {
                fixedKey = DEFAULT_CONFIG_PREFIX + key;
            } else if (key.startsWith(DEFAULT_CONFIG_PREFIX)) {
                fixedKey = key.substring(DEFAULT_CONFIG_PREFIX.length());
            }
            if (fixedKey != null) {
                value = groupProperties.get(group).getProperty(fixedKey);
            }
        }
        if (value == null) {
            value = ResourceUtils.getAnyProperty((String[])new String[]{key, fixedKey});
        }
        return StringUtils.defaultString((String)value, (String)defaultValue);
    }

    private static void addProperties(String group, Properties properties) {
        if (!DataSourceConfig.DEFAULT_GROUP_NAME.equals(group)) {
            String prefix = group + ".";
            Properties _properties = new Properties();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (v != null) {
                    _properties.put(k.toString().replace(prefix, ""), v);
                }
            }));
            properties = _properties;
        }
        groupProperties.put(group, properties);
    }

    public static boolean getBoolean(String group, String key, boolean defaultValue) {
        return Boolean.parseBoolean(MybatisConfigs.getProperty(group, key, String.valueOf(defaultValue)));
    }

    public static String getDbType(String group) {
        return MybatisConfigs.getProperty(group, DB_TYPE, DatabaseType.mysql.name()).toLowerCase();
    }

    public static boolean isCacheEnabled(String group) {
        return MybatisConfigs.getBoolean(group, CACHE_ENABLED, false);
    }

    public static boolean isDataPermissionEnabled(String group) {
        return MybatisConfigs.getBoolean(group, DATA_PERM_ENABLED, false);
    }

    public static String getTenantColumnName(String group) {
        return MybatisConfigs.getProperty(group, TENANT_COLUMN_NAME, null);
    }

    public static boolean isFieldSharddingTenant(String group) {
        return MybatisConfigs.getTenantColumnName(group) != null;
    }

    public static boolean isSchameSharddingTenant(String group) {
        return DataSoureConfigHolder.containsTenantConfig(group);
    }

    public static String getSoftDeleteColumn(String group) {
        return MybatisConfigs.getProperty(group, SOFT_DELETE_COLUMN_NAME, null);
    }

    public static String getSoftDeletedFalseValue(String group) {
        return MybatisConfigs.getProperty(group, SOFT_DELETE_FALSE_VALUE, "0");
    }

    public static String getCreatedByColumnName(String group) {
        return MybatisConfigs.getProperty(group, CREATED_BY_COLUMN_NAME, "created_by");
    }

    public static String getDeptColumnName(String group) {
        return MybatisConfigs.getProperty(group, DEPT_COLUMN_NAME, null);
    }

    public static boolean ignoreTenant(String mappper) {
        if (ignoreTenantMappperPackages.isEmpty()) {
            return false;
        }
        return ignoreTenantMappperPackages.stream().anyMatch(o -> mappper.contains((CharSequence)o));
    }

    public static String getBusinessUnitColumn(String group) {
        return MybatisConfigs.getProperty(group, BUNIT_COLUMN_NAME, null);
    }

    public static List<String> getCustomHandlerNames(String group) {
        ArrayList<String> hanlders = new ArrayList<String>();
        String customHandlers = MybatisConfigs.getProperty(group, INTERCEPTOR_HANDLERCLASS, null);
        if (!StringUtils.isEmpty((CharSequence)customHandlers)) {
            String[] customHanlderClass = org.springframework.util.StringUtils.tokenizeToStringArray((String)customHandlers, (String)",; \t\n");
            hanlders.addAll(Arrays.asList(customHanlderClass));
        }
        return hanlders;
    }
}

