/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.model.AuthUser;
import org.dromara.mendmix.common.model.DataPermItem;
import org.dromara.mendmix.mybatis.DeptPermType;
import org.dromara.mendmix.mybatis.MybatisConfigs;
import org.dromara.mendmix.mybatis.datasource.DataSourceConfig;
import org.dromara.mendmix.mybatis.datasource.DataSourceContextVals;
import org.dromara.mendmix.mybatis.plugin.CurrentUserIdResolver;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.rewrite.DataPermissionStrategy;
import org.dromara.mendmix.mybatis.plugin.rewrite.UserPermissionProvider;
import org.dromara.mendmix.mybatis.plugin.rewrite.annotation.DataPermission;
import org.dromara.mendmix.spring.InstanceFactory;

public class MybatisRuntimeContext {
    private static final String CONTEXT_TRANS_ON_KEY = "_ctx_trans_on_";
    private static final String CONTEXT_FORCE_MASTER = "_ctx_force_master_";
    private static final String CONTEXT_DATASOURCE_KEY = "_ctx_ds_";
    private static final String CONTEXT_DATA_PROFILE_KEY = "_ctx_dataprofile_";
    private static final String CONTEXT_DATA_PERM_STRATEGY = "_ctx_dataperm_strategy_";
    private static final String CONTEXT_IGNORE_ANY = "_ctx_ignore_any_";
    private static final String CONTEXT_IGNORE_RWROUTE = "_ctx_ignore_rwroute_";
    private static final String CONTEXT_IGNORE_REWRITE = "_ctx_ignore_rewrite_";
    private static final String CONTEXT_IGNORE_DATA_PERM = "_ctx_ignore_dataperm_";
    private static final String CONTEXT_IGNORE_SOFT_DELETE = "_ctx_ignore_softdel_";
    private static final String CONTEXT_IGNORE_CACHE = "_ctx_ignore_cache_";
    private static final String CONTEXT_IGNORE_TABLE_SHARDING = "_ctx_ignore_tableSharding_";
    private static final String CONTEXT_IGNORE_LOGGING_CHANGED = "_ctx_ignore_logging_changed_";
    private static final String CONTEXT_REWRITE_TABLE_RULES = "_ctx_rewrite_table_rules_";
    private static final String CONTEXT_DATASOURCE_GROUP = "_ctx_datasource_group_";
    private static final String CONTEXT_IGNORE_OPER_PROTECT = "_ctx_ignore_operProtect_";
    private static final String CONTEXT_MAPPER_INVOCATION_VALS = "_ctx_mapper_invocationVals_";
    public static final String PARAM_CONTEXT_NAME = "__param_cxt_name";
    public static final String ATTR_VALUE_CONTEXT_NAME = "__attrval_cxt_name:%s:%s";
    public static final String DYNA_LIST_COUNT_CONTEXT_NAME = "__dynaListCount_cxt_name:%s";
    private static CurrentUserIdResolver currentUserIdResolver;
    private static UserPermissionProvider userPermissionProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CurrentUserIdResolver currentUserIdResolver() {
        if (currentUserIdResolver != null) {
            return currentUserIdResolver;
        }
        Class<MybatisRuntimeContext> clazz = MybatisRuntimeContext.class;
        synchronized (MybatisRuntimeContext.class) {
            currentUserIdResolver = (CurrentUserIdResolver)InstanceFactory.getInstance(CurrentUserIdResolver.class);
            if (currentUserIdResolver == null) {
                currentUserIdResolver = new CurrentUserIdResolver(){

                    @Override
                    public String resolve(AuthUser currentUser) {
                        return currentUser.getId();
                    }
                };
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentUserIdResolver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserPermissionProvider userPermissionProvider() {
        if (userPermissionProvider != null) {
            return userPermissionProvider;
        }
        Class<MybatisRuntimeContext> clazz = MybatisRuntimeContext.class;
        synchronized (MybatisRuntimeContext.class) {
            userPermissionProvider = (UserPermissionProvider)InstanceFactory.getInstance(UserPermissionProvider.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return userPermissionProvider;
        }
    }

    public static String getCurrentTenant() {
        String tenantId = CurrentRuntimeContext.getTenantId((boolean)false);
        return tenantId;
    }

    public static String getCurrentUserId() {
        AuthUser currentUser = CurrentRuntimeContext.getCurrentUser();
        return currentUser == null ? null : MybatisRuntimeContext.currentUserIdResolver().resolve(currentUser);
    }

    public static void setContextParam(String name, String value) {
        ThreadLocalContext.set((String)name, (Object)value);
    }

    public static void setDatasourceGroup(String group) {
        if (group == null) {
            ThreadLocalContext.remove((String[])new String[]{CONTEXT_DATASOURCE_GROUP});
        } else {
            ThreadLocalContext.set((String)CONTEXT_DATASOURCE_GROUP, (Object)group);
        }
    }

    public static String getDataSourceGroup() {
        if (ThreadLocalContext.exists((String)CONTEXT_DATASOURCE_GROUP)) {
            return ThreadLocalContext.getStringValue((String)CONTEXT_DATASOURCE_GROUP);
        }
        return StringUtils.defaultString((String)MybatisRuntimeContext.getDataSourceContextVals().group, (String)DataSourceConfig.DEFAULT_GROUP_NAME);
    }

    public static void setTransactionalMode(boolean on) {
        ThreadLocalContext.set((String)CONTEXT_TRANS_ON_KEY, (Object)String.valueOf(on));
        if (on) {
            MybatisRuntimeContext.forceUseMaster();
        }
    }

    public static String getTransactionalMode() {
        return ThreadLocalContext.getStringValue((String)CONTEXT_TRANS_ON_KEY);
    }

    public static boolean isTransactionalOn() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_TRANS_ON_KEY));
    }

    public static void setIgnoreTenant(boolean ignore) {
        ThreadLocalContext.set((String)"x-ignore-tenant", (Object)String.valueOf(ignore));
    }

    public static void setIgnoreTenantMode() {
        ThreadLocalContext.set((String)"x-ignore-tenant", (Object)Boolean.TRUE.toString());
    }

    public static boolean isIgnoreTenantMode() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)"x-ignore-tenant"));
    }

    public static void setIgnoreSqlRewrite(boolean ignore) {
        ThreadLocalContext.set((String)CONTEXT_IGNORE_REWRITE, (Object)String.valueOf(ignore));
    }

    public static void setIgnoreAny(boolean ignore) {
        ThreadLocalContext.set((String)CONTEXT_IGNORE_ANY, (Object)String.valueOf(ignore));
    }

    public static boolean isIgnoreAny() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_IGNORE_ANY));
    }

    public static void setIgnoreTableSharding(boolean ignore) {
        ThreadLocalContext.set((String)CONTEXT_IGNORE_TABLE_SHARDING, (Object)String.valueOf(ignore));
    }

    public static boolean isIgnoreTableSharding() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_IGNORE_TABLE_SHARDING));
    }

    public static boolean isIgnoreSqlRewrite() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_IGNORE_REWRITE));
    }

    public static void setIgnoreCache(boolean ignore) {
        ThreadLocalContext.set((String)CONTEXT_IGNORE_CACHE, (Object)String.valueOf(ignore));
    }

    public static boolean isIgnoreCache() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_IGNORE_CACHE));
    }

    public static void setIgnoreSoftDeleteConditon(boolean ignore) {
        ThreadLocalContext.set((String)CONTEXT_IGNORE_SOFT_DELETE, (Object)String.valueOf(ignore));
    }

    public static boolean isIgnoreSoftDeleteConditon() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_IGNORE_SOFT_DELETE));
    }

    public static void setIgnoreLoggingDataChange(boolean ignore) {
        ThreadLocalContext.set((String)CONTEXT_IGNORE_LOGGING_CHANGED, (Object)String.valueOf(ignore));
    }

    public static boolean isIgnoreLoggingDataChange() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_IGNORE_LOGGING_CHANGED));
    }

    public static boolean isIgnoreRwRoute() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_IGNORE_RWROUTE));
    }

    public static void setIgnoreRwRoute(boolean ignore) {
        ThreadLocalContext.set((String)CONTEXT_IGNORE_RWROUTE, (Object)String.valueOf(ignore));
    }

    public static void setIgnoreDataPermission(boolean ignore) {
        ThreadLocalContext.set((String)CONTEXT_IGNORE_DATA_PERM, (Object)String.valueOf(ignore));
    }

    public static boolean isIgnoreDataPermission() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_IGNORE_DATA_PERM));
    }

    public static void setDataPermissionStrategy(DataPermissionStrategy strategy) {
        ThreadLocalContext.set((String)CONTEXT_DATA_PERM_STRATEGY, (Object)strategy);
    }

    public static void setDataPermissionStrategy(DataPermission annotation) {
        ThreadLocalContext.set((String)CONTEXT_DATA_PERM_STRATEGY, (Object)new DataPermissionStrategy(annotation));
    }

    public static DataPermissionStrategy getDataPermissionStrategy() {
        DataPermissionStrategy strategy = (DataPermissionStrategy)ThreadLocalContext.get((String)CONTEXT_DATA_PERM_STRATEGY);
        if (strategy == null) {
            if (MybatisConfigs.DATA_PERM_ALL_MATCH_MODE_ENABLED) {
                strategy = new DataPermissionStrategy(true, null);
            }
            if (strategy != null) {
                ThreadLocalContext.set((String)CONTEXT_DATA_PERM_STRATEGY, (Object)strategy);
            }
        }
        return strategy;
    }

    public static void setTenantDataSourceKey(String dsKey) {
        CurrentRuntimeContext.setTenantDataSourceKey((String)dsKey);
    }

    public static String getTenantDataSourceKey() {
        return CurrentRuntimeContext.getTenantDataSourceKey();
    }

    public static void setIgnoreOperProtect(boolean ignore) {
        ThreadLocalContext.set((String)CONTEXT_IGNORE_OPER_PROTECT, (Object)String.valueOf(ignore));
    }

    public static boolean isIgnoreOperProtect() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_IGNORE_OPER_PROTECT));
    }

    public static boolean isEmpty() {
        return ThreadLocalContext.isEmpty();
    }

    public static void forceUseMaster() {
        ThreadLocalContext.set((String)CONTEXT_FORCE_MASTER, (Object)Boolean.TRUE.toString());
        MybatisRuntimeContext.useMaster();
    }

    public static boolean isForceUseMaster() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_FORCE_MASTER));
    }

    public static void useSlave() {
        DataSourceContextVals vals = MybatisRuntimeContext.getDataSourceContextVals();
        vals.master = false;
    }

    public static void useMaster() {
        DataSourceContextVals vals = MybatisRuntimeContext.getDataSourceContextVals();
        vals.master = true;
    }

    public static boolean isUseMaster() {
        if (MybatisRuntimeContext.isForceUseMaster()) {
            return true;
        }
        Boolean master = MybatisRuntimeContext.getDataSourceContextVals().master;
        return master == null ? true : master;
    }

    public static void setOnceContextVal(OnceContextVal onceContextVal) {
        ThreadLocalContext.set((String)CONTEXT_MAPPER_INVOCATION_VALS, (Object)onceContextVal);
    }

    public static OnceContextVal getOnceContextVal() {
        return (OnceContextVal)ThreadLocalContext.get((String)CONTEXT_MAPPER_INVOCATION_VALS);
    }

    public static DataSourceContextVals getDataSourceContextVals() {
        DataSourceContextVals dataSourceContextVals = (DataSourceContextVals)ThreadLocalContext.get((String)CONTEXT_DATASOURCE_KEY);
        if (dataSourceContextVals == null) {
            dataSourceContextVals = new DataSourceContextVals();
            if (MybatisRuntimeContext.isTransactionalOn()) {
                dataSourceContextVals.master = true;
            }
            ThreadLocalContext.set((String)CONTEXT_DATASOURCE_KEY, (Object)dataSourceContextVals);
        }
        dataSourceContextVals.group = MybatisRuntimeContext.getDataSourceGroup();
        dataSourceContextVals.tenantId = MybatisRuntimeContext.getCurrentTenant();
        dataSourceContextVals.tenantDataSourceKey = MybatisRuntimeContext.getTenantDataSourceKey();
        return dataSourceContextVals;
    }

    public static void addDataPermissionValues(String fieldName, String ... fieldValues) {
        HashMap<String, String[]> map = (HashMap<String, String[]>)ThreadLocalContext.get((String)CONTEXT_DATA_PROFILE_KEY);
        if (map == null) {
            map = new HashMap<String, String[]>(5);
            ThreadLocalContext.set((String)CONTEXT_DATA_PROFILE_KEY, map);
        }
        map.put(fieldName, fieldValues);
    }

    public static void setDataPermissionValues(Map<String, String[]> valueMap, boolean append) {
        if (append && ThreadLocalContext.exists((String)CONTEXT_DATA_PROFILE_KEY)) {
            Map map = (Map)ThreadLocalContext.get((String)CONTEXT_DATA_PROFILE_KEY);
            map.putAll(valueMap);
        } else if (valueMap == null) {
            ThreadLocalContext.remove((String[])new String[]{CONTEXT_DATA_PROFILE_KEY});
        } else {
            ThreadLocalContext.set((String)CONTEXT_DATA_PROFILE_KEY, valueMap);
        }
    }

    public static Map<String, String[]> getDataPermissionValues(String ... groups) {
        HashMap<String, Object[]> map = (HashMap<String, Object[]>)ThreadLocalContext.get((String)CONTEXT_DATA_PROFILE_KEY);
        if (map != null) {
            return map;
        }
        List<DataPermItem> items = userPermissionProvider.findCurrentAllPermissions();
        if (items != null) {
            map = new HashMap<String, Object[]>(items.size());
            for (DataPermItem item : items) {
                Object[] values;
                if (groups != null && !ArrayUtils.contains((Object[])groups, (Object)item.getGroupName())) continue;
                if (item.isAll()) {
                    values = new String[]{DeptPermType._ALL_.name()};
                } else {
                    if (item.getValues() == null || item.getValues().size() <= 0) continue;
                    values = (String[])map.get(item.getKey());
                    if (values == null) {
                        values = item.getValues().toArray(new String[0]);
                    } else if (item.getValues().size() == 1) {
                        String val = (String)item.getValues().get(0);
                        if (!ArrayUtils.contains((Object[])values, (Object)val)) {
                            values = (String[])ArrayUtils.add((Object[])values, (Object)val);
                        }
                    } else {
                        values = (String[])ArrayUtils.addAll((Object[])values, (Object[])item.getValues().toArray(new String[0]));
                    }
                }
                if (values.length > 1 && ArrayUtils.contains((Object[])values, (Object)DeptPermType._ALL_.name())) {
                    values = new String[]{DeptPermType._ALL_.name()};
                }
                map.put(item.getKey(), values);
            }
            if (!map.isEmpty() && map.values().stream().allMatch(arr -> ((String[])arr).length > 0 && DeptPermType._ALL_.name().equals(arr[0]))) {
                DataPermissionStrategy.updateHandleOwner(false);
            }
            ThreadLocalContext.set((String)CONTEXT_DATA_PROFILE_KEY, map);
        }
        return map;
    }

    public static Map<String, String> getRewriteTableNameRules() {
        return (Map)ThreadLocalContext.get((String)CONTEXT_REWRITE_TABLE_RULES);
    }

    public static void setRewriteTableNameRules(Map<String, String> rules) {
        if (rules == null) {
            if (ThreadLocalContext.exists((String)CONTEXT_REWRITE_TABLE_RULES)) {
                ThreadLocalContext.remove((String[])new String[]{CONTEXT_REWRITE_TABLE_RULES});
            }
            return;
        }
        ThreadLocalContext.set((String)CONTEXT_REWRITE_TABLE_RULES, rules);
    }

    public static void unsetOnceContext() {
        DataSourceContextVals dataSourceContextVals = (DataSourceContextVals)ThreadLocalContext.get((String)CONTEXT_DATASOURCE_KEY);
        if (dataSourceContextVals != null) {
            dataSourceContextVals.group = null;
            dataSourceContextVals.master = null;
        }
        ThreadLocalContext.remove((String[])new String[]{CONTEXT_IGNORE_OPER_PROTECT});
    }

    static {
        if (InstanceFactory.isInitialized()) {
            currentUserIdResolver = (CurrentUserIdResolver)InstanceFactory.getInstance(CurrentUserIdResolver.class);
            userPermissionProvider = (UserPermissionProvider)InstanceFactory.getInstance(UserPermissionProvider.class);
        }
    }
}

