/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.autoconfigure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.datasource.DataSourceConfig;
import org.dromara.mendmix.mybatis.datasource.DataSoureConfigHolder;
import org.dromara.mendmix.mybatis.datasource.DynamicMultiDataSource;
import org.dromara.mendmix.mybatis.spring.SqlSessionFactoryBean;
import org.dromara.mendmix.spring.InstanceFactory;
import org.dromara.mendmix.spring.helper.BeanRegistryHelper;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@ConditionalOnMissingClass(value={"org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration"})
public class MybatisConfiguration
implements ApplicationContextAware,
BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix");

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        InstanceFactory.setApplicationContext((ApplicationContext)context);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        List<String> groups = DataSoureConfigHolder.getGroups();
        for (String group : groups) {
            this.registerGroupMybatisBean(registry, group);
            logger.info(">> registerGroupMybatisBean Finished -> group:{}", (Object)group);
        }
    }

    private void registerGroupMybatisBean(BeanDefinitionRegistry registry, String group) {
        Class<Object> mapperConfigurerClass;
        ArrayList<BeanRegistryHelper.BeanValue> argValues = new ArrayList<BeanRegistryHelper.BeanValue>();
        HashMap<String, BeanRegistryHelper.BeanValue> propertyPairs = new HashMap<String, BeanRegistryHelper.BeanValue>();
        String dataSourceBeanName = group + "DataSource";
        Class<DynamicMultiDataSource> dataSourceClass = DynamicMultiDataSource.class;
        argValues.add(new BeanRegistryHelper.BeanValue((Object)group));
        BeanRegistryHelper.register((BeanDefinitionRegistry)registry, (String)dataSourceBeanName, dataSourceClass, argValues, propertyPairs);
        Class<DataSourceTransactionManager> transactionManagerClass = DataSourceTransactionManager.class;
        String transactionManagerBeanName = group + "TransactionManager";
        argValues.clear();
        propertyPairs.clear();
        propertyPairs.put("dataSource", new BeanRegistryHelper.BeanValue((Object)dataSourceBeanName, true));
        BeanRegistryHelper.register((BeanDefinitionRegistry)registry, (String)transactionManagerBeanName, transactionManagerClass, argValues, propertyPairs);
        Class<TransactionTemplate> transactionTemplateClass = TransactionTemplate.class;
        String transactionTemplateBeanName = group + "TransactionTemplate";
        argValues.clear();
        propertyPairs.clear();
        propertyPairs.put("transactionManager", new BeanRegistryHelper.BeanValue((Object)transactionManagerBeanName, true));
        BeanRegistryHelper.register((BeanDefinitionRegistry)registry, (String)transactionTemplateBeanName, transactionTemplateClass, argValues, propertyPairs);
        String sessionFactoryBeanName = group + "SqlSessionFactoryBean";
        Class<SqlSessionFactoryBean> sessionFactoryClass = SqlSessionFactoryBean.class;
        argValues.clear();
        propertyPairs.clear();
        propertyPairs.put("groupName", new BeanRegistryHelper.BeanValue((Object)group));
        propertyPairs.put("configLocation", new BeanRegistryHelper.BeanValue((Object)"classpath:mybatis-configuration.xml"));
        String value = this.getGroupConfig(group, "mybatis.mapper-locations");
        if (value.contains(",")) {
            String[] values = StringUtils.split((String)value, (String)",");
            propertyPairs.put("mapperLocations", new BeanRegistryHelper.BeanValue((Object)values));
        } else {
            propertyPairs.put("mapperLocations", new BeanRegistryHelper.BeanValue((Object)value));
        }
        value = this.getGroupConfig(group, "mybatis.type-aliases-package");
        propertyPairs.put("typeAliasesPackage", new BeanRegistryHelper.BeanValue((Object)value));
        value = this.getGroupConfig(group, "mybatis.type-handlers-package");
        if (value != null) {
            propertyPairs.put("typeHandlersPackage", new BeanRegistryHelper.BeanValue((Object)value));
        }
        propertyPairs.put("dataSource", new BeanRegistryHelper.BeanValue((Object)dataSourceBeanName, true));
        Properties properties = this.buildConfigurationProperties(group);
        if (properties != null) {
            propertyPairs.put("configurationProperties", new BeanRegistryHelper.BeanValue((Object)properties, false));
        }
        BeanRegistryHelper.register((BeanDefinitionRegistry)registry, (String)sessionFactoryBeanName, sessionFactoryClass, argValues, propertyPairs);
        String mapperConfigurerBeanName = group + "MapperScannerConfigurer";
        try {
            mapperConfigurerClass = Class.forName("tk.mybatis.spring.mapper.MapperScannerConfigurer");
        }
        catch (ClassNotFoundException e) {
            mapperConfigurerClass = MapperScannerConfigurer.class;
        }
        argValues.clear();
        propertyPairs.clear();
        propertyPairs.put("sqlSessionFactoryBeanName", new BeanRegistryHelper.BeanValue((Object)sessionFactoryBeanName));
        value = this.getGroupConfig(group, "mybatis.mapper-package");
        propertyPairs.put("basePackage", new BeanRegistryHelper.BeanValue((Object)value));
        BeanRegistryHelper.register((BeanDefinitionRegistry)registry, (String)mapperConfigurerBeanName, mapperConfigurerClass, argValues, propertyPairs);
        Class<SqlSessionTemplate> sqlSessionTemplateClass = SqlSessionTemplate.class;
        String sqlSessionTemplateBeanName = group + "SqlSessionTemplate";
        argValues.clear();
        propertyPairs.clear();
        argValues.add(new BeanRegistryHelper.BeanValue((Object)sessionFactoryBeanName, true));
        BeanRegistryHelper.register((BeanDefinitionRegistry)registry, (String)sqlSessionTemplateBeanName, sqlSessionTemplateClass, argValues, propertyPairs);
        Class<JdbcTemplate> jdbcTemplateClass = JdbcTemplate.class;
        String jdbcTemplateBeanName = group + "JdbcTemplate";
        argValues.clear();
        propertyPairs.clear();
        argValues.add(new BeanRegistryHelper.BeanValue((Object)dataSourceBeanName, true));
        BeanRegistryHelper.register((BeanDefinitionRegistry)registry, (String)jdbcTemplateBeanName, jdbcTemplateClass, argValues, propertyPairs);
    }

    private String getGroupConfig(String group, String key) {
        if (DataSourceConfig.DEFAULT_GROUP_NAME.equals(group)) {
            return ResourceUtils.getProperty((String)key);
        }
        String groupPrefix = "group[" + group + "].";
        String value = ResourceUtils.getProperty((String)(groupPrefix + key));
        if (StringUtils.isBlank((CharSequence)value)) {
            groupPrefix = group + ".";
            value = ResourceUtils.getProperty((String)(groupPrefix + key));
        }
        return value;
    }

    private Properties buildConfigurationProperties(String group) {
        Properties originProperties;
        if (DataSourceConfig.DEFAULT_GROUP_NAME.equals(group)) {
            originProperties = ResourceUtils.getAllProperties((String)"mybatis.configuration.variables");
        } else {
            originProperties = ResourceUtils.getAllProperties((String)("group[" + group + "].mybatis.configuration.variables"));
            if (originProperties.isEmpty()) {
                originProperties = ResourceUtils.getAllProperties((String)(group + ".mybatis.configuration.variables"));
            }
        }
        if (originProperties.isEmpty()) {
            return originProperties;
        }
        Properties formatProperties = new Properties();
        Iterator<Map.Entry<Object, Object>> iterator = originProperties.entrySet().iterator();
        String spiltStr = ".variables.";
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (entry.getValue() == null || StringUtils.isBlank((CharSequence)entry.getValue().toString())) continue;
            String key = StringUtils.splitByWholeSeparator((String)entry.getKey().toString(), (String)spiltStr)[1];
            formatProperties.setProperty(key, entry.getValue().toString());
        }
        return formatProperties;
    }
}

