/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.crud;

import java.util.List;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.dromara.mendmix.mybatis.crud.builder.BatchLogicDeleteBuilder;
import org.dromara.mendmix.mybatis.crud.builder.BatchUpdateByPrimaryKeysBuilder;
import org.dromara.mendmix.mybatis.crud.builder.CountAllBuilder;
import org.dromara.mendmix.mybatis.crud.builder.DeleteByPrimaryKeyBuilder;
import org.dromara.mendmix.mybatis.crud.builder.DeleteByPrimaryKeysBuilder;
import org.dromara.mendmix.mybatis.crud.builder.InsertBuilder;
import org.dromara.mendmix.mybatis.crud.builder.InsertListBuilder;
import org.dromara.mendmix.mybatis.crud.builder.SelectAllBuilder;
import org.dromara.mendmix.mybatis.crud.builder.SelectByPrimaryKeyBuilder;
import org.dromara.mendmix.mybatis.crud.builder.SelectByPrimaryKeysBuilder;
import org.dromara.mendmix.mybatis.crud.builder.UpdateBuilder;
import org.dromara.mendmix.mybatis.crud.builder.UpdateListByPrimaryKeysBuilder;
import org.dromara.mendmix.mybatis.crud.builder.UpdateListByPrimaryKeysSelectiveBuilder;
import org.dromara.mendmix.mybatis.kit.MybatisMapperParser;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(GeneralSqlGenerator.class);
    private LanguageDriver languageDriver;
    private Configuration configuration;
    private String group;

    public GeneralSqlGenerator(String group, Configuration configuration) {
        this.group = group;
        this.configuration = configuration;
        this.languageDriver = configuration.getDefaultScriptingLanguageInstance();
    }

    public void generate() {
        if (this.languageDriver == null) {
            this.languageDriver = this.configuration.getDefaultScriptingLanguageInstance();
        }
        List<MapperMetadata> entityInfos = MybatisMapperParser.getMapperMetadatas(this.group);
        for (MapperMetadata entity : entityInfos) {
            new InsertBuilder().build(this.configuration, this.languageDriver, entity);
            new InsertListBuilder().build(this.configuration, this.languageDriver, entity);
            new DeleteByPrimaryKeyBuilder().build(this.configuration, this.languageDriver, entity);
            new UpdateBuilder().build(this.configuration, this.languageDriver, entity);
            new SelectAllBuilder().build(this.configuration, this.languageDriver, entity);
            new SelectByPrimaryKeyBuilder().build(this.configuration, this.languageDriver, entity);
            new SelectByPrimaryKeysBuilder().build(this.configuration, this.languageDriver, entity);
            new CountAllBuilder().build(this.configuration, this.languageDriver, entity);
            new BatchLogicDeleteBuilder().build(this.configuration, this.languageDriver, entity);
            new BatchUpdateByPrimaryKeysBuilder().build(this.configuration, this.languageDriver, entity);
            new UpdateListByPrimaryKeysBuilder().build(this.configuration, this.languageDriver, entity);
            new UpdateListByPrimaryKeysSelectiveBuilder().build(this.configuration, this.languageDriver, entity);
            new DeleteByPrimaryKeysBuilder().build(this.configuration, this.languageDriver, entity);
            log.info(">> generate autoCrud for:[{}] finish", (Object)entity.getEntityClass().getName());
        }
    }
}

