/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.crud.builder;

import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.dromara.mendmix.mybatis.metadata.EntityMetadata;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.dromara.mendmix.mybatis.metadata.MetadataHelper;

public abstract class AbstractMethodBuilder {
    public void build(Configuration configuration, LanguageDriver languageDriver, MapperMetadata entity) {
        for (String name : this.methodNames()) {
            String msId = entity.getMapperClass().getName() + "." + name;
            EntityMetadata entityMapper = MetadataHelper.getEntityMapper(entity.getEntityClass());
            boolean selective = this.selective() ? true : name.endsWith("Selective");
            String sql = this.buildSQL(entityMapper, selective);
            SqlSource sqlSource = languageDriver.createSqlSource(configuration, sql, entity.getEntityClass());
            MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, msId, sqlSource, this.sqlCommandType());
            if (this.sqlCommandType() == SqlCommandType.INSERT) {
                Jdbc3KeyGenerator keyGenerator = entityMapper.autoId() ? new Jdbc3KeyGenerator() : new NoKeyGenerator();
                statementBuilder.keyGenerator((KeyGenerator)keyGenerator).keyProperty(entityMapper.getIdColumn().getProperty()).keyColumn(entityMapper.getIdColumn().getColumn());
            }
            MappedStatement statement = statementBuilder.build();
            this.setResultType(configuration, statement, entity.getEntityClass());
            configuration.addMappedStatement(statement);
        }
    }

    protected boolean selective() {
        return false;
    }

    abstract SqlCommandType sqlCommandType();

    abstract String[] methodNames();

    abstract String buildSQL(EntityMetadata var1, boolean var2);

    abstract void setResultType(Configuration var1, MappedStatement var2, Class<?> var3);
}

