/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.crud.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.dromara.mendmix.mybatis.crud.builder.AbstractMethodBuilder;
import org.dromara.mendmix.mybatis.metadata.ColumnMetadata;
import org.dromara.mendmix.mybatis.metadata.MetadataHelper;

public abstract class AbstractSelectMethodBuilder
extends AbstractMethodBuilder {
    @Override
    SqlCommandType sqlCommandType() {
        return SqlCommandType.SELECT;
    }

    @Override
    void setResultType(Configuration configuration, MappedStatement ms, Class<?> entityClass) {
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        resultMaps.add(AbstractSelectMethodBuilder.getResultMap(configuration, entityClass));
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        metaObject.setValue("resultMaps", Collections.unmodifiableList(resultMaps));
    }

    public static ResultMap getResultMap(Configuration configuration, Class<?> entityClass) {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        Set<ColumnMetadata> entityClassColumns = MetadataHelper.getEntityMapper(entityClass).getColumnsMapper();
        for (ColumnMetadata entityColumn : entityClassColumns) {
            ResultMapping.Builder builder = new ResultMapping.Builder(configuration, entityColumn.getProperty(), entityColumn.getColumn(), entityColumn.getJavaType());
            if (entityColumn.getJdbcType() != null) {
                builder.jdbcType(entityColumn.getJdbcType());
            }
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if (entityColumn.isId()) {
                flags.add(ResultFlag.ID);
            }
            builder.flags(flags);
            builder.lazy(false);
            resultMappings.add(builder.build());
        }
        ResultMap.Builder builder = new ResultMap.Builder(configuration, "BaseResultMap", entityClass, resultMappings, Boolean.valueOf(true));
        return builder.build();
    }
}

