/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.crud.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.dromara.mendmix.mybatis.crud.SqlTemplate;
import org.dromara.mendmix.mybatis.crud.builder.AbstractMethodBuilder;
import org.dromara.mendmix.mybatis.metadata.ColumnMetadata;
import org.dromara.mendmix.mybatis.metadata.EntityMetadata;
import org.dromara.mendmix.mybatis.metadata.TableMetadata;

public class BatchUpdateByPrimaryKeysBuilder
extends AbstractMethodBuilder {
    @Override
    SqlCommandType sqlCommandType() {
        return SqlCommandType.UPDATE;
    }

    @Override
    String[] methodNames() {
        return new String[]{"batchUpdateByPrimaryKeys"};
    }

    @Override
    protected boolean selective() {
        return true;
    }

    @Override
    String buildSQL(EntityMetadata entityMapper, boolean selective) {
        TableMetadata tableMapper = entityMapper.getTableMapper();
        Set<ColumnMetadata> columnMappers = entityMapper.getColumnsMapper();
        String idColumn = null;
        String idProperty = null;
        StringBuilder set = new StringBuilder();
        set.append("<trim prefix=\"SET\" suffixOverrides=\",\">");
        for (ColumnMetadata column : columnMappers) {
            if (!column.isUpdatable()) continue;
            if (column.isId()) {
                idColumn = column.getColumn();
                idProperty = column.getProperty();
                continue;
            }
            String expr = SqlTemplate.wrapIfTag("example." + column.getProperty(), column.getColumn() + "=#{example." + column.getProperty() + "}", !selective);
            set.append(expr);
            if (selective) continue;
            set.append(",");
        }
        if (!selective) {
            set.deleteCharAt(set.length() - 1);
        }
        set.append("</trim>");
        String sql = String.format("UPDATE %s %s \n WHERE %s IN <foreach collection=\"ids\" item=\"id\" index=\"index\" open=\"(\" close=\")\" separator=\",\">#{id}</foreach>", tableMapper.getName(), set.toString(), idColumn, idProperty);
        return String.format("<script>%s</script>", sql);
    }

    @Override
    void setResultType(Configuration configuration, MappedStatement statement, Class<?> entityClass) {
        ResultMap.Builder builder = new ResultMap.Builder(configuration, "int", Integer.class, new ArrayList(), Boolean.valueOf(true));
        MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
        List<ResultMap> resultMaps = Arrays.asList(builder.build());
        metaObject.setValue("resultMaps", resultMaps);
    }
}

