/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.crud.builder;

import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.Configuration;
import org.dromara.mendmix.mybatis.crud.SqlTemplate;
import org.dromara.mendmix.mybatis.crud.builder.AbstractMethodBuilder;
import org.dromara.mendmix.mybatis.metadata.ColumnMetadata;
import org.dromara.mendmix.mybatis.metadata.EntityMetadata;
import org.dromara.mendmix.mybatis.metadata.TableMetadata;

public class InsertBuilder
extends AbstractMethodBuilder {
    @Override
    SqlCommandType sqlCommandType() {
        return SqlCommandType.INSERT;
    }

    @Override
    String[] methodNames() {
        return new String[]{"insert", "insertSelective"};
    }

    @Override
    String buildSQL(EntityMetadata entityMapper, boolean selective) {
        TableMetadata table = entityMapper.getTableMapper();
        Set<ColumnMetadata> columns = entityMapper.getColumnsMapper();
        StringBuilder fieldBuilder = new StringBuilder("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">\n");
        StringBuilder prppertyBuilder = new StringBuilder("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">\n");
        if (!entityMapper.autoId()) {
            fieldBuilder.append(entityMapper.getIdColumn().getColumn()).append(",");
            prppertyBuilder.append("#{").append(entityMapper.getIdColumn().getProperty()).append("},");
        }
        for (ColumnMetadata column : columns) {
            if (!column.isInsertable() || column.isId() && !entityMapper.autoId() || column.isId() && !selective) continue;
            String fieldExpr = SqlTemplate.wrapIfTag(column.getProperty(), column.getColumn(), !selective);
            String propertyExpr = SqlTemplate.wrapIfTag(column.getProperty(), "#{" + column.getProperty() + "}", !selective);
            fieldBuilder.append(fieldExpr);
            fieldBuilder.append(selective ? "\n" : ",");
            prppertyBuilder.append(propertyExpr);
            prppertyBuilder.append(selective ? "\n" : ",");
        }
        if (!selective) {
            fieldBuilder.deleteCharAt(fieldBuilder.length() - 1);
            prppertyBuilder.deleteCharAt(prppertyBuilder.length() - 1);
        }
        fieldBuilder.append("</trim>");
        prppertyBuilder.append("</trim>");
        String sql = String.format("INSERT INTO %s \n %s \n VALUES \n %s", table.getName(), fieldBuilder.toString(), prppertyBuilder.toString());
        return String.format("<script>%s</script>", sql);
    }

    @Override
    void setResultType(Configuration configuration, MappedStatement statement, Class<?> entityClass) {
    }
}

