/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.crud.builder;

import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.Configuration;
import org.dromara.mendmix.mybatis.crud.SqlTemplate;
import org.dromara.mendmix.mybatis.crud.builder.AbstractMethodBuilder;
import org.dromara.mendmix.mybatis.metadata.ColumnMetadata;
import org.dromara.mendmix.mybatis.metadata.EntityMetadata;
import org.dromara.mendmix.mybatis.metadata.TableMetadata;

public class InsertListBuilder
extends AbstractMethodBuilder {
    @Override
    SqlCommandType sqlCommandType() {
        return SqlCommandType.INSERT;
    }

    @Override
    String[] methodNames() {
        return new String[]{"insertList", "insertListSelective"};
    }

    @Override
    String buildSQL(EntityMetadata entityMapper, boolean selective) {
        TableMetadata table = entityMapper.getTableMapper();
        Set<ColumnMetadata> columns = entityMapper.getColumnsMapper();
        StringBuilder fieldBuilder = new StringBuilder("(");
        StringBuilder prppertyBuilder = new StringBuilder("(");
        if (!entityMapper.autoId()) {
            fieldBuilder.append(entityMapper.getIdColumn().getColumn()).append(",");
            prppertyBuilder.append("#{item.").append(entityMapper.getIdColumn().getProperty()).append("},");
        }
        for (ColumnMetadata column : columns) {
            if (column.isId() || !column.isInsertable()) continue;
            String fieldExpr = SqlTemplate.wrapIfTag(column.getProperty(), column.getColumn(), !selective);
            String propertyExpr = SqlTemplate.wrapIfTag(column.getProperty(), "#{item." + column.getProperty() + "}", !selective);
            fieldBuilder.append(fieldExpr);
            fieldBuilder.append(",");
            prppertyBuilder.append(propertyExpr);
            prppertyBuilder.append(",");
        }
        fieldBuilder.deleteCharAt(fieldBuilder.length() - 1);
        prppertyBuilder.deleteCharAt(prppertyBuilder.length() - 1);
        fieldBuilder.append(")");
        prppertyBuilder.append(")");
        String sql = String.format("INSERT INTO %s \n %s \n VALUES \n <foreach collection=\"list\" item=\"item\" index=\"index\" separator=\",\">%s</foreach>", table.getName(), fieldBuilder.toString(), prppertyBuilder.toString());
        return String.format("<script>%s</script>", sql);
    }

    @Override
    void setResultType(Configuration configuration, MappedStatement statement, Class<?> entityClass) {
    }
}

