/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.crud.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.dromara.mendmix.mybatis.crud.CrudMethods;
import org.dromara.mendmix.mybatis.crud.SqlTemplate;
import org.dromara.mendmix.mybatis.crud.builder.AbstractMethodBuilder;
import org.dromara.mendmix.mybatis.metadata.ColumnMetadata;
import org.dromara.mendmix.mybatis.metadata.EntityMetadata;
import org.dromara.mendmix.mybatis.metadata.TableMetadata;

public class UpdateListByPrimaryKeysSelectiveBuilder
extends AbstractMethodBuilder {
    @Override
    SqlCommandType sqlCommandType() {
        return SqlCommandType.UPDATE;
    }

    @Override
    String[] methodNames() {
        return new String[]{CrudMethods.updateListByPrimaryKeysSelective.name()};
    }

    @Override
    protected boolean selective() {
        return true;
    }

    @Override
    String buildSQL(EntityMetadata entityMapper, boolean selective) {
        TableMetadata tableMapper = entityMapper.getTableMapper();
        Set<ColumnMetadata> columnMappers = entityMapper.getColumnsMapper();
        String idColumn = null;
        String idProperty = null;
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("UPDATE ").append(tableMapper.getName()).append(" ");
        sqlBuilder.append("<trim prefix=\"SET\" suffixOverrides=\",\">");
        for (ColumnMetadata column : columnMappers) {
            if (!column.isUpdatable()) continue;
            if (column.isId()) {
                idColumn = column.getColumn();
                idProperty = column.getProperty();
                continue;
            }
            String expr = SqlTemplate.wrapIfTag("item." + column.getProperty(), column.getColumn() + "=#{item." + column.getProperty() + "}", !selective);
            sqlBuilder.append(expr);
            if (selective) continue;
            sqlBuilder.append(",");
        }
        if (!selective) {
            sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        }
        sqlBuilder.append("</trim>");
        sqlBuilder.append(" WHERE ").append(idColumn).append(" = #{item.").append(idProperty).append("}");
        String sql = String.format("<foreach collection=\"list\" item=\"item\" separator=\";\">%s</foreach>", sqlBuilder.toString());
        return String.format("<script>%s</script>", sql);
    }

    @Override
    void setResultType(Configuration configuration, MappedStatement statement, Class<?> entityClass) {
        ResultMap.Builder builder = new ResultMap.Builder(configuration, "int", Integer.class, new ArrayList(), Boolean.valueOf(true));
        MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
        List<ResultMap> resultMaps = Arrays.asList(builder.build());
        metaObject.setValue("resultMaps", resultMaps);
    }
}

