/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.crud.provider;

import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.kit.MybatisMapperParser;
import org.dromara.mendmix.mybatis.metadata.ColumnMetadata;
import org.dromara.mendmix.mybatis.metadata.EntityMetadata;
import org.dromara.mendmix.mybatis.metadata.MetadataHelper;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;

public abstract class AbstractExampleProvider {
    protected EntityMetadata currentEntityMetadata(Object example) {
        OnceContextVal contextVal = MybatisRuntimeContext.getOnceContextVal();
        if (contextVal != null) {
            return MybatisMapperParser.getMapperMetadata(contextVal.getMapperNameSpace()).getEntityMetadata();
        }
        return MetadataHelper.getEntityMapper(example.getClass());
    }

    protected void appendWhere(StringBuilder whereBuilder, ColumnMetadata column) {
        if (whereBuilder.length() > 0) {
            whereBuilder.append(" AND ");
        }
        if (column.isFuzzyMatch()) {
            whereBuilder.append(column.getColumn()).append(" LIKE ");
            whereBuilder.append("CONCAT('%',#{").append(column.getProperty()).append("},'%')");
        } else {
            whereBuilder.append(column.getColumn()).append("=");
            whereBuilder.append("#{").append(column.getProperty()).append("}");
        }
    }

    protected void appendWhere(StringBuilder whereBuilder, ColumnMetadata column, Object value) {
        if (whereBuilder.length() > 0) {
            whereBuilder.append(" AND ");
        }
        whereBuilder.append(column.getColumn()).append("=");
        if (column.getJavaType() == String.class) {
            whereBuilder.append("'").append(value).append("'");
        } else if (column.getJavaType() == Date.class) {
            whereBuilder.append("'").append(DateFormatUtils.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss")).append("'");
        } else if (column.getJavaType() == Boolean.class || column.getJavaType() == Boolean.TYPE) {
            whereBuilder.append((Boolean)value != false ? 1 : 0);
        } else {
            whereBuilder.append(value);
        }
    }

    protected void appendUpdateSet(StringBuilder setBuilder, ColumnMetadata column) {
        if (setBuilder.length() > 0) {
            setBuilder.append(",");
        }
        setBuilder.append(column.getColumn()).append("=");
        setBuilder.append("#{").append(column.getProperty()).append("}");
    }

    protected void appendUpdateSet(StringBuilder setBuilder, ColumnMetadata column, Object value) {
        if (setBuilder.length() > 0) {
            setBuilder.append(",");
        }
        setBuilder.append(column.getColumn()).append("=");
        if (column.getJavaType() == String.class) {
            setBuilder.append("'").append(value).append("'");
        } else if (column.getJavaType() == Date.class) {
            setBuilder.append("'").append(DateFormatUtils.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss")).append("'");
        } else if (column.getJavaType() == Boolean.class || column.getJavaType() == Boolean.TYPE) {
            setBuilder.append((Boolean)value != false ? 1 : 0);
        } else {
            setBuilder.append(value);
        }
    }
}

