/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.crud.provider;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Set;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mendmix.mybatis.crud.provider.AbstractExampleProvider;
import org.dromara.mendmix.mybatis.metadata.ColumnMetadata;
import org.dromara.mendmix.mybatis.metadata.EntityMetadata;
import org.dromara.mendmix.mybatis.metadata.MetadataHelper;

public class UpdateWithVersionProvider
extends AbstractExampleProvider {
    public String updateByPrimaryKeyWithVersion(Object example) throws Exception {
        EntityMetadata entityMapper = MetadataHelper.getEntityMapper(example.getClass());
        Set<ColumnMetadata> columns = entityMapper.getColumnsMapper();
        SQL sql = (SQL)new SQL().UPDATE(entityMapper.getTableMapper().getName());
        StringBuilder setBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        ColumnMetadata idColumn = entityMapper.getIdColumn();
        this.appendWhere(whereBuilder, idColumn);
        for (ColumnMetadata column : columns) {
            Object value;
            if (column.isId() || !column.isUpdatable() || (value = MetadataHelper.getEntityField(entityMapper.getTableMapper().getName(), column.getProperty()).get(example)) == null) continue;
            if (column.isVersionField()) {
                this.appendWhere(whereBuilder, column);
                value = this.getUpdatedVersionVal(column.getJavaType(), value);
                this.appendUpdateSet(setBuilder, column, value);
                continue;
            }
            this.appendUpdateSet(setBuilder, column);
        }
        sql.SET(setBuilder.toString());
        sql.WHERE(whereBuilder.toString());
        return sql.toString();
    }

    protected Object getUpdatedVersionVal(Class<?> clazz, Object originalVersionVal) {
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return (Long)originalVersionVal + 1L;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return (Integer)originalVersionVal + 1;
        }
        if (Date.class.equals(clazz)) {
            return new Date();
        }
        if (Timestamp.class.equals(clazz)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (LocalDateTime.class.equals(clazz)) {
            return LocalDateTime.now();
        }
        return originalVersionVal;
    }
}

