/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.datasource;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.MybatisConfigs;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataSourceConfig {
    private static final String DEFAULT_DRIVER_CLASS_NAME = ResourceUtils.getProperty((String)"db.driverClassName", (String)"com.mysql.cj.jdbc.Driver");
    private static final int DEFAULT_MAX_ACTIVE = ResourceUtils.getInt((String)"db.maxActive", (int)20);
    private static final boolean DEFAULT_KEEP_ALIVE = ResourceUtils.getBoolean((String)"db.keepAlive", (boolean)false);
    private static final boolean DEFAULT_TEST_ON_RETUEN = ResourceUtils.getBoolean((String)"db.testOnReturn", (boolean)false);
    private static final boolean DEFAULT_TEST_ON_BORROW = ResourceUtils.getBoolean((String)"db.testOnBorrow", (boolean)true);
    private static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MS = ResourceUtils.getLong((String)"db.timeBetweenEvictionRunsMillis", (long)60000L);
    private static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MS = ResourceUtils.getLong((String)"db.minEvictableIdleTimeMillis", (long)60000L);
    private static final long DEFAULT_KEEP_ALIVE_BETWEEN_TIME_MS = ResourceUtils.getLong((String)"db.keepAliveBetweenTimeMillis");
    private static final long DEFAULT_MAX_WAIT = ResourceUtils.getLong((String)"db.maxWait", (long)30000L);
    private static final int DEFAULT_MIN_IDLE = ResourceUtils.getInt((String)"db.minIdle", (int)1);
    private static final int DEFAULT_INITIAL_SIZE = ResourceUtils.getInt((String)"db.initialSize", (int)1);
    private static final String DEFAULT_VALIDATION_QUERY = ResourceUtils.getProperty((String)"db.validationQuery", (String)"SELECT 'x'");
    private static final boolean DEFAULT_TEST_WHILE_IDLE = ResourceUtils.getBoolean((String)"db.testWhileIdle", (boolean)true);
    private static final int DEFAULT_CONN_TIMEOUT = ResourceUtils.getInt((String)"db.connectTimeout", (int)10000);
    private static final int DEFAULT_SOCKET_TIMEOUT = ResourceUtils.getInt((String)"db.socketTimeout", (int)10000);
    private static final boolean DEFAULT_REMOVE_ABANDONED = ResourceUtils.getBoolean((String)"db.removeAbandoned", (boolean)false);
    private static final long DEFAULT_REMOVE_ABANDONED__TIMEOUT_MS = ResourceUtils.getLong((String)"db.removeAbandonedTimeoutMillis", (long)300000L);
    private static final boolean DEFAULT_ABANDONED_LOGGING = ResourceUtils.getBoolean((String)"db.logAbandoned", (boolean)false);
    public static final String SLAVE_KEY = "slave";
    public static final String MASTER_KEY = "master";
    public static String DEFAULT_GROUP_NAME = "default";
    private String id;
    private String group = DEFAULT_GROUP_NAME;
    private String url;
    private String username;
    private String password;
    private boolean master;
    private int index;
    private String hostAndPort;
    private String driverClassName = DEFAULT_DRIVER_CLASS_NAME;
    private boolean testWhileIdle = DEFAULT_TEST_WHILE_IDLE;
    private String validationQuery = DEFAULT_VALIDATION_QUERY;
    private int maxActive = DEFAULT_MAX_ACTIVE;
    private int initialSize = DEFAULT_INITIAL_SIZE;
    private int minIdle = DEFAULT_MIN_IDLE;
    private long maxWait = DEFAULT_MAX_WAIT;
    private long minEvictableIdleTimeMillis = DEFAULT_MIN_EVICTABLE_IDLE_TIME_MS;
    private long timeBetweenEvictionRunsMillis = DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MS;
    private boolean testOnBorrow = DEFAULT_TEST_ON_BORROW;
    private boolean testOnReturn = DEFAULT_TEST_ON_RETUEN;
    private boolean keepAlive = DEFAULT_KEEP_ALIVE;
    private long keepAliveBetweenTimeMillis = DEFAULT_KEEP_ALIVE_BETWEEN_TIME_MS > 0L ? DEFAULT_KEEP_ALIVE_BETWEEN_TIME_MS : this.timeBetweenEvictionRunsMillis + 5000L;
    private int connectTimeout = DEFAULT_CONN_TIMEOUT;
    private int socketTimeout = DEFAULT_SOCKET_TIMEOUT;
    private boolean removeAbandoned = DEFAULT_REMOVE_ABANDONED;
    private long removeAbandonedTimeoutMillis = DEFAULT_REMOVE_ABANDONED__TIMEOUT_MS;
    private boolean logAbandoned = DEFAULT_ABANDONED_LOGGING;
    private String tenantRouteKey;
    private Set<String> scopeTenantIds;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getHostAndPort() {
        if (this.hostAndPort == null) {
            this.hostAndPort = StringUtils.split((String)this.url, (String)"/")[1];
        }
        return this.hostAndPort;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public long getKeepAliveBetweenTimeMillis() {
        return this.keepAliveBetweenTimeMillis;
    }

    public void setKeepAliveBetweenTimeMillis(long keepAliveBetweenTimeMillis) {
        this.keepAliveBetweenTimeMillis = keepAliveBetweenTimeMillis;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    public long getRemoveAbandonedTimeoutMillis() {
        return this.removeAbandonedTimeoutMillis;
    }

    public void setRemoveAbandonedTimeoutMillis(long removeAbandonedTimeoutMillis) {
        this.removeAbandonedTimeoutMillis = removeAbandonedTimeoutMillis;
    }

    public boolean isLogAbandoned() {
        return this.logAbandoned;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    public String getTenantRouteKey() {
        return this.tenantRouteKey;
    }

    public void setTenantRouteKey(String tenantRouteKey) {
        this.tenantRouteKey = tenantRouteKey;
    }

    public Set<String> getScopeTenantIds() {
        return this.scopeTenantIds != null ? this.scopeTenantIds : (this.scopeTenantIds = new HashSet<String>());
    }

    public void setScopeTenantIds(Set<String> scopeTenantIds) {
        this.scopeTenantIds = scopeTenantIds;
    }

    public void addScopeTenantId(String tenantId) {
        this.getScopeTenantIds().add(tenantId);
    }

    public String dataSourceKey() {
        return DataSourceConfig.buildDataSourceKey(this.group, this.tenantRouteKey, this.master, this.index);
    }

    public void validate() {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.url, this.username})) {
            throw new MendmixBaseException("DataSourceConfig[url,username,password] is required");
        }
        if (StringUtils.isBlank((CharSequence)this.tenantRouteKey) && StringUtils.isBlank((CharSequence)MybatisConfigs.getTenantColumnName(this.group)) && MybatisConfigs.isSchameSharddingTenant(this.group)) {
            throw new MendmixBaseException("DataSourceConfig[tenantId] is required For SchameSharddingTenant");
        }
    }

    public static String buildDataSourceKey(String group, String tenantId, boolean master, int index) {
        StringBuilder builder = new StringBuilder(group).append("_");
        if (tenantId != null) {
            builder.append(tenantId).append("_");
        }
        builder.append(master ? MASTER_KEY : SLAVE_KEY).append("_");
        builder.append(index);
        return builder.toString();
    }

    public String toString() {
        return "DataSourceConfig [group=" + this.group + ", tenantRouteKey=" + this.tenantRouteKey + ", url=" + this.url + ", username=" + this.username + ", master=" + this.master + ", index=" + this.index + ", maxActive=" + this.maxActive + "]";
    }
}

