/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.datasource;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.datasource.DataSourceConfig;

public class DataSoureConfigHolder {
    private static Map<String, List<DataSourceConfig>> allGroupConfigs;

    private static Map<String, List<DataSourceConfig>> getAllGroupConfigs() {
        if (allGroupConfigs == null) {
            Properties properties = ResourceUtils.getAllProperties((String)".*(\\.db\\.).*", (boolean)false);
            allGroupConfigs = DataSoureConfigHolder.resolveConfigs(properties);
        }
        return allGroupConfigs;
    }

    public static List<String> getGroups() {
        return new ArrayList<String>(DataSoureConfigHolder.getAllGroupConfigs().keySet());
    }

    public static List<DataSourceConfig> getConfigs(String group) {
        return DataSoureConfigHolder.getAllGroupConfigs().get(group);
    }

    public static boolean containsSlaveConfig() {
        for (String group : DataSoureConfigHolder.getAllGroupConfigs().keySet()) {
            if (!allGroupConfigs.get(group).stream().anyMatch(o -> !o.isMaster())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTenantConfig(String group) {
        return DataSoureConfigHolder.getAllGroupConfigs().get(group).stream().anyMatch(o -> StringUtils.isNotBlank((CharSequence)o.getTenantRouteKey()));
    }

    public static synchronized Map<String, List<DataSourceConfig>> resolveConfigs(Properties properties) {
        Field[] fields;
        HashMap<String, List<DataSourceConfig>> groupConfigs = new HashMap<String, List<DataSourceConfig>>();
        for (Field field : fields = FieldUtils.getAllFields(DataSourceConfig.class)) {
            field.setAccessible(true);
        }
        HashMap<String, DataSourceConfig> configs = new HashMap<String, DataSourceConfig>();
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String key = entry.getKey().toString();
            if (!key.contains("master") && !key.contains("slave")) continue;
            DataSourceConfig config = DataSoureConfigHolder.buildDataSourceConfig(key, fields);
            String dsKey = config.dataSourceKey();
            if (configs.containsKey(dsKey)) {
                config = (DataSourceConfig)configs.get(dsKey);
                continue;
            }
            configs.put(dsKey, config);
        }
        for (DataSourceConfig dsConfig : configs.values()) {
            ArrayList<DataSourceConfig> groupList = (ArrayList<DataSourceConfig>)groupConfigs.get(dsConfig.getGroup());
            if (groupList == null) {
                groupList = new ArrayList<DataSourceConfig>();
                groupConfigs.put(dsConfig.getGroup(), groupList);
            }
            groupList.add(dsConfig);
        }
        return groupConfigs;
    }

    private static DataSourceConfig buildDataSourceConfig(String propKey, Field[] fields) {
        String[] arrays = StringUtils.split((String)propKey, (String)".");
        DataSourceConfig config = new DataSourceConfig();
        for (String item : arrays) {
            if (item.startsWith("group")) {
                config.setGroup(DataSoureConfigHolder.parseFieldValue(item));
                continue;
            }
            if (item.startsWith("tenant")) {
                config.setTenantRouteKey(DataSoureConfigHolder.parseFieldValue(item));
                continue;
            }
            if (item.startsWith("slave")) {
                String value = DataSoureConfigHolder.parseFieldValue(item);
                if (value == null) continue;
                config.setIndex(Integer.parseInt(value));
                continue;
            }
            if (!item.equals("master")) continue;
            config.setMaster(true);
        }
        String propKeyPrefix = propKey.substring(0, propKey.lastIndexOf(".") + 1);
        for (Field field : fields) {
            String propValue = ResourceUtils.getProperty((String)(propKeyPrefix + field.getName()));
            if (StringUtils.isBlank((CharSequence)propValue)) continue;
            DataSoureConfigHolder.setFieldValue(config, field, propValue);
        }
        return config;
    }

    private static String parseFieldValue(String field) {
        if (!field.contains("[")) {
            return null;
        }
        return StringUtils.split((String)field, (String)"[]")[1];
    }

    private static void setFieldValue(Object object, Field field, String value) {
        Object _value = value;
        if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
            _value = Integer.parseInt(value);
        } else if (field.getType() == Long.TYPE || field.getType() == Long.class) {
            _value = Long.parseLong(value);
        } else if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            _value = Boolean.parseBoolean(value);
        }
        try {
            field.set(object, _value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

