/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.mybatis.MybatisConfigs;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.datasource.DataSourceConfig;
import org.dromara.mendmix.mybatis.datasource.DataSourceConfigLoader;
import org.dromara.mendmix.mybatis.datasource.DataSourceContextVals;
import org.dromara.mendmix.mybatis.datasource.DataSourceType;
import org.dromara.mendmix.mybatis.datasource.DataSoureConfigHolder;
import org.dromara.mendmix.mybatis.datasource.RouteTenantKeyConverter;
import org.dromara.mendmix.mybatis.datasource.builder.DruidDataSourceBuilder;
import org.dromara.mendmix.mybatis.datasource.builder.HikariCPDataSourceBuilder;
import org.dromara.mendmix.spring.CommonApplicationEvent;
import org.dromara.mendmix.spring.InstanceFactory;
import org.dromara.mendmix.spring.SpringEventType;
import org.dromara.mendmix.spring.helper.EnvironmentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.jdbc.datasource.AbstractDataSource;

public class DynamicMultiDataSource
extends AbstractDataSource
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    private static Set<String> allTenantDataSourceKeys = new HashSet<String>();
    private DataSourceType dataSourceType = DataSourceType.druid;
    private Map<String, DataSourceConfig> targetDataSourceConfigs = new HashMap<String, DataSourceConfig>();
    private Map<String, DataSource> targetDataSources = new HashMap<String, DataSource>();
    private String group;
    private String mixTenantDataSourceKey;
    private boolean schemaTenantMode = false;
    private Set<String> tenantDataSourceKeys = new HashSet<String>();
    private Map<String, Integer> slaveNumsMap = new HashMap<String, Integer>();
    private Map<String, String> tenantIdToKeyMapping = new ConcurrentHashMap<String, String>();
    private Map<String, Set<String>> dataSourceKeyToTenantMapping = new ConcurrentHashMap<String, Set<String>>();
    private String missTenantDataSourceKey;
    @Autowired(required=false)
    private RouteTenantKeyConverter tenantKeyConverter;
    @Autowired(required=false)
    private DataSourceConfigLoader dataSourceConfigLoader;

    public DynamicMultiDataSource() {
        this(DataSourceConfig.DEFAULT_GROUP_NAME);
    }

    public DynamicMultiDataSource(String group) {
        this.group = group;
        this.schemaTenantMode = MybatisConfigs.isSchameSharddingTenant(group);
        this.mixTenantDataSourceKey = group + "-default_tenant_datasource_key_";
        if (this.schemaTenantMode) {
            this.missTenantDataSourceKey = MybatisConfigs.getProperty(group, "mybatis.defaultTenantDataSourceKey.onTenantIdMissing", null);
        }
    }

    public String getGroup() {
        return this.group;
    }

    public static Set<String> getAllTenantDataSourceKeys() {
        return Collections.unmodifiableSet(allTenantDataSourceKeys);
    }

    public Map<String, DataSource> getTargetDataSources() {
        return Collections.unmodifiableMap(this.targetDataSources);
    }

    public Map<String, DataSourceConfig> getTargetDataSourceConfigs() {
        return this.targetDataSourceConfigs;
    }

    public void setTargetDataSourceConfigs(Map<String, DataSourceConfig> targetDataSourceConfigs) {
        this.targetDataSourceConfigs = targetDataSourceConfigs;
    }

    public static String dataSourceKeyToTenantId(String dataSourceKey) {
        Collection dataSources = InstanceFactory.getBeansOfType(DynamicMultiDataSource.class).values();
        for (DynamicMultiDataSource dataSource : dataSources) {
            if (!dataSource.schemaTenantMode) continue;
            Set<String> tenantIds = dataSource.dataSourceKeyToTenantMapping.get(dataSourceKey);
            if (tenantIds == null || tenantIds.isEmpty()) {
                return dataSource.cacheTenantIdToKeyMapping(dataSourceKey, false);
            }
            if (tenantIds.size() != 1) continue;
            return tenantIds.stream().findFirst().orElse(null);
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        List<DataSourceConfig> dsConfigs = DataSoureConfigHolder.getConfigs(this.group);
        if (this.dataSourceConfigLoader != null) {
            dsConfigs.addAll(this.dataSourceConfigLoader.load(this.group));
        }
        Validate.isTrue((!dsConfigs.isEmpty() ? 1 : 0) != 0, (String)"Not Any DataSource Config Found", (Object[])new Object[0]);
        boolean hasNoTenantDataSource = false;
        for (DataSourceConfig dataSourceConfig : dsConfigs) {
            this.registerRealDataSource(dataSourceConfig);
            if (hasNoTenantDataSource) continue;
            hasNoTenantDataSource = StringUtils.isBlank((CharSequence)dataSourceConfig.getTenantRouteKey());
        }
        if (hasNoTenantDataSource && !this.tenantDataSourceKeys.isEmpty() && StringUtils.isNotBlank((CharSequence)MybatisConfigs.getTenantColumnName(this.group))) {
            this.tenantDataSourceKeys.add(this.mixTenantDataSourceKey);
            allTenantDataSourceKeys.add(this.mixTenantDataSourceKey);
        }
        if (this.targetDataSources == null || this.targetDataSources.isEmpty()) {
            throw new IllegalArgumentException("Property 'targetDataSources' is required");
        }
        logger.info(">> init multiRouteDataSource[{}] finished ->\n- schemaTenantMode:{}\n -targetDataSources:{}\n -tenantDataSourceKeys:{}\n -slaveNumsMap:{}", new Object[]{this.group, this.schemaTenantMode, this.targetDataSources.keySet(), this.tenantDataSourceKeys, this.slaveNumsMap});
    }

    private String currentDataSourceKey() {
        String tenantDataSourceKey;
        DataSourceContextVals context = MybatisRuntimeContext.getDataSourceContextVals();
        boolean useMaster = context.master == null ? true : context.master;
        int index = 0;
        String tenantId = this.schemaTenantMode ? context.tenantId : null;
        String string = tenantDataSourceKey = this.schemaTenantMode ? context.tenantDataSourceKey : null;
        if (this.schemaTenantMode && (StringUtils.isBlank((CharSequence)tenantId) || "-1".equals(tenantId)) && StringUtils.isBlank((CharSequence)tenantDataSourceKey)) {
            if (this.missTenantDataSourceKey != null) {
                tenantDataSourceKey = this.missTenantDataSourceKey;
            } else {
                throw new MendmixBaseException("context:tentantId is missing!!!");
            }
        }
        if (tenantDataSourceKey == null && tenantId != null) {
            tenantDataSourceKey = this.tenanIdToTenantDataSourceKey(tenantId);
            if (tenantDataSourceKey != null && this.schemaTenantMode && !this.tenantDataSourceKeys.contains(tenantDataSourceKey)) {
                tenantDataSourceKey = null;
            }
        } else if (this.mixTenantDataSourceKey.equals(tenantDataSourceKey)) {
            tenantDataSourceKey = null;
        }
        if (!useMaster) {
            if (this.slaveNumsMap.isEmpty()) {
                useMaster = true;
            } else {
                String subGroup = this.group;
                if (tenantDataSourceKey != null) {
                    subGroup = this.group + "_" + tenantDataSourceKey;
                }
                if (!this.slaveNumsMap.containsKey(subGroup)) {
                    useMaster = true;
                } else {
                    Integer slaveNums = this.slaveNumsMap.get(subGroup);
                    if (slaveNums > 1) {
                        index = RandomUtils.nextInt((int)0, (int)slaveNums);
                    }
                }
            }
        }
        if (tenantId == null && tenantDataSourceKey != null && this.dataSourceKeyToTenantMapping.containsKey(tenantDataSourceKey) && this.dataSourceKeyToTenantMapping.get(tenantDataSourceKey).size() == 1) {
            tenantId = this.dataSourceKeyToTenantMapping.get(tenantDataSourceKey).stream().findFirst().orElse(null);
            CurrentRuntimeContext.setTenantId((String)tenantId);
        }
        String dataSourceKey = DataSourceConfig.buildDataSourceKey(this.group, tenantDataSourceKey, useMaster, index);
        if (logger.isDebugEnabled() || CurrentRuntimeContext.isDebugMode()) {
            logger.info("<trace_logging> currentDataSourceKey:{},tenantId:{}, useMaster:{}", new Object[]{dataSourceKey, tenantId, useMaster});
        }
        return dataSourceKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tenanIdToTenantDataSourceKey(String tenantId) {
        if (this.tenantKeyConverter == null) {
            DynamicMultiDataSource dynamicMultiDataSource = this;
            synchronized (dynamicMultiDataSource) {
                if (this.tenantKeyConverter == null) {
                    this.tenantKeyConverter = (RouteTenantKeyConverter)InstanceFactory.getInstance(RouteTenantKeyConverter.class);
                }
            }
        }
        if (this.tenantKeyConverter.caching() && this.tenantIdToKeyMapping.containsKey(tenantId)) {
            return this.tenantIdToKeyMapping.get(tenantId);
        }
        String tenantKey = this.tenantKeyConverter.convert(this.group, tenantId);
        if (StringUtils.isBlank((CharSequence)tenantKey)) {
            tenantKey = tenantId;
        }
        if (this.tenantKeyConverter.caching()) {
            if (!StringUtils.equals((CharSequence)tenantKey, (CharSequence)tenantId)) {
                logger.info(">> add tenanIdToTenantDataSourceKey mapping:{} = {}", (Object)tenantId, (Object)tenantKey);
            }
            this.tenantIdToKeyMapping.put(tenantId, tenantKey);
        }
        this.addDataSourceKeyToTenantMapping(tenantKey, tenantId);
        return tenantKey;
    }

    public Connection getConnection() throws SQLException {
        return this.determineTargetDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineTargetDataSource().getConnection(username, password);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        return this.determineTargetDataSource().unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance((Object)this) || this.determineTargetDataSource().isWrapperFor(iface);
    }

    protected DataSource determineTargetDataSource() {
        String lookupKey = this.currentDataSourceKey();
        DataSource dataSource = this.targetDataSources.get(lookupKey);
        if (dataSource == null) {
            logger.warn("not_match_dataSource for:{},allDataSourceKeys:{}", (Object)lookupKey, this.targetDataSources.keySet());
            throw new MendmixBaseException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }

    private void registerRealDataSource(DataSourceConfig config) throws SQLException {
        config.validate();
        if (config.getPassword().startsWith("{Cipher}")) {
            String password = EnvironmentHelper.decryptConfigValue((String)config.getPassword());
            config.setPassword(password);
        }
        DataSource dataSource = null;
        if (DataSourceType.druid == this.dataSourceType) {
            dataSource = DruidDataSourceBuilder.builder(config);
        } else if (DataSourceType.hikariCP == this.dataSourceType) {
            dataSource = HikariCPDataSourceBuilder.builder(config);
        }
        String dsKey = config.dataSourceKey();
        this.targetDataSourceConfigs.put(dsKey, config);
        this.targetDataSources.put(dsKey, dataSource);
        logger.info(">>registerRealDataSource \n - dsKey:{}\n - dataSource:{}", (Object)dsKey, (Object)config.getUrl());
        if (dsKey.contains("slave")) {
            String subGroup = StringUtils.splitByWholeSeparator((String)dsKey, (String)"_slave")[0];
            if (this.slaveNumsMap.containsKey(subGroup)) {
                this.slaveNumsMap.put(subGroup, this.slaveNumsMap.get(subGroup) + 1);
            } else {
                this.slaveNumsMap.put(subGroup, 1);
            }
        }
        if (config.getTenantRouteKey() != null) {
            this.tenantDataSourceKeys.add(config.getTenantRouteKey());
            allTenantDataSourceKeys.add(config.getTenantRouteKey());
            if (!config.getScopeTenantIds().isEmpty()) {
                for (String tenantId : config.getScopeTenantIds()) {
                    this.tenantIdToKeyMapping.put(tenantId, config.getTenantRouteKey());
                    this.addDataSourceKeyToTenantMapping(config.getTenantRouteKey(), tenantId);
                }
            } else {
                this.cacheTenantIdToKeyMapping(config.getTenantRouteKey(), false);
            }
        }
        InstanceFactory.getContext().publishEvent((ApplicationEvent)new CommonApplicationEvent(SpringEventType.tenantDataSourceChanged, allTenantDataSourceKeys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cacheTenantIdToKeyMapping(String tenantRouteKey, boolean handleError) {
        String tenantId = null;
        Map<String, String> map = this.tenantIdToKeyMapping;
        synchronized (map) {
            if (this.tenantIdToKeyMapping.values().contains(tenantRouteKey)) {
                return (String)this.tenantIdToKeyMapping.entrySet().stream().filter(o -> StringUtils.equals((CharSequence)tenantRouteKey, (CharSequence)((CharSequence)o.getValue()))).findFirst().get().getKey();
            }
            if (StringUtils.isNumeric((CharSequence)tenantRouteKey)) {
                tenantId = tenantRouteKey;
            }
            if (tenantId != null) {
                this.tenantIdToKeyMapping.put(tenantId, tenantRouteKey);
                this.addDataSourceKeyToTenantMapping(tenantRouteKey, tenantId);
            }
        }
        return tenantId;
    }

    public void destroy() throws Exception {
        Collection<DataSource> dataSources = this.targetDataSources.values();
        for (DataSource dataSource : dataSources) {
            try {
                ((DruidDataSource)dataSource).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateDataSource(DataSourceConfig dataSourceConfig) {
        block5: {
            block4: {
                String dataSourceKey = dataSourceConfig.dataSourceKey();
                if (!this.targetDataSources.containsKey(dataSourceKey)) break block4;
                if (StringUtils.isBlank((CharSequence)dataSourceConfig.getTenantRouteKey())) {
                    return;
                }
                if (dataSourceConfig.getScopeTenantIds().isEmpty()) break block5;
                for (String tenantId : dataSourceConfig.getScopeTenantIds()) {
                    this.tenantIdToKeyMapping.put(tenantId, dataSourceConfig.getTenantRouteKey());
                }
                break block5;
            }
            try {
                this.registerRealDataSource(dataSourceConfig);
                logger.info(">>\u5b8c\u6210\u52a8\u6001\u6ce8\u518c\u6570\u636e\u6e90:{}", (Object)dataSourceConfig);
            }
            catch (Exception e) {
                logger.error(">>\u52a8\u6001\u65b0\u589e\u6570\u636e\u6e90\u9519\u8bef>>\n" + dataSourceConfig.toString(), (Throwable)e);
            }
        }
    }

    private void addDataSourceKeyToTenantMapping(String dsKey, String tenantId) {
        Set<String> list = this.dataSourceKeyToTenantMapping.get(dsKey);
        if (list == null) {
            list = new HashSet<String>();
            this.dataSourceKeyToTenantMapping.put(dsKey, list);
        }
        if (!list.contains(tenantId)) {
            list.add(tenantId);
        }
    }
}

