/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.kit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.util.BeanUtils;

public class CacheKeyUtils {
    public static final List<String> MYBATIS_DEFAULT_LIST_NAMES = Arrays.asList("arg0", "collection", "list");
    public static final String CONTACT_STR = "&";
    public static final String EQUALS_STR = "=";
    public static final String SPLIT_STR = ",";
    public static final String JSON_SUFFIX = "}";
    public static final String JSON_PREFIX = "{";
    public static final String BRACKET_PREFIX = "[";
    public static final String BRACKET_SUFFIX = "]";

    public static String objcetToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (BeanUtils.isSimpleDataType((Object)obj)) {
            return obj.toString();
        }
        if (obj instanceof Iterable) {
            StringBuilder sb = new StringBuilder();
            sb.append(BRACKET_PREFIX);
            for (Object object : (Iterable)obj) {
                if (BeanUtils.isSimpleDataType(object)) {
                    sb.append(object).append(SPLIT_STR);
                    continue;
                }
                sb.append(JSON_PREFIX).append(CacheKeyUtils.objcetToString(object)).append(JSON_SUFFIX).append(SPLIT_STR);
            }
            if (sb.length() == 1) {
                return "";
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(BRACKET_SUFFIX);
                return sb.toString();
            }
        }
        Map param = null;
        param = obj instanceof Map ? (Map)obj : BeanUtils.beanToMap((Object)obj, (boolean)true);
        if (param == null || param.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList keys = new ArrayList(param.keySet());
        boolean isMybatisDefaultList = keys.size() == 3 && keys.containsAll(MYBATIS_DEFAULT_LIST_NAMES);
        Collections.sort(keys);
        for (String key : keys) {
            Object value = param.get(key);
            if (value == null || StringUtils.isBlank((CharSequence)value.toString())) continue;
            if (value instanceof Map) {
                if ((value = CacheKeyUtils.objcetToString(value)) != null) {
                    value = JSON_PREFIX + value + JSON_SUFFIX;
                }
            } else if (value instanceof Iterable) {
                StringBuilder sb1 = new StringBuilder();
                sb1.append(BRACKET_PREFIX);
                for (Object object : (Iterable)value) {
                    if (BeanUtils.isSimpleDataType(object)) {
                        sb1.append(object).append(SPLIT_STR);
                        continue;
                    }
                    sb1.append(JSON_PREFIX).append(CacheKeyUtils.objcetToString(object)).append(JSON_SUFFIX).append(SPLIT_STR);
                }
                if (sb1.length() == 1) {
                    value = null;
                } else if (sb1.length() > 0) {
                    sb1.deleteCharAt(sb1.length() - 1);
                    sb1.append(BRACKET_SUFFIX);
                    value = sb1.toString();
                }
            } else if (!BeanUtils.isSimpleDataType(value)) {
                value = JSON_PREFIX + CacheKeyUtils.objcetToString(value) + JSON_SUFFIX;
            }
            if (value != null) {
                sb.append(key).append(EQUALS_STR).append(value).append(CONTACT_STR);
            }
            if (!isMybatisDefaultList) continue;
            break;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

