/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.kit;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.datasource.DataSourceConfig;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class MybatisMapperParser {
    private static final Logger log = LoggerFactory.getLogger(MybatisMapperParser.class);
    private static Map<String, List<MapperMetadata>> groupMapperMetadataMap = new HashMap<String, List<MapperMetadata>>();
    private static Map<String, MapperMetadata> mapperMetadataMappings = new HashMap<String, MapperMetadata>();

    public static void addMapperLocations(String group, Resource[] mapperLocations) {
        MybatisMapperParser.doParse(group, mapperLocations);
    }

    public static List<MapperMetadata> getMapperMetadatas(String group) {
        return groupMapperMetadataMap.get(group);
    }

    public static MapperMetadata getMapperMetadata(String mapperOrEntityName) {
        return mapperMetadataMappings.get(mapperOrEntityName);
    }

    private static synchronized void doParse(String group, Resource[] mapperLocations) {
        if (groupMapperMetadataMap.containsKey(group)) {
            return;
        }
        HashMap<String, MapperMetadata> entityInfos = new HashMap<String, MapperMetadata>();
        String mapperPath = null;
        try {
            String propKeyPrefix = "";
            if (!DataSourceConfig.DEFAULT_GROUP_NAME.equals(group)) {
                propKeyPrefix = "group[" + group + "].";
            }
            List mapperPackages = ResourceUtils.getList((String)(propKeyPrefix + "mybatis.mapper-package"));
            for (String mapperPackage : mapperPackages) {
                Resource[] resources;
                String classNameToResourcePath = ClassUtils.convertClassNameToResourcePath((String)mapperPackage);
                String pattern = "classpath*:" + classNameToResourcePath + "/**/*.class";
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                for (Resource res : resources = resolver.getResources(pattern)) {
                    String mapperClass;
                    mapperPath = StringUtils.defaultString((String)res.getURI().getPath(), (String)res.getURI().toString());
                    if (mapperPath.contains(classNameToResourcePath)) {
                        mapperClass = StringUtils.splitByWholeSeparator((String)mapperPath, (String)classNameToResourcePath)[1];
                        String className = mapperClass.substring(1).substring(0, mapperClass.lastIndexOf(".") - 1);
                        mapperClass = ClassUtils.convertResourcePathToClassName((String)(mapperPackage + "." + className));
                    } else {
                        String packagePath = StringUtils.splitByWholeSeparator((String)classNameToResourcePath, (String)"*")[0];
                        if (mapperPath.contains(".jar")) {
                            mapperPath = StringUtils.splitByWholeSeparator((String)mapperPath, (String)".jar")[1];
                        }
                        packagePath = packagePath + StringUtils.splitByWholeSeparator((String)mapperPath, (String)packagePath)[1];
                        packagePath = packagePath.substring(0, packagePath.lastIndexOf("."));
                        mapperClass = ClassUtils.convertResourcePathToClassName((String)packagePath);
                    }
                    entityInfos.put(mapperClass, new MapperMetadata(mapperClass));
                }
            }
        }
        catch (Exception e2) {
            System.err.println("parseMapperXML[" + mapperPath + "] error:" + e2.getMessage());
        }
        try {
            for (Resource resource : mapperLocations) {
                MybatisMapperParser.parseMapperFile(entityInfos, resource.getFilename(), resource.getInputStream());
            }
        }
        catch (Exception e3) {
            log.error("\u89e3\u6790mapper\u6587\u4ef6\u5f02\u5e38", (Throwable)e3);
            throw new RuntimeException("\u89e3\u6790mapper\u6587\u4ef6\u5f02\u5e38");
        }
        List entitys = entityInfos.values().stream().filter(e -> e.getEntityClass() != null).collect(Collectors.toList());
        groupMapperMetadataMap.put(group, entitys);
        log.info("<startup-logging>  parse group[{}] finish,size:{}", (Object)group, (Object)entityInfos.size());
    }

    private static void parseMapperFile(Map<String, MapperMetadata> entityInfos, String fileName, InputStream inputStream) throws Exception {
        XPathParser parser = new XPathParser(inputStream, true, null, (EntityResolver)new XMLMapperEntityResolver());
        XNode evalNode = parser.evalNode("/mapper");
        String mapperClass = evalNode.getStringAttribute("namespace");
        MapperMetadata entityInfo = entityInfos.get(mapperClass);
        if (entityInfo == null) {
            entityInfo = new MapperMetadata(mapperClass);
            entityInfos.put(mapperClass, entityInfo);
        }
        if (entityInfo.getEntityClass() == null) {
            log.warn("can't parse entityClass for:{}", (Object)mapperClass);
            return;
        }
        mapperMetadataMappings.put(mapperClass, entityInfo);
        HashMap<String, String> includes = new HashMap<String, String>();
        List children = evalNode.getChildren();
        for (XNode xNode : children) {
            if (!"sql".equalsIgnoreCase(xNode.getName())) continue;
            includes.put(xNode.getStringAttribute("id"), xNode.getStringBody());
        }
        for (XNode xNode : children) {
            if (!"select".contains(xNode.getName().toLowerCase())) continue;
            StringBuilder sql = new StringBuilder();
            MybatisMapperParser.parseSql(sql, xNode, includes);
            entityInfo.parseSqlUseTables(xNode.getStringAttribute("id"), sql.toString());
        }
        inputStream.close();
    }

    private static void parseSql(StringBuilder result, XNode node, Map<String, String> includeContents) {
        NodeList children = node.getNode().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XNode child = node.newXNode(children.item(i));
            String data = null;
            NodeList subChildren = child.getNode().getChildNodes();
            if (subChildren.getLength() > 1) {
                result.append("<").append(child.getName()).append(">");
                MybatisMapperParser.parseSql(result, child, includeContents);
                result.append("</").append(child.getName()).append(">");
                continue;
            }
            if ("#text".equals(child.getName())) {
                data = child.getStringBody("");
            } else if ("include".equals(child.getName())) {
                String refId = child.getStringAttribute("refid");
                data = child.toString();
                if (includeContents.containsKey(refId)) {
                    data = data.replaceAll("<\\s?include.*(" + refId + ").*?(?=>)>", includeContents.get(refId));
                }
            } else {
                data = "bind".equals(child.getName()) ? "" : child.toString();
            }
            data = data.replaceAll("\n{2,}", "\n");
            result.append(data);
        }
    }

    public static List<String> listFiles(JarFile jarFile, String extensions) {
        if (jarFile == null || StringUtils.isEmpty((CharSequence)extensions)) {
            return null;
        }
        ArrayList<String> files = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(extensions)) continue;
            files.add(name);
        }
        return files;
    }
}

