/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.kit;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.exception.MainErrorType;
import org.dromara.mendmix.common.util.BeanUtils;
import org.dromara.mendmix.common.util.CachingFieldUtils;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.pagination.PageSqlUtils;
import org.dromara.mendmix.mybatis.plugin.rewrite.RewriteTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisSqlRewriteUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    private static final String[] SQL_LINE_CHARS = new String[]{"\r", "\n", "\t"};
    private static final String[] SQL_LINE_REPLACE_CHARS = new String[]{" ", " ", " "};
    private static String mybatisWhereExprEnd = "</where>";
    public static String sqlWherePatternString = "(<|\\s+)WHERE|where(>|\\s+)";
    public static Pattern sqlWherePattern = Pattern.compile(sqlWherePatternString);
    private static Pattern sqlCleanPattern = Pattern.compile("[ \\t\\r\\n]{2,}");
    private static Pattern tablePattern = Pattern.compile("\\s+(FROM|JOIN)\\s+.+?(?=\\s{1})", 2);
    private static Pattern anyTagPattern = Pattern.compile("<.*?(?=>)>", 2);
    private static Pattern nestSelectPattern = Pattern.compile("\\(\\s{0,}(SELECT)\\s+", 2);
    public static final String SQL_PARAMETER_PLACEHOLDER = "?";
    private static final String parseSqlTraceName = "CCJSqlParserUtil.parse";

    public static String cleanSql(String sql) {
        sql = sqlCleanPattern.matcher(sql).replaceAll(" ");
        return sql;
    }

    public static String toSelectPkFieldSql(SqlCommandType sqlType, String sql, String idColumnName) {
        sql = sql.trim().replaceAll("\n", " ");
        String selectSql = null;
        StringBuilder sqlBuiler = new StringBuilder().append("SELECT ").append(idColumnName).append(" ");
        if (SqlCommandType.DELETE == sqlType) {
            selectSql = sqlBuiler.append(sql.substring(6)).toString();
        } else if (SqlCommandType.UPDATE == sqlType) {
            String[] segs = sql.split("\\s+", 3);
            sqlBuiler.append(" FROM ").append(segs[1]);
            segs = sqlWherePattern.split(sql, 2);
            if (segs.length == 2) {
                String maybeWhereEnd = segs[1].substring(segs[1].length() - mybatisWhereExprEnd.length()).toLowerCase();
                if (mybatisWhereExprEnd.equals(maybeWhereEnd)) {
                    sqlBuiler.append(" <where>").append(segs[1]);
                } else {
                    sqlBuiler.append(" WHERE ").append(segs[1]);
                }
            }
            selectSql = sqlBuiler.toString();
        }
        return selectSql;
    }

    public static SqlMetadata rewriteAsSelectPkField(String sql, String idColumnName) {
        try {
            sql = MybatisSqlRewriteUtils.cleanSql(sql);
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            Table table = null;
            Expression where = null;
            int startIndex = 0;
            int endIndex = 0;
            if (statement instanceof Update) {
                Update update = (Update)statement;
                table = update.getTable();
                where = update.getWhere();
                endIndex = startIndex = StringUtils.countMatches((CharSequence)update.getExpressions().toString(), (CharSequence)SQL_PARAMETER_PLACEHOLDER);
            } else if (statement instanceof Delete) {
                Delete delete = (Delete)statement;
                table = delete.getTable();
                where = delete.getWhere();
            } else {
                return null;
            }
            PlainSelect selectBody = new PlainSelect();
            selectBody.setFromItem((FromItem)table);
            SelectExpressionItem selectItem = new SelectExpressionItem((Expression)new Column(idColumnName));
            selectBody.setSelectItems(Arrays.asList(selectItem));
            selectBody.setWhere(where);
            Select select = new Select();
            select.setSelectBody((SelectBody)selectBody);
            String rewriteSql = selectBody.toString();
            while (rewriteSql.contains(SQL_PARAMETER_PLACEHOLDER)) {
                rewriteSql = StringUtils.replaceOnce((String)rewriteSql, (String)SQL_PARAMETER_PLACEHOLDER, (String)"{x}");
                ++endIndex;
            }
            rewriteSql = StringUtils.replace((String)rewriteSql, (String)"{x}", (String)SQL_PARAMETER_PLACEHOLDER);
            return new SqlMetadata(rewriteSql, table.getName(), startIndex, endIndex - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> parseSqlUseTables(String sql) {
        ArrayList<String> tables = new ArrayList<String>(3);
        try {
            String cleanSql = StringUtils.replaceEach((String)sql, (String[])SQL_LINE_CHARS, (String[])SQL_LINE_REPLACE_CHARS).trim();
            cleanSql = anyTagPattern.matcher(cleanSql).replaceAll("").trim();
            Matcher matcher = tablePattern.matcher(cleanSql);
            while (matcher.find()) {
                String table;
                if (matcher.group().contains("(") || tables.contains(table = matcher.group().trim().split("\\s+")[1].trim())) continue;
                tables.add(table);
            }
        }
        catch (Exception e) {
            System.err.println("--------------------------------------\n" + sql);
        }
        return tables;
    }

    public static void parseDyncQueryParameters(BoundSql boundSql, SqlMetadata sqlMetadata) throws Exception {
        List parameterMappings = boundSql.getParameterMappings();
        Object parameterObject = boundSql.getParameterObject();
        if (parameterMappings.size() == 1) {
            MybatisSqlRewriteUtils.setSqlMetadataParamer(sqlMetadata, (ParameterMapping)parameterMappings.get(0), parameterObject);
        } else {
            Object indexValue = null;
            for (int i = sqlMetadata.getWhereParameterStartIndex(); i <= sqlMetadata.getWhereParameterEndIndex(); ++i) {
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getProperty().startsWith("__frch_")) {
                    indexValue = boundSql.getAdditionalParameter(parameterMapping.getProperty());
                    sqlMetadata.getParameters().add(indexValue);
                    continue;
                }
                MybatisSqlRewriteUtils.setSqlMetadataParamer(sqlMetadata, parameterMapping, parameterObject);
            }
        }
    }

    public static Statement parseSql(String sql) {
        Statement statement = null;
        Exception ex = null;
        try {
            statement = CCJSqlParserUtil.parse((String)sql);
        }
        catch (Exception e) {
            String cleanSql = MybatisSqlRewriteUtils.cleanSql(sql);
            try {
                statement = CCJSqlParserUtil.parse((String)cleanSql);
            }
            catch (Exception e1) {
                ex = e1;
                logger.error(">> PARSER_SQL_ERROR \n -sql:{} -\n -reason:{}", (Object)sql, (Object)ExceptionUtils.getRootCauseStackTrace((Throwable)e1));
            }
        }
        return statement;
    }

    public static String rewriteTableNames(String sql, Map<String, String> rewriteTableNameMapping) {
        try {
            Statement statement = MybatisSqlRewriteUtils.parseSql(sql);
            Table table = null;
            if (statement instanceof Select) {
                PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
                table = (Table)select.getFromItem();
            } else if (statement instanceof Update) {
                table = ((Update)statement).getTable();
            } else if (statement instanceof Delete) {
                table = ((Delete)statement).getTable();
            } else if (statement instanceof Insert) {
                table = ((Insert)statement).getTable();
            } else {
                throw new MendmixBaseException(MainErrorType.NOT_SUPPORT);
            }
            String tableName = StringUtils.remove((String)table.getName(), (String)RewriteTable.nameDelimiter);
            if (rewriteTableNameMapping.containsKey(tableName)) {
                table.setName(rewriteTableNameMapping.get(tableName));
                sql = statement.toString();
            }
            return sql;
        }
        catch (Exception e) {
            throw new MendmixBaseException(500, "\u91cd\u5199sql\u5f02\u5e38", (Throwable)e);
        }
    }

    public static boolean withWhereConditions(String sql) {
        String[] parts = sqlWherePattern.split(sql = MybatisSqlRewriteUtils.cleanSql(sql), 2);
        if (parts.length == 1 || StringUtils.isBlank((CharSequence)parts[1])) {
            String selectHead = PageSqlUtils.matchTopSelectFrom(sql);
            String removeSelectHead = sql.substring(selectHead.length());
            if (nestSelectPattern.matcher(removeSelectHead).find()) {
                String innerSql = PageSqlUtils.matchOutterParenthesesPair(removeSelectHead);
                return MybatisSqlRewriteUtils.withWhereConditions(innerSql);
            }
            return false;
        }
        String removeSpaceWhere = StringUtils.remove((String)parts[1].trim(), (String)" ");
        return !removeSpaceWhere.substring(0, 2).equals("1=");
    }

    private static void setSqlMetadataParamer(SqlMetadata sqlMetadata, ParameterMapping parameterMapping, Object parameterObject) {
        String propertyName = parameterMapping.getProperty();
        String[] parts = StringUtils.split((String)propertyName, (String)".");
        Object value = parameterObject;
        for (String part : parts) {
            if (value instanceof Map) {
                value = ((Map)value).get(part);
                continue;
            }
            if (BeanUtils.isSimpleDataType((Object)value)) continue;
            value = CachingFieldUtils.readField((Object)value, (String)part);
        }
        if (value != null && value.getClass().isEnum()) {
            value = value.toString();
        }
        sqlMetadata.getParameters().add(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> dynaQueryConditionToIdList(DataSource dataSource, OnceContextVal invocationVal) {
        Connection connection = null;
        java.sql.Statement statement = null;
        ResultSet rs = null;
        try {
            BoundSql boundSql = invocationVal.getMappedStatement().getBoundSql(invocationVal.getParameter());
            String orignSql = boundSql.getSql();
            String idColumn = invocationVal.getEntityInfo().getIdColumn();
            SqlMetadata sqlMetadata = MybatisSqlRewriteUtils.rewriteAsSelectPkField(orignSql, idColumn);
            MybatisSqlRewriteUtils.parseDyncQueryParameters(boundSql, sqlMetadata);
            connection = dataSource.getConnection();
            String sql = sqlMetadata.getSql();
            Map<String, String> rewriteTableNameMapping = invocationVal.getTableNameMapping();
            if (rewriteTableNameMapping != null && !rewriteTableNameMapping.isEmpty()) {
                sql = MybatisSqlRewriteUtils.rewriteTableNames(sql, rewriteTableNameMapping);
            }
            if (CurrentRuntimeContext.isDebugMode()) {
                logger.info("<debug_trace_logging> dynaQueryConditionIdList sql:{}", (Object)sql);
            }
            statement = connection.prepareStatement(sql);
            List<Object> parameters = sqlMetadata.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                statement.setObject(i + 1, parameters.get(i));
            }
            rs = statement.executeQuery();
            ArrayList<Object> ids = new ArrayList<Object>();
            while (rs.next()) {
                ids.add(rs.getObject(1));
            }
            ArrayList<Object> arrayList = ids;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("dynaQueryDeleteIdList_ERROR", (Throwable)e);
            ArrayList<Object> arrayList = new ArrayList<Object>(0);
            return arrayList;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) throws Exception {
        String fileSql = "SELECT d.* FROM (SELECT  a.* FROM device a ) d";
        System.out.println(MybatisSqlRewriteUtils.withWhereConditions(fileSql));
        fileSql = "SELECT d.* FROM (SELECT  a.* FROM device a WHERE a.id = '1') d";
        System.out.println(MybatisSqlRewriteUtils.withWhereConditions(fileSql));
        fileSql = "SELECT  a.* FROM device a WHERE a = 1";
        System.out.println(MybatisSqlRewriteUtils.withWhereConditions(fileSql));
    }

    public static class SqlMetadata {
        String sql;
        String tableName;
        int whereParameterStartIndex;
        int whereParameterEndIndex;
        List<Object> parameters;

        public SqlMetadata(String sql, String tableName, int whereParameterStartIndex, int whereParameterEndIndex) {
            this.sql = sql;
            this.tableName = tableName;
            this.whereParameterStartIndex = whereParameterStartIndex;
            this.whereParameterEndIndex = whereParameterEndIndex;
            this.parameters = new ArrayList<Object>(whereParameterEndIndex - whereParameterStartIndex);
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public int getWhereParameterStartIndex() {
            return this.whereParameterStartIndex;
        }

        public void setWhereParameterStartIndex(int whereParameterStartIndex) {
            this.whereParameterStartIndex = whereParameterStartIndex;
        }

        public int getWhereParameterEndIndex() {
            return this.whereParameterEndIndex;
        }

        public void setWhereParameterEndIndex(int whereParameterEndIndex) {
            this.whereParameterEndIndex = whereParameterEndIndex;
        }

        public List<Object> getParameters() {
            return this.parameters;
        }

        public void setParameters(List<Object> parameters) {
            this.parameters = parameters;
        }
    }
}

