/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.mapping.SqlCommandType;
import org.dromara.mendmix.common.model.Page;
import org.dromara.mendmix.common.model.PageParams;
import org.dromara.mendmix.common.util.ExceptionFormatUtils;
import org.dromara.mendmix.mybatis.exception.MybatisHanlerInitException;
import org.dromara.mendmix.mybatis.kit.MybatisSqlRewriteUtils;
import org.dromara.mendmix.mybatis.metadata.ColumnMetadata;
import org.dromara.mendmix.mybatis.metadata.EntityMetadata;
import org.dromara.mendmix.mybatis.metadata.MetadataHelper;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperMetadata {
    private static final Logger log = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    private static List<String> queryMethodPrefixs = Arrays.asList("select", "query", "get", "list", "find");
    private String tableName;
    private Class<?> entityClass;
    private Class<?> mapperClass;
    private EntityMetadata entityMetadata;
    private Map<String, List<String>> queryTableMappings = new HashMap<String, List<String>>();
    private Map<String, String> propToColumnMappings = new HashMap<String, String>();
    private Map<String, MapperMethod> mapperMethods = new HashMap<String, MapperMethod>();

    public MapperMetadata(String mapperClassName) {
        try {
            this.mapperClass = Class.forName(mapperClassName);
            if (!this.mapperClass.isInterface()) {
                return;
            }
            this.parseEntityInfo();
            if (this.entityClass == null) {
                return;
            }
            if (this.entityClass.isAnnotationPresent(Table.class)) {
                this.tableName = this.entityClass.getAnnotation(Table.class).name();
            }
            ArrayList<Method> methods = new ArrayList<Method>();
            MapperMetadata.parseAllMethod(this.mapperClass, methods);
            String sql = null;
            for (Method method : methods) {
                Object sqlType;
                String fullName = this.mapperClass.getName() + "." + method.getName();
                if (method.isAnnotationPresent(Select.class)) {
                    sql = method.getAnnotation(Select.class).value()[0];
                    sqlType = SqlCommandType.SELECT;
                } else if (method.isAnnotationPresent(Update.class)) {
                    sql = method.getAnnotation(Update.class).value()[0];
                    sqlType = SqlCommandType.UPDATE;
                } else if (method.isAnnotationPresent(Delete.class)) {
                    sql = method.getAnnotation(Delete.class).value()[0];
                    sqlType = SqlCommandType.DELETE;
                } else if (method.isAnnotationPresent(Insert.class)) {
                    sql = method.getAnnotation(Insert.class).value()[0];
                    sqlType = SqlCommandType.INSERT;
                } else {
                    sqlType = queryMethodPrefixs.stream().anyMatch(e -> method.getName().startsWith((String)e)) ? SqlCommandType.SELECT : null;
                    sql = null;
                }
                if (sql != null) {
                    List<String> tables = MybatisSqlRewriteUtils.parseSqlUseTables(sql);
                    this.queryTableMappings.put(fullName, tables);
                }
                this.mapperMethods.put(method.getName(), new MapperMethod(method, fullName, (SqlCommandType)sqlType));
            }
            log.debug("cache [{} -> {}] mapping finished", (Object)this.entityClass.getName(), (Object)mapperClassName);
        }
        catch (Exception e2) {
            log.error(">>>parse [{}] error,reason:{}", (Object)mapperClassName, (Object)e2.getMessage());
        }
    }

    public MapperMetadata(String mapperClassName, String entityClassName, String tableName) {
        this.tableName = tableName;
        try {
            if (StringUtils.isNotBlank((CharSequence)entityClassName)) {
                this.entityClass = Class.forName(entityClassName);
            }
            if (StringUtils.isBlank((CharSequence)this.tableName)) {
                this.tableName = this.entityClass.getAnnotation(Table.class).name();
            }
            this.mapperClass = Class.forName(mapperClassName);
        }
        catch (Exception e) {
            try {
                Type[] types = this.mapperClass.getGenericInterfaces();
                Type[] tempTypes = ((ParameterizedType)types[0]).getActualTypeArguments();
                Class clazz = (Class)tempTypes[0];
                if (clazz != null) {
                    this.entityClass = clazz;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public Class<?> getMapperClass() {
        return this.mapperClass;
    }

    public void setMapperClass(Class<?> mapperClass) {
        this.mapperClass = mapperClass;
    }

    public Map<String, List<String>> getQueryTableMappings() {
        return this.queryTableMappings;
    }

    public void parseSqlUseTables(String id, String sql) {
        String fullName = this.mapperClass.getName() + "." + id;
        List<String> tables = MybatisSqlRewriteUtils.parseSqlUseTables(sql);
        this.queryTableMappings.put(fullName, tables);
        if (tables.isEmpty()) {
            log.warn(">>parse usingTables error for:{}", (Object)fullName);
        }
    }

    public Class<?> getIdType() {
        return this.entityMetadata.getIdColumn().getJavaType();
    }

    public String getIdProperty() {
        return this.entityMetadata.getIdColumn().getProperty();
    }

    public String getIdColumn() {
        return this.entityMetadata.getIdColumn().getColumn();
    }

    public Map<String, MapperMethod> getMapperMethods() {
        return this.mapperMethods;
    }

    public MapperMethod getMapperMethod(String methodFullName) {
        return this.mapperMethods.get(methodFullName);
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public Map<String, String> getPropToColumnMappings() {
        return this.propToColumnMappings;
    }

    public String property2ColumnName(String propName) {
        return this.propToColumnMappings.get(propName);
    }

    public static <T extends Annotation> T getAnnotation(OnceContextVal invocation, Class<T> annotationClass) {
        MapperMetadata entityInfo = invocation.getEntityInfo();
        if (entityInfo == null || entityInfo.getMapperClass() == null) {
            return null;
        }
        T annotation = entityInfo.getMapperClass().getAnnotation(annotationClass);
        if (annotation == null) {
            try {
                String methodName = invocation.getMappedStatement().getId().replace(invocation.getMapperNameSpace(), "").substring(1);
                MapperMethod method = entityInfo.getMapperMethod(methodName);
                if (method != null) {
                    annotation = method.getMethod().getAnnotation(annotationClass);
                }
            }
            catch (Exception e) {
                log.error("getAnnotation[{}] form class[{}] error:{}", new Object[]{annotationClass.getName(), entityInfo.getMapperClass().getName(), ExceptionFormatUtils.buildExceptionMessages((Throwable)e, (int)3)});
            }
        }
        return annotation;
    }

    private static void parseAllMethod(Class<?> clazz, List<Method> methods) {
        Class<?>[] interfaces;
        if (clazz.getDeclaredMethods() != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                methods.add(method);
            }
        }
        for (Class<?> interClass : interfaces = clazz.getInterfaces()) {
            MapperMetadata.parseAllMethod(interClass, methods);
        }
    }

    private void parseEntityInfo() {
        Type[] interfacesTypes = this.mapperClass.getGenericInterfaces();
        if (interfacesTypes == null || interfacesTypes.length == 0) {
            return;
        }
        try {
            Type[] genericTypes = ((ParameterizedType)interfacesTypes[0]).getActualTypeArguments();
            if (genericTypes == null || genericTypes.length == 0) {
                return;
            }
            this.entityClass = (Class)genericTypes[0];
        }
        catch (Exception e) {
            log.warn("Entity found for mapper:{}", (Object)this.mapperClass.getClass().getName());
            return;
        }
        Set<ColumnMetadata> columns = MetadataHelper.getEntityMapper(this.entityClass).getColumnsMapper();
        for (ColumnMetadata column : columns) {
            this.propToColumnMappings.put(column.getProperty(), column.getColumn());
        }
        this.entityMetadata = MetadataHelper.getEntityMapper(this.entityClass);
    }

    public static class MapperMethod {
        Method method;
        String fullName;
        SqlCommandType sqlType;
        boolean pageQuery;
        Class<?> resultActualClass;

        public MapperMethod(Method method, String fullName, SqlCommandType sqlType) {
            this.method = method;
            this.fullName = fullName;
            this.sqlType = sqlType;
            if (method.getReturnType() == Page.class) {
                Class<?> clazz;
                Class<?>[] parameterTypes;
                boolean withPageParams = false;
                Class<?>[] classArray = parameterTypes = method.getParameterTypes();
                int n = classArray.length;
                for (int i = 0; i < n && !(withPageParams = (clazz = classArray[i]) == PageParams.class || clazz.getSuperclass() == PageParams.class); ++i) {
                }
                if (!withPageParams) {
                    throw new MybatisHanlerInitException(String.format("method[%s] returnType is:Page,but not found Parameter[PageParams] in Parameters list", method.getName()));
                }
                this.pageQuery = true;
            }
        }

        public Method getMethod() {
            return this.method;
        }

        public String getFullName() {
            return this.fullName;
        }

        public SqlCommandType getSqlType() {
            return this.sqlType;
        }

        public boolean isPageQuery() {
            return this.pageQuery;
        }

        public Class<?> getResultActualClass() {
            return this.resultActualClass;
        }
    }
}

