/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.util.StringConverter;
import org.dromara.mendmix.mybatis.core.BaseEntity;
import org.dromara.mendmix.mybatis.crud.annotation.FuzzyMatch;
import org.dromara.mendmix.mybatis.metadata.ColumnMetadata;
import org.dromara.mendmix.mybatis.metadata.EntityMetadata;
import org.dromara.mendmix.mybatis.metadata.TableMetadata;
import org.dromara.mendmix.mybatis.plugin.autofield.annotation.CreatedAt;
import org.dromara.mendmix.mybatis.plugin.autofield.annotation.CreatedBy;
import org.dromara.mendmix.mybatis.plugin.autofield.annotation.UpdatedAt;
import org.dromara.mendmix.mybatis.plugin.autofield.annotation.UpdatedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataHelper {
    private static final Logger log = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    private static final Map<Class<?>, EntityMetadata> tableMapperCache = new HashMap();
    private static final Map<String, Map<String, Field>> entityFieldMappings = new HashMap<String, Map<String, Field>>();
    private static final Map<String, List<ColumnMetadata>> tableColumnMappings = new HashMap<String, List<ColumnMetadata>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityMetadata getEntityMapper(Class<?> entityClass) {
        EntityMetadata entityMapper = tableMapperCache.get(entityClass);
        if (entityMapper != null) {
            return entityMapper;
        }
        Class<?> clazz = entityClass;
        synchronized (clazz) {
            TableMetadata tableMapper = MetadataHelper.getTableMapper(entityClass);
            if (tableMapper == null) {
                return null;
            }
            Class<?> idClass = MetadataHelper.getIdClass(entityClass);
            List<Field> fields = MetadataHelper.getAllField(entityClass);
            HashSet<ColumnMetadata> columnMapperSet = new HashSet<ColumnMetadata>();
            ColumnMetadata idColumn = null;
            GenerationType idStrategy = null;
            HashMap<String, Field> map = new HashMap<String, Field>();
            for (Field field : fields) {
                if (field.isAnnotationPresent(Transient.class)) continue;
                ColumnMetadata columnMapper = new ColumnMetadata();
                String columnName = null;
                if (field.isAnnotationPresent(Column.class)) {
                    Column column = field.getAnnotation(Column.class);
                    columnName = column.name();
                    columnMapper.setInsertable(column.insertable());
                    columnMapper.setUpdatable(column.updatable());
                }
                columnMapper.setVersionField(field.isAnnotationPresent(Version.class));
                columnMapper.setCreatedByField(field.isAnnotationPresent(CreatedBy.class));
                columnMapper.setCreatedAtField(field.isAnnotationPresent(CreatedAt.class));
                columnMapper.setUpdatedAtField(field.isAnnotationPresent(UpdatedAt.class));
                columnMapper.setUpdatedByField(field.isAnnotationPresent(UpdatedBy.class));
                columnMapper.setFuzzyMatch(field.isAnnotationPresent(FuzzyMatch.class));
                if (columnMapper.isUpdatable() && (columnMapper.isCreatedAtField() || columnMapper.isCreatedByField())) {
                    columnMapper.setUpdatable(false);
                }
                if (columnName == null || columnName.equals("")) {
                    columnName = StringConverter.toUnderlineCase((String)field.getName());
                }
                columnMapper.setProperty(field.getName());
                columnMapper.setColumn(columnName);
                columnMapper.setJavaType(field.getType());
                if (field.isAnnotationPresent(Id.class)) {
                    columnMapper.setId(true);
                    if (field.isAnnotationPresent(GeneratedValue.class)) {
                        idStrategy = field.getAnnotation(GeneratedValue.class).strategy();
                    }
                    idColumn = columnMapper;
                }
                columnMapperSet.add(columnMapper);
                field.setAccessible(true);
                map.put(field.getName(), field);
            }
            entityFieldMappings.put(tableMapper.getName().toLowerCase(), map);
            if (columnMapperSet.size() <= 0) {
                throw new RuntimeException("\u5b9e\u4f53" + entityClass.getName() + "\u4e0d\u5b58\u5728\u6620\u5c04\u5b57\u6bb5");
            }
            if (idColumn == null) {
                throw new RuntimeException("\u5b9e\u4f53" + entityClass.getName() + "\u4e0d\u5b58\u5728\u4e3b\u952e");
            }
            entityMapper = new EntityMetadata();
            entityMapper.setTableMapper(tableMapper);
            entityMapper.setColumnsMapper(columnMapperSet);
            entityMapper.setIdClass(idClass);
            entityMapper.setIdColumn(idColumn);
            entityMapper.setIdStrategy(idStrategy);
            tableMapperCache.put(entityClass, entityMapper);
            tableColumnMappings.put(tableMapper.getName(), new ArrayList<ColumnMetadata>(columnMapperSet));
            return entityMapper;
        }
    }

    public static List<ColumnMetadata> getTableColumnMappers(String tableName) {
        return tableColumnMappings.get(tableName);
    }

    public static boolean hasTableColumn(String tableName, String column) {
        if (!tableColumnMappings.containsKey(tableName)) {
            return false;
        }
        return tableColumnMappings.get(tableName).stream().anyMatch(o -> o.getColumn().equals(column));
    }

    private static Class<?> getIdClass(Class<?> entityClass) {
        Type[] genTypes = entityClass.getGenericInterfaces();
        for (int i = 0; i < genTypes.length; ++i) {
            String s2;
            Type genType = genTypes[i];
            String s1 = genType.getClass().getName();
            if (!s1.startsWith(s2 = BaseEntity.class.getName())) continue;
            Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
            Class mapperClass = (Class)params[0];
            return mapperClass;
        }
        return null;
    }

    private static TableMetadata getTableMapper(Class<?> entityClass) {
        TableMetadata tableMapper = new TableMetadata();
        String tableName = null;
        if (entityClass.isAnnotationPresent(Table.class)) {
            Table table = entityClass.getAnnotation(Table.class);
            tableName = StringUtils.isNotBlank((CharSequence)table.name()) ? table.name() : StringConverter.toUnderlineCase((String)entityClass.getSimpleName());
        }
        if (tableName == null || tableName.equals("")) {
            log.error(">>>>>\u5b9e\u4f53" + entityClass.getName() + "\u4e0d\u5b58\u5728'Table'\u6ce8\u89e3");
            return null;
        }
        tableMapper.setName(tableName);
        return tableMapper;
    }

    private static List<Field> getAllField(Class<?> entityClass) {
        return MetadataHelper.getAllField(entityClass, null);
    }

    private static List<Field> getAllField(Class<?> entityClass, List<Field> fieldList) {
        Field[] fields;
        if (fieldList == null) {
            fieldList = new ArrayList<Field>();
        }
        if (entityClass.equals(Object.class)) {
            return fieldList;
        }
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldList.add(field);
        }
        Class<?> superClass = entityClass.getSuperclass();
        if (!(superClass == null || superClass.equals(Object.class) || Map.class.isAssignableFrom(superClass) || Collection.class.isAssignableFrom(superClass))) {
            return MetadataHelper.getAllField(entityClass.getSuperclass(), fieldList);
        }
        return fieldList;
    }

    public static Field getEntityField(String tableName, String fieldName) {
        return entityFieldMappings.get(tableName.toLowerCase()).get(fieldName);
    }
}

