/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.MybatisConfigs;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.datasource.DataSoureConfigHolder;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.dromara.mendmix.mybatis.plugin.autofield.AutoFieldFillHandler;
import org.dromara.mendmix.mybatis.plugin.cache.CacheHandler;
import org.dromara.mendmix.mybatis.plugin.deletebackup.DeleteBackupHandler;
import org.dromara.mendmix.mybatis.plugin.operProtect.SensitiveOperProtectHandler;
import org.dromara.mendmix.mybatis.plugin.pagination.PaginationHandler;
import org.dromara.mendmix.mybatis.plugin.rewrite.SqlRewriteHandler;
import org.dromara.mendmix.mybatis.plugin.rwseparate.RwRouteHandler;
import org.dromara.mendmix.mybatis.plugin.sensitive.SensitiveCryptHandler;
import org.dromara.mendmix.mybatis.plugin.shard.TableShardingHandler;
import org.dromara.mendmix.mybatis.plugin.timezone.TimeZoneConvertHandler;
import org.dromara.mendmix.spring.InstanceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MendmixMybatisInterceptor
implements Interceptor,
DisposableBean {
    protected static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    private String groupName;
    private List<PluginInterceptorHandler> interceptorHandlers = new ArrayList<PluginInterceptorHandler>();
    private SqlRewriteHandler sqlRewriteHandler;
    private static boolean cacheEnabled;
    private static boolean rwRouteEnabled;
    private DataSource dataSource;

    public MendmixMybatisInterceptor(String groupName, String[] hanlderNames) {
        this(groupName);
    }

    public MendmixMybatisInterceptor(String groupName) {
        this.groupName = groupName;
        if (ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.sqlRewrite.enabled", (boolean)true)) {
            this.sqlRewriteHandler = new SqlRewriteHandler();
            this.interceptorHandlers.add(this.sqlRewriteHandler);
        }
        if (ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.autoField.enabled", (boolean)true)) {
            this.interceptorHandlers.add(new AutoFieldFillHandler());
        }
        if (ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.pagination.enabled", (boolean)true)) {
            this.interceptorHandlers.add(new PaginationHandler());
        }
        if (cacheEnabled = MybatisConfigs.isCacheEnabled(groupName)) {
            this.interceptorHandlers.add(new CacheHandler());
        }
        if (rwRouteEnabled = DataSoureConfigHolder.containsSlaveConfig()) {
            this.interceptorHandlers.add(new RwRouteHandler());
        }
        if (ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.timeToUTC.enabled", (boolean)false)) {
            this.interceptorHandlers.add(new TimeZoneConvertHandler());
        }
        if (ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.sensitiveCrypt.enabled", (boolean)false)) {
            this.interceptorHandlers.add(new SensitiveCryptHandler());
        }
        if (ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.tableshard.enabled", (boolean)false)) {
            this.interceptorHandlers.add(new TableShardingHandler());
        }
        if (ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.tableshard.enabled", (boolean)false)) {
            this.interceptorHandlers.add(new TableShardingHandler());
        }
        if (ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.operProtect.enabled", (boolean)false)) {
            this.interceptorHandlers.add(new SensitiveOperProtectHandler());
        }
        if (ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.deletebackup.enabled", (boolean)true)) {
            this.interceptorHandlers.add(new DeleteBackupHandler());
        }
        this.initCustomInterceptorHandlers();
        Collections.sort(this.interceptorHandlers, new Comparator<PluginInterceptorHandler>(){

            @Override
            public int compare(PluginInterceptorHandler o1, PluginInterceptorHandler o2) {
                return Integer.compare(o1.interceptorOrder(), o2.interceptorOrder());
            }
        });
    }

    private void initCustomInterceptorHandlers() {
        List<String> handlerNames = MybatisConfigs.getCustomHandlerNames(this.groupName);
        for (String name : handlerNames) {
            try {
                Class<?> clazz = Class.forName(name);
                PluginInterceptorHandler handler = (PluginInterceptorHandler)clazz.newInstance();
                this.interceptorHandlers.add(handler);
                logger.info("<startup-logging>  registered cumstom InterceptorHandler:{}", (Object)name);
            }
            catch (Exception e) {
                logger.error("registered cumstom InterceptorHandler error", (Throwable)e);
            }
        }
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (MybatisRuntimeContext.isIgnoreAny()) {
            return invocation.proceed();
        }
        String groupName = this.groupName;
        OnceContextVal invocationVal = new OnceContextVal(groupName, invocation);
        Object result = null;
        boolean cacheHited = false;
        for (PluginInterceptorHandler handler : this.interceptorHandlers) {
            result = handler.onInterceptor(invocationVal);
            if (result == null) continue;
            cacheHited = handler.getClass() == CacheHandler.class;
            break;
        }
        if (result == null) {
            result = invocation.proceed();
        }
        for (PluginInterceptorHandler handler : this.interceptorHandlers) {
            if (cacheHited && handler.getClass() == CacheHandler.class) continue;
            try {
                handler.onFinished(invocationVal, result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (result != null && invocationVal.isSelectByPrimaryKey() && !invocationVal.isSqlRewrited() && this.sqlRewriteHandler != null) {
            try {
                List asList = (List)result;
                if (!asList.isEmpty() && !this.sqlRewriteHandler.matchRewriteStrategy(invocationVal, asList.get(0))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("<soft_dataFilter_trace> {} \u547d\u4e2d\u8bb0\u5f55\uff1a{},\u4e0d\u5339\u914d\u5f53\u524d\u6570\u636e\u6743\u9650", (Object)invocationVal.getMappedStatement().getId(), (Object)asList.size());
                    }
                    asList.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MybatisRuntimeContext.unsetOnceContext();
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    public void afterRegister() {
        Map dataSources = InstanceFactory.getBeansOfType(DataSource.class);
        if (dataSources.size() == 1) {
            this.dataSource = (DataSource)new ArrayList(dataSources.values()).get(0);
        } else {
            for (String beanName : dataSources.keySet()) {
                if (!beanName.startsWith(this.groupName)) continue;
                this.dataSource = (DataSource)dataSources.get(beanName);
                break;
            }
        }
        for (PluginInterceptorHandler handler : this.interceptorHandlers) {
            handler.start(this);
        }
    }

    public void destroy() throws Exception {
        for (PluginInterceptorHandler handler : this.interceptorHandlers) {
            handler.close();
        }
    }

    public static boolean isCacheEnabled() {
        return cacheEnabled;
    }

    public static boolean isRwRouteEnabled() {
        return rwRouteEnabled;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public List<PluginInterceptorHandler> getInterceptorHandlers() {
        return this.interceptorHandlers;
    }

    public <T extends PluginInterceptorHandler> T getInterceptorHandler(Class<T> clazz) {
        PluginInterceptorHandler handler = this.interceptorHandlers.stream().filter(o -> o.getClass() == clazz).findFirst().orElse(null);
        return (T)handler;
    }
}

