/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin;

import java.util.concurrent.Callable;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;

public class OnceInterceptorStrategy {
    private String originTenantId;
    private boolean originIgnoreAny;
    private boolean originIgnoreTenant;
    private boolean originIgnoreDataPermission;
    private boolean originIgnoreSoftDeleteConditon;
    private boolean originIgnoreTableSharding;
    private boolean originIgnoreSqlRewrite;
    private boolean originIgnoreChangeLog;
    private boolean originIgnoreRwRoute;

    private OnceInterceptorStrategy() {
    }

    public static OnceInterceptorStrategy apply() {
        OnceInterceptorStrategy strategy = new OnceInterceptorStrategy();
        strategy.originTenantId = CurrentRuntimeContext.getTenantId();
        strategy.originIgnoreAny = MybatisRuntimeContext.isIgnoreAny();
        strategy.originIgnoreTenant = MybatisRuntimeContext.isIgnoreTenantMode();
        strategy.originIgnoreDataPermission = MybatisRuntimeContext.isIgnoreDataPermission();
        strategy.originIgnoreSoftDeleteConditon = MybatisRuntimeContext.isIgnoreSoftDeleteConditon();
        strategy.originIgnoreTableSharding = MybatisRuntimeContext.isIgnoreTableSharding();
        strategy.originIgnoreSqlRewrite = MybatisRuntimeContext.isIgnoreSqlRewrite();
        strategy.originIgnoreChangeLog = MybatisRuntimeContext.isIgnoreLoggingDataChange();
        strategy.originIgnoreRwRoute = MybatisRuntimeContext.isIgnoreRwRoute();
        return strategy;
    }

    public OnceInterceptorStrategy ignoreAny() {
        MybatisRuntimeContext.setIgnoreAny(true);
        return this;
    }

    public OnceInterceptorStrategy ignoreRwRoute() {
        MybatisRuntimeContext.setIgnoreRwRoute(true);
        return this;
    }

    public OnceInterceptorStrategy ignoreTenant() {
        MybatisRuntimeContext.setIgnoreTenant(true);
        return this;
    }

    public OnceInterceptorStrategy ignoreDataPermission() {
        MybatisRuntimeContext.setIgnoreDataPermission(true);
        return this;
    }

    public OnceInterceptorStrategy ignoreSoftDeleteConditon() {
        MybatisRuntimeContext.setIgnoreSoftDeleteConditon(true);
        return this;
    }

    public OnceInterceptorStrategy ignoreTableSharding() {
        MybatisRuntimeContext.setIgnoreTableSharding(true);
        return this;
    }

    public OnceInterceptorStrategy ignoreSqlRewrite() {
        MybatisRuntimeContext.setIgnoreSqlRewrite(true);
        return this;
    }

    public OnceInterceptorStrategy ignoreLoggingDataChange() {
        MybatisRuntimeContext.setIgnoreLoggingDataChange(true);
        return this;
    }

    public OnceInterceptorStrategy usingTenant(String tenantId) {
        CurrentRuntimeContext.setTenantId((String)tenantId);
        return this;
    }

    public <V> V exec(Callable<V> caller) {
        boolean originIgnoreCache = MybatisRuntimeContext.isIgnoreCache();
        MybatisRuntimeContext.setIgnoreCache(true);
        try {
            V v = caller.call();
            return v;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ThreadLocalContext.set((String)"x-tenant-id", (Object)this.originTenantId);
            MybatisRuntimeContext.setIgnoreAny(this.originIgnoreAny);
            MybatisRuntimeContext.setIgnoreCache(originIgnoreCache);
            MybatisRuntimeContext.setIgnoreTenant(this.originIgnoreTenant);
            MybatisRuntimeContext.setIgnoreDataPermission(this.originIgnoreDataPermission);
            MybatisRuntimeContext.setIgnoreSoftDeleteConditon(this.originIgnoreSoftDeleteConditon);
            MybatisRuntimeContext.setIgnoreSqlRewrite(this.originIgnoreSqlRewrite);
            MybatisRuntimeContext.setIgnoreTableSharding(this.originIgnoreTableSharding);
            MybatisRuntimeContext.setIgnoreLoggingDataChange(this.originIgnoreChangeLog);
            MybatisRuntimeContext.setIgnoreRwRoute(this.originIgnoreRwRoute);
        }
    }
}

