/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.autofield;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.util.CachingFieldUtils;
import org.dromara.mendmix.common.util.ExceptionFormatUtils;
import org.dromara.mendmix.mybatis.MybatisConfigs;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.core.BaseEntity;
import org.dromara.mendmix.mybatis.crud.CrudMethods;
import org.dromara.mendmix.mybatis.kit.MybatisMapperParser;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.dromara.mendmix.mybatis.plugin.autofield.DefaultIdGenerator;
import org.dromara.mendmix.mybatis.plugin.autofield.IDGenerator;
import org.dromara.mendmix.mybatis.plugin.autofield.annotation.CreatedAt;
import org.dromara.mendmix.mybatis.plugin.autofield.annotation.CreatedBy;
import org.dromara.mendmix.mybatis.plugin.autofield.annotation.UpdatedAt;
import org.dromara.mendmix.mybatis.plugin.autofield.annotation.UpdatedBy;
import org.dromara.mendmix.spring.InstanceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoFieldFillHandler
implements PluginInterceptorHandler {
    protected static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    private static Map<String, Field[]> methodFieldMappings = new HashMap<String, Field[]>();
    private IDGenerator idGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDGenerator idGenerator() {
        if (this.idGenerator != null) {
            return this.idGenerator;
        }
        Class<AutoFieldFillHandler> clazz = AutoFieldFillHandler.class;
        synchronized (AutoFieldFillHandler.class) {
            this.idGenerator = (IDGenerator)InstanceFactory.getInstance(IDGenerator.class);
            if (this.idGenerator == null) {
                this.idGenerator = new DefaultIdGenerator();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.idGenerator;
        }
    }

    @Override
    public void start(MendmixMybatisInterceptor context) {
        List<MapperMetadata> entityInfos = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        String tenantColumn = MybatisConfigs.getTenantColumnName(context.getGroupName());
        for (MapperMetadata ei : entityInfos) {
            Field[] fields;
            String mapperPackageName = ei.getMapperClass().getName();
            Field[] createdFields = new Field[4];
            Field[] updatedFields = new Field[4];
            for (Field field : fields = FieldUtils.getAllFields(ei.getEntityClass())) {
                Optional<Map.Entry> optional;
                if (field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(GeneratedValue.class)) {
                    field.setAccessible(true);
                    createdFields[0] = field;
                    continue;
                }
                if (field.isAnnotationPresent(CreatedBy.class)) {
                    field.setAccessible(true);
                    createdFields[1] = field;
                    continue;
                }
                if (field.isAnnotationPresent(CreatedAt.class)) {
                    field.setAccessible(true);
                    createdFields[2] = field;
                    continue;
                }
                if (field.isAnnotationPresent(UpdatedBy.class)) {
                    field.setAccessible(true);
                    updatedFields[1] = field;
                    continue;
                }
                if (field.isAnnotationPresent(UpdatedAt.class)) {
                    field.setAccessible(true);
                    updatedFields[2] = field;
                    continue;
                }
                if (tenantColumn == null || MybatisConfigs.ignoreTenant(mapperPackageName) || !(optional = ei.getPropToColumnMappings().entrySet().stream().filter(e -> ((String)e.getValue()).equalsIgnoreCase(tenantColumn)).findFirst()).isPresent() || !field.getName().equals(optional.get().getKey())) continue;
                field.setAccessible(true);
                createdFields[3] = field;
            }
            String keyPrefix = ei.getMapperClass().getName() + ".";
            if (this.hasAnyValue(createdFields)) {
                methodFieldMappings.put(keyPrefix + CrudMethods.insert.name(), createdFields);
                methodFieldMappings.put(keyPrefix + CrudMethods.insertSelective.name(), createdFields);
                methodFieldMappings.put(keyPrefix + CrudMethods.insertList.name(), createdFields);
            }
            if (!this.hasAnyValue(updatedFields)) continue;
            methodFieldMappings.put(keyPrefix + CrudMethods.updateByPrimaryKey.name(), updatedFields);
            methodFieldMappings.put(keyPrefix + CrudMethods.updateByPrimaryKeySelective.name(), updatedFields);
            methodFieldMappings.put(keyPrefix + CrudMethods.updateByPrimaryKeyWithVersion.name(), updatedFields);
            methodFieldMappings.put(keyPrefix + CrudMethods.updateListByPrimaryKeys.name(), updatedFields);
            methodFieldMappings.put(keyPrefix + CrudMethods.updateListByPrimaryKeysSelective.name(), updatedFields);
        }
    }

    @Override
    public Object onInterceptor(OnceContextVal invocation) throws Throwable {
        if (invocation.getMappedStatement().getSqlCommandType() == SqlCommandType.SELECT || invocation.getMappedStatement().getSqlCommandType() == SqlCommandType.DELETE) {
            return null;
        }
        Object parameter = invocation.getParameter();
        boolean dynaFieldEnabled = ThreadLocalContext.exists((String)"__param_cxt_name");
        if (!dynaFieldEnabled && methodFieldMappings.isEmpty()) {
            return null;
        }
        MappedStatement mt = invocation.getMappedStatement();
        Field[] fields = methodFieldMappings.get(mt.getId());
        if (fields != null) {
            boolean updateAction;
            boolean updateListByPrimaryKeys = mt.getId().endsWith(CrudMethods.updateListByPrimaryKeys.name());
            boolean bl = updateAction = updateListByPrimaryKeys || SqlCommandType.UPDATE.equals((Object)mt.getSqlCommandType());
            if (updateListByPrimaryKeys || mt.getId().endsWith(CrudMethods.insertList.name()) || mt.getId().endsWith(CrudMethods.updateListByPrimaryKeysSelective.name())) {
                if (parameter instanceof Map) {
                    try {
                        List list = (List)((Map)parameter).get("arg0");
                        for (Object obj : list) {
                            this.setFieldValues(fields, obj, updateAction);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.setFieldValues(fields, parameter, updateAction);
            }
        }
        return null;
    }

    private void setFieldValues(Field[] fields, Object parameter, boolean updateAction) {
        String tmpVal;
        if (fields[0] != null && this.idGenerator() != null && this.isNullValue(parameter, fields[0])) {
            Serializable id = this.idGenerator.next();
            if (fields[0].getType() == Long.class) {
                id = Long.valueOf(Long.parseLong(id.toString()));
            }
            this.setFieldValue(parameter, fields[0], id);
        }
        if (fields[1] != null && (tmpVal = MybatisRuntimeContext.getCurrentUserId()) != null && (updateAction || this.isNullValue(parameter, fields[1]))) {
            this.setFieldValue(parameter, fields[1], tmpVal);
        }
        if (fields[2] != null && (updateAction || this.isNullValue(parameter, fields[2]))) {
            this.setFieldValue(parameter, fields[2], new Date());
        }
        if (fields[3] != null && (tmpVal = MybatisRuntimeContext.getCurrentTenant()) != null && (!MybatisRuntimeContext.isIgnoreTenantMode() || this.isNullValue(parameter, fields[3]))) {
            this.setFieldValue(parameter, fields[3], tmpVal);
        }
        this.setDynaFieldValues(parameter);
    }

    private boolean isNullValue(Object obj, Field field) {
        try {
            Object value = field.get(obj);
            return value == null || StringUtils.isBlank((CharSequence)value.toString());
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean hasAnyValue(Field[] fields) {
        for (Field field : fields) {
            if (field == null) continue;
            return true;
        }
        return false;
    }

    public void setFieldValue(Object target, Field field, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private void setDynaFieldValues(Object entity) {
        Map<String, String> dynaValueMap = this.tryGetDynaAttrValues(entity);
        boolean debugMode = CurrentRuntimeContext.isDebugMode();
        if (debugMode) {
            logger.info("{} dynaValueMap:{}", (Object)ExceptionFormatUtils.buildLogHeader((String)"DynaFormHandle", (Serializable)((Object)"debugMode")), dynaValueMap);
        }
        if (dynaValueMap != null) {
            dynaValueMap.forEach((k, v) -> {
                CachingFieldUtils.writeField((Object)entity, (String)k, (Object)v);
                if (debugMode) {
                    logger.info("{} write {} = {}", new Object[]{ExceptionFormatUtils.buildLogHeader((String)"DynaFormHandle", (Serializable)((Object)"debugMode")), k, v});
                }
            });
        }
    }

    private Map<String, String> tryGetDynaAttrValues(Object parameter) {
        String key;
        Map dynaValueMap;
        if (!(parameter instanceof BaseEntity)) {
            return null;
        }
        boolean debugMode = CurrentRuntimeContext.isDebugMode();
        Class<?> entityClass = parameter.getClass();
        if (!ThreadLocalContext.exists((String)"__param_cxt_name")) {
            return null;
        }
        Object id = CachingFieldUtils.readField((Object)parameter, (String)"id");
        if (id != null) {
            if (debugMode) {
                logger.info("{} id:{}", (Object)ExceptionFormatUtils.buildLogHeader((String)"DynaFormHandle", (Serializable)((Object)"debugMode")), id);
            }
            if ((dynaValueMap = (Map)ThreadLocalContext.get((String)(key = String.format("__attrval_cxt_name:%s:%s", entityClass.getSimpleName(), id)))) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("<framework-logging> mybatisAutoFieldHandle get_context_dynaValue -> key:{},values:{}", (Object)key, (Object)dynaValueMap);
                }
                ThreadLocalContext.remove((String[])new String[]{key});
                return dynaValueMap;
            }
        }
        String listCountKey = String.format("__dynaListCount_cxt_name:%s", entityClass.getSimpleName());
        Integer listCount = (Integer)ThreadLocalContext.get((String)listCountKey, (Object)0);
        for (int i = 0; i <= listCount; ++i) {
            key = String.format("__attrval_cxt_name:%s:%s", entityClass.getSimpleName(), i);
            dynaValueMap = (Map)ThreadLocalContext.get((String)key);
            if (dynaValueMap == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("<framework-logging> mybatisAutoFieldHandle get_context_dynaValue -> key:{},values:{}", (Object)key, (Object)dynaValueMap);
            }
            ThreadLocalContext.remove((String[])new String[]{key});
            return dynaValueMap;
        }
        return null;
    }

    @Override
    public void onFinished(OnceContextVal invocationVal, Object result) {
    }

    @Override
    public void close() {
    }

    @Override
    public int interceptorOrder() {
        return 1;
    }
}

