/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.cache;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.async.StandardThreadExecutor;
import org.dromara.mendmix.common.model.AuthUser;
import org.dromara.mendmix.common.util.CachingFieldUtils;
import org.dromara.mendmix.common.util.DigestUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.MybatisConfigs;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.core.BaseEntity;
import org.dromara.mendmix.mybatis.crud.CrudMethods;
import org.dromara.mendmix.mybatis.exception.MybatisHanlerInitException;
import org.dromara.mendmix.mybatis.kit.CacheKeyUtils;
import org.dromara.mendmix.mybatis.kit.MybatisMapperParser;
import org.dromara.mendmix.mybatis.kit.MybatisSqlRewriteUtils;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.dromara.mendmix.mybatis.plugin.cache.CacheProvider;
import org.dromara.mendmix.mybatis.plugin.cache.QueryCacheMethodMetadata;
import org.dromara.mendmix.mybatis.plugin.cache.UpdateByPkCacheMethodMetadata;
import org.dromara.mendmix.mybatis.plugin.cache.annotation.Cache;
import org.dromara.mendmix.mybatis.plugin.cache.annotation.CacheIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHandler
implements PluginInterceptorHandler {
    protected static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    public static final String CURRENT_USER_CONTEXT_NAME = "currentUser";
    private static final String BLOCK_ON_CONCURRENT_LOCK_RETURN = "_block_on_concurrentLock";
    public static final String NAME = "cache";
    public static final long IN_1MINS = 60L;
    public static final long IN_1HOUR = 3600L;
    public static long defaultCacheExpire = 0L;
    private static final String STR_PARAM = "param";
    public static final String GROUPKEY_SUFFIX = "~keys";
    private static final String ID_CACHEKEY_JOIN = ".id:";
    private boolean nullValueCache = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.cache.nullProtection");
    public static final String NULL_PLACEHOLDER = "~null";
    private static List<String> groupKeys = new ArrayList<String>();
    private static List<String> cacheEnableMappers = new ArrayList<String>();
    private static Map<String, Map<String, QueryCacheMethodMetadata>> queryCacheMethods = new HashMap<String, Map<String, QueryCacheMethodMetadata>>();
    private static Map<String, UpdateByPkCacheMethodMetadata> updatePkCacheMethods = new HashMap<String, UpdateByPkCacheMethodMetadata>();
    private static List<String> batchUpdateByPkCacheMethods = Arrays.asList("batchLogicDelete", "batchUpdateByPrimaryKeys");
    private static Map<String, List<String>> customUpdateCacheMapppings = new HashMap<String, List<String>>();
    protected static CacheProvider cacheProvider;
    private static String dataSourceGroupName;
    private DataSource dataSource;
    private ExecutorService cleanCacheExecutor;

    @Override
    public void start(MendmixMybatisInterceptor context) {
        this.cleanCacheExecutor = new ThreadPoolExecutor(2, 20, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2000), (ThreadFactory)new StandardThreadExecutor.StandardThreadFactory("cleanCacheExecutor"));
        dataSourceGroupName = context.getGroupName();
        this.dataSource = context.getDataSource();
        cacheProvider = new CacheProvider(dataSourceGroupName);
        defaultCacheExpire = Long.parseLong(MybatisConfigs.getProperty(context.getGroupName(), "mendmix-cloud.mybatis.cache.expireSeconds", "0"));
        List<MapperMetadata> entityInfos = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        Class<BaseEntity> baseEntityClass = BaseEntity.class;
        QueryCacheMethodMetadata methodCache = null;
        for (MapperMetadata ei : entityInfos) {
            if (ei.getMapperClass().isAnnotationPresent(CacheIgnore.class)) continue;
            if (!baseEntityClass.isAssignableFrom(ei.getEntityClass())) {
                logger.warn("[{}] not extends from [{}],ignore register auto cache!!!!", (Object)ei.getEntityClass().getName(), (Object)baseEntityClass.getName());
                continue;
            }
            Class<?> mapperClass = ei.getMapperClass();
            QueryCacheMethodMetadata queryByPKMethod = this.generateQueryByPKMethod(mapperClass, ei.getEntityClass());
            if (queryByPKMethod == null) continue;
            HashMap<String, QueryCacheMethodMetadata> tmpMap = new HashMap<String, QueryCacheMethodMetadata>();
            tmpMap.put(queryByPKMethod.methodName, queryByPKMethod);
            String keyPatternForPK = queryByPKMethod.keyPattern;
            for (MapperMetadata.MapperMethod method : ei.getMapperMethods().values()) {
                if (!method.getMethod().isAnnotationPresent(Cache.class) || tmpMap.containsKey(method.getFullName())) continue;
                methodCache = this.generateQueryMethodCacheByMethod(ei, method);
                tmpMap.put(method.getFullName(), methodCache);
                logger.info("<startup-logging>  \u89e3\u6790\u67e5\u8be2\u65b9\u6cd5{}\u81ea\u52a8\u7f13\u5b58\u914d\u7f6e ok,keyPattern:[{}]", (Object)methodCache.methodName, (Object)methodCache.keyPattern);
            }
            cacheEnableMappers.add(ei.getMapperClass().getName());
            logger.info("<startup-logging>  \u89e3\u6790\u67e5\u8be2\u65b9\u6cd5{}\u81ea\u52a8\u7f13\u5b58\u914d\u7f6e ok,keyPattern:[{}]", (Object)queryByPKMethod.methodName, (Object)queryByPKMethod.keyPattern);
            queryCacheMethods.put(mapperClass.getName(), tmpMap);
            this.generateUpdateByPkCacheMethod(mapperClass, ei.getEntityClass(), keyPatternForPK);
        }
        logger.info("<startup-logging>  customUpdateCacheMapppings:{}", customUpdateCacheMapppings);
    }

    @Override
    public Object onInterceptor(OnceContextVal invocationVal) throws Throwable {
        if (MybatisRuntimeContext.isIgnoreCache()) {
            return null;
        }
        if (invocationVal.getPageObject() != null) {
            return null;
        }
        MappedStatement mt = invocationVal.getMappedStatement();
        boolean getLock = false;
        String cacheKey = null;
        if (mt.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
            if (MybatisRuntimeContext.isTransactionalOn()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(">>auto_cache_process skipCache[isTransactionalOn] -> mapperId:{}", (Object)mt.getId());
                }
                return null;
            }
            QueryCacheMethodMetadata metadata = this.getQueryMethodCache(mt.getId());
            if (metadata == null) {
                return null;
            }
            invocationVal.setQueryCacheMetadata(metadata);
            cacheKey = CacheHandler.genarateQueryCacheKey(invocationVal, metadata.keyPattern, invocationVal.getParameter());
            invocationVal.setCacheKey(cacheKey);
            if (!metadata.concurrency) {
                String concurrentLockKey = "concurrent:" + cacheKey;
                invocationVal.setConcurrentLockKey(concurrentLockKey);
                getLock = cacheProvider.setnx(concurrentLockKey, "1", 30L);
                if (!getLock) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(">>auto_cache_process notGetConcurrentLock -> mapperId:{}", (Object)mt.getId());
                    }
                    return BLOCK_ON_CONCURRENT_LOCK_RETURN;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(">>auto_cache_process getConcurrentLock -> mapperId:{}", (Object)mt.getId());
                }
            }
            ArrayList<ArrayList<Object>> cacheObject = null;
            boolean nullPlaceholder = false;
            if (!metadata.isSecondQueryById()) {
                cacheObject = (ArrayList<ArrayList<Object>>)cacheProvider.get(cacheKey);
                boolean bl = nullPlaceholder = this.nullValueCache && NULL_PLACEHOLDER.equals(cacheObject);
                if (StringUtils.isNotBlank((CharSequence)metadata.refKey) && (nullPlaceholder || cacheObject == null)) {
                    cacheObject = cacheProvider.get(metadata.refKey);
                    boolean bl2 = nullPlaceholder = this.nullValueCache && NULL_PLACEHOLDER.equals(cacheObject);
                }
                if (nullPlaceholder) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(">>auto_cache_process hitCache -> mapperId:{},cacheKey:[{}]", (Object)mt.getId(), (Object)cacheKey);
                    }
                } else if (cacheObject != null && logger.isDebugEnabled()) {
                    logger.debug(">>auto_cache_process hitCache -> mapperId:{},cacheKey:[{}]", (Object)mt.getId(), (Object)cacheKey);
                }
            } else {
                String refCacheKey;
                String string = refCacheKey = this.nullValueCache ? (String)cacheProvider.get(cacheKey) : cacheProvider.getStr(cacheKey);
                if (refCacheKey != null) {
                    nullPlaceholder = this.nullValueCache && NULL_PLACEHOLDER.equals(refCacheKey);
                    if (nullPlaceholder) {
                        cacheObject = NULL_PLACEHOLDER;
                    } else {
                        cacheObject = cacheProvider.get(refCacheKey);
                        if (cacheObject != null && logger.isDebugEnabled()) {
                            logger.debug(">>auto_cache_process  hitRefCache -> mapperId:{},cacheKey:[{}],refCacheKey:[{}]", new Object[]{mt.getId(), cacheKey, refCacheKey});
                        }
                    }
                }
            }
            if (nullPlaceholder) {
                cacheObject = new ArrayList(0);
            } else if (cacheObject != null && !(cacheObject instanceof Collection)) {
                ArrayList tmpList = new ArrayList(1);
                tmpList.add(cacheObject);
                cacheObject = tmpList;
            }
            return cacheObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void onFinished(OnceContextVal invocationVal, Object result) {
        block45: {
            block48: {
                block49: {
                    block46: {
                        block47: {
                            block43: {
                                block44: {
                                    block41: {
                                        block42: {
                                            block39: {
                                                block40: {
                                                    block37: {
                                                        block38: {
                                                            block35: {
                                                                block36: {
                                                                    block33: {
                                                                        block34: {
                                                                            block31: {
                                                                                block32: {
                                                                                    try {
                                                                                        if (!MybatisRuntimeContext.isIgnoreCache()) break block31;
                                                                                        if (invocationVal.getConcurrentLockKey() == null) break block32;
                                                                                    }
                                                                                    catch (Throwable var13_18) {
                                                                                        if (invocationVal.getConcurrentLockKey() != null) {
                                                                                            CacheHandler.cacheProvider.remove(new String[]{invocationVal.getConcurrentLockKey()});
                                                                                        }
                                                                                        throw var13_18;
                                                                                    }
                                                                                    CacheHandler.cacheProvider.remove(new String[]{invocationVal.getConcurrentLockKey()});
                                                                                }
                                                                                return;
                                                                            }
                                                                            if (invocationVal.getPageObject() == null) break block33;
                                                                            if (invocationVal.getConcurrentLockKey() == null) break block34;
                                                                            CacheHandler.cacheProvider.remove(new String[]{invocationVal.getConcurrentLockKey()});
                                                                        }
                                                                        return;
                                                                    }
                                                                    if (!"_block_on_concurrentLock".equals(result)) break block35;
                                                                    if (invocationVal.getConcurrentLockKey() == null) break block36;
                                                                    CacheHandler.cacheProvider.remove(new String[]{invocationVal.getConcurrentLockKey()});
                                                                }
                                                                return;
                                                            }
                                                            mt = invocationVal.getMappedStatement();
                                                            metadata = null;
                                                            if (!mt.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) ** GOTO lbl85
                                                            if (result != null) break block37;
                                                            if (invocationVal.getConcurrentLockKey() == null) break block38;
                                                            CacheHandler.cacheProvider.remove(new String[]{invocationVal.getConcurrentLockKey()});
                                                        }
                                                        return;
                                                    }
                                                    metadata = invocationVal.getQueryMethodMetadata();
                                                    if (metadata != null) break block39;
                                                    if (invocationVal.getConcurrentLockKey() == null) break block40;
                                                    CacheHandler.cacheProvider.remove(new String[]{invocationVal.getConcurrentLockKey()});
                                                }
                                                return;
                                            }
                                            cacheKey = invocationVal.getCacheKey();
                                            if (!(result instanceof List)) ** GOTO lbl59
                                            list = (List)result;
                                            if (!list.isEmpty()) break block41;
                                            if (this.nullValueCache) {
                                                CacheHandler.cacheProvider.set(cacheKey, "~null", 60L);
                                            }
                                            if (invocationVal.getConcurrentLockKey() == null) break block42;
                                            CacheHandler.cacheProvider.remove(new String[]{invocationVal.getConcurrentLockKey()});
                                        }
                                        return;
                                    }
                                    result = metadata.collectionResult != false ? result : list.get(0);
                                    break block43;
lbl59:
                                    // 1 sources

                                    if (!this.nullValueCache || !"~null".equals(result)) break block43;
                                    CacheHandler.cacheProvider.set(cacheKey, "~null", 60L);
                                    if (invocationVal.getConcurrentLockKey() == null) break block44;
                                    CacheHandler.cacheProvider.remove(new String[]{invocationVal.getConcurrentLockKey()});
                                }
                                return;
                            }
                            if (!metadata.isSecondQueryById()) {
                                CacheHandler.cacheProvider.set(cacheKey, result, metadata.getExpire());
                                if (CacheHandler.logger.isDebugEnabled()) {
                                    CacheHandler.logger.debug(">>auto_cache_process addCache -> mapperId:{},cacheKey:{}", (Object)mt.getId(), (Object)cacheKey);
                                }
                                if (metadata.isPk) {
                                    this.cacheUniqueSelectRef(invocationVal, result, mt, cacheKey);
                                } else if (metadata.groupRalated) {
                                    CacheHandler.cacheProvider.putGroup(metadata.cacheGroupKey, cacheKey);
                                }
                            } else {
                                idCacheKey = CacheHandler.genarateQueryCacheKey(invocationVal, this.getQueryByPkMethodCache((String)mt.getId()).keyPattern, result);
                                if (idCacheKey != null && cacheKey != null) {
                                    if (!CacheHandler.cacheProvider.exists(idCacheKey)) {
                                        CacheHandler.cacheProvider.set(idCacheKey, result, metadata.getExpire());
                                    }
                                    this.cacheFieldRefKey(cacheKey, idCacheKey, metadata.getExpire());
                                    if (CacheHandler.logger.isDebugEnabled()) {
                                        CacheHandler.logger.debug(">>auto_cache_process addCache -> mapperId:{},idCacheKey:{},cacheKey:{}", new Object[]{mt.getId(), idCacheKey, cacheKey});
                                    }
                                }
                            }
                            break block45;
lbl85:
                            // 1 sources

                            mapperClassName = invocationVal.getMapperNameSpace();
                            if (CacheHandler.cacheEnableMappers.contains(mapperClassName) || CacheHandler.customUpdateCacheMapppings.containsKey(mt.getId())) break block46;
                            if (invocationVal.getConcurrentLockKey() == null) break block47;
                            CacheHandler.cacheProvider.remove(new String[]{invocationVal.getConcurrentLockKey()});
                        }
                        return;
                    }
                    if (result == null || (Integer)result != 0) break block48;
                    if (invocationVal.getConcurrentLockKey() == null) break block49;
                    CacheHandler.cacheProvider.remove(new String[]{invocationVal.getConcurrentLockKey()});
                }
                return;
            }
            if (!mt.getSqlCommandType().equals((Object)SqlCommandType.INSERT)) {
                if (CacheHandler.updatePkCacheMethods.containsKey(mt.getId())) {
                    updateMethodCache = CacheHandler.updatePkCacheMethods.get(mt.getId());
                    idCacheKey = CacheHandler.genarateQueryCacheKey(invocationVal, updateMethodCache.keyPattern, invocationVal.getParameter());
                    CacheHandler.cacheProvider.remove(new String[]{idCacheKey});
                    if (CacheHandler.logger.isDebugEnabled()) {
                        CacheHandler.logger.debug(">>auto_cache_process removeCache -> mapperId:{},cacheKey:{}", (Object)mt.getId(), (Object)idCacheKey);
                    }
                } else if (CacheHandler.batchUpdateByPkCacheMethods.contains(mt.getId().substring(mapperClassName.length() + 1))) {
                    idCacheKeys = this.buildBatchUpdateIdCacheKeys(mapperClassName, invocationVal.getParameter());
                    if (!idCacheKeys.isEmpty()) {
                        CacheHandler.cacheProvider.remove(idCacheKeys.toArray(new String[0]));
                    }
                    if (CacheHandler.logger.isDebugEnabled()) {
                        CacheHandler.logger.debug(">>auto_cache_process removeCache -> mapperId:{},cacheKeys:{}", (Object)mt.getId(), idCacheKeys);
                    }
                } else {
                    entityInfo = invocationVal.getEntityInfo();
                    parameter = invocationVal.getParameter();
                    boundSql = mt.getBoundSql(parameter);
                    orignSql = boundSql.getSql();
                    idColumn = entityInfo.getIdColumn();
                    sqlMetadata = MybatisSqlRewriteUtils.rewriteAsSelectPkField(orignSql, idColumn);
                    tenantId = MybatisRuntimeContext.getCurrentTenant();
                    this.cleanCacheExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (tenantId != null) {
                                CurrentRuntimeContext.setTenantId((String)tenantId);
                            }
                            CacheHandler.this.removeCacheByDyncQuery(entityInfo, boundSql, sqlMetadata);
                        }
                    });
                }
            }
            this.removeCacheByGroup(mt.getId(), mapperClassName);
            if (!CacheHandler.customUpdateCacheMapppings.containsKey(mt.getId())) break block45;
            this.removeCustomRelateCache(mt.getId());
        }
        if (invocationVal.getConcurrentLockKey() != null) {
            CacheHandler.cacheProvider.remove(new String[]{invocationVal.getConcurrentLockKey()});
        }
    }

    private void cacheUniqueSelectRef(OnceContextVal invocationVal, Object object, MappedStatement mt, String cacheKey) {
        Collection<QueryCacheMethodMetadata> mcs = queryCacheMethods.get(mt.getId().substring(0, mt.getId().lastIndexOf("."))).values();
        block2: for (QueryCacheMethodMetadata methodCache : mcs) {
            if (!methodCache.isSecondQueryById()) continue;
            try {
                Object[] cacheFieldValues = new Object[methodCache.fieldNames.length];
                for (int i = 0; i < cacheFieldValues.length; ++i) {
                    if (methodCache.fieldNames[i] == null) break block2;
                    cacheFieldValues[i] = CachingFieldUtils.readField((Object)object, (String)methodCache.fieldNames[i]);
                    if (cacheFieldValues[i] == null) continue block2;
                }
                String fieldCacheKey = CacheHandler.genarateQueryCacheKey(invocationVal, methodCache.keyPattern, cacheFieldValues);
                this.cacheFieldRefKey(fieldCacheKey, cacheKey, methodCache.getExpire());
                if (!logger.isDebugEnabled()) continue;
                logger.debug(">>auto_cache_process addRefCache -> mapperId:{},cacheKey:{},refkey:{}", new Object[]{mt.getId(), fieldCacheKey, cacheKey});
            }
            catch (Exception e) {
                logger.warn("cacheUniqueSelectRef:" + cacheKey, (Throwable)e);
            }
        }
    }

    private void cacheFieldRefKey(String fieldCacheKey, String idCacheKey, long expired) {
        if (this.nullValueCache) {
            cacheProvider.set(fieldCacheKey, idCacheKey, expired);
        } else {
            cacheProvider.setStr(fieldCacheKey, idCacheKey, expired);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCacheByDyncQuery(MapperMetadata entityInfo, BoundSql boundSql, MybatisSqlRewriteUtils.SqlMetadata sqlMetadata) {
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            MybatisSqlRewriteUtils.parseDyncQueryParameters(boundSql, sqlMetadata);
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(sqlMetadata.getSql());
            List<Object> parameters = sqlMetadata.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                statement.setObject(i + 1, parameters.get(i));
            }
            rs = statement.executeQuery();
            ArrayList<String> ids = new ArrayList<String>();
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
            if (ids != null && !ids.isEmpty()) {
                List<String> idCacheKeys = ids.stream().map(id -> entityInfo.getEntityClass().getSimpleName() + ID_CACHEKEY_JOIN + id.toString()).collect(Collectors.toList());
                cacheProvider.remove(idCacheKeys.toArray(new String[0]));
                if (logger.isDebugEnabled()) {
                    logger.debug("remove cacheKeys:{}", idCacheKeys);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String groupName = entityInfo.getEntityClass().getSimpleName();
            cacheProvider.clearGroup(groupName, new String[0]);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    private void removeCacheByGroup(final String msId, String mapperClassName) {
        MapperMetadata entityInfo = MybatisMapperParser.getMapperMetadata(mapperClassName);
        if (entityInfo == null) {
            return;
        }
        final String groupName = entityInfo.getEntityClass().getSimpleName();
        this.cleanCacheExecutor.execute(new Runnable(){

            @Override
            public void run() {
                cacheProvider.clearGroup(groupName, new String[0]);
                if (logger.isDebugEnabled()) {
                    logger.debug(">>auto_cache_process removeGroupCache -> mapperId:{},groupName:{}", (Object)msId, (Object)groupName);
                }
            }
        });
    }

    private void removeCustomRelateCache(String updateId) {
        final List<String> queryMethods = customUpdateCacheMapppings.get(updateId);
        if (queryMethods == null || queryMethods.isEmpty()) {
            return;
        }
        this.cleanCacheExecutor.execute(new Runnable(){

            @Override
            public void run() {
                for (String method : queryMethods) {
                    QueryCacheMethodMetadata metadata = CacheHandler.this.getQueryMethodCache(method);
                    String prefix = StringUtils.splitByWholeSeparator((String)metadata.keyPattern, (String)"%s")[0];
                    if (logger.isDebugEnabled()) {
                        logger.debug(">>auto_cache_process removeCustomRelateCache -> cacheGroupKey:{},keyPrefix:{}", (Object)metadata.cacheGroupKey, (Object)prefix);
                    }
                    cacheProvider.clearGroup(metadata.cacheGroupKey, prefix);
                }
            }
        });
    }

    private List<String> buildBatchUpdateIdCacheKeys(String mapperClassName, Object parameter) {
        MapperMetadata entityInfo = MybatisMapperParser.getMapperMetadata(mapperClassName);
        Map map = (Map)parameter;
        List ids = map.containsKey("arg0") ? (List)map.get("arg0") : (List)map.get("param1");
        ArrayList<String> keys = new ArrayList<String>(ids.size());
        StringBuilder keyBuilder = new StringBuilder(entityInfo.getEntityClass().getSimpleName()).append(ID_CACHEKEY_JOIN);
        int prefixLen = keyBuilder.length();
        for (Object id : ids) {
            keyBuilder.append(id);
            keys.add(keyBuilder.toString());
            keyBuilder.setLength(prefixLen);
        }
        return keys;
    }

    public static String genarateQueryCacheKey(OnceContextVal invocationVal, String keyPattern, Object param) {
        AuthUser currentUser;
        String text;
        try {
            Object[] args;
            if (param instanceof Map) {
                Map map = (Map)param;
                if (map.containsKey("param1")) {
                    args = new String[map.size() / 2];
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = CacheKeyUtils.objcetToString(map.get(STR_PARAM + (i + 1)));
                    }
                } else {
                    args = new String[]{CacheKeyUtils.objcetToString(map)};
                }
            } else {
                Serializable id;
                args = param instanceof BaseEntity ? ((id = ((BaseEntity)param).getId()) != null && !"0".equals(id.toString()) ? new String[]{((BaseEntity)param).getId().toString()} : new String[]{CacheKeyUtils.objcetToString(param)}) : (param instanceof Object[] ? (Object[])param : (param == null ? new Object[]{} : new String[]{CacheKeyUtils.objcetToString(param)}));
            }
            text = StringUtils.join((Object[])args, (String)"-");
        }
        catch (Exception e) {
            text = JsonUtils.toJson((Object)param);
            e.printStackTrace();
        }
        if (text.length() > 64) {
            text = DigestUtils.md5((Object)text);
        }
        String key = String.format(keyPattern, text);
        QueryCacheMethodMetadata methodMetadata = invocationVal.getQueryMethodMetadata();
        if (methodMetadata == null || methodMetadata.isPk || methodMetadata.uniqueIndex) {
            return key;
        }
        StringBuilder sb = new StringBuilder(key);
        String tenantId = CurrentRuntimeContext.getTenantId();
        if (tenantId != null) {
            sb.append("@").append(tenantId);
        }
        if (invocationVal.isUsingDataPermission() && (currentUser = CurrentRuntimeContext.getCurrentUser()) != null) {
            sb.append("@").append(currentUser.getId());
        }
        return sb.toString();
    }

    private QueryCacheMethodMetadata getQueryMethodCache(String mtId) {
        String key1 = mtId.substring(0, mtId.lastIndexOf("."));
        if (queryCacheMethods.containsKey(key1)) {
            return queryCacheMethods.get(key1).get(mtId);
        }
        return null;
    }

    private QueryCacheMethodMetadata getQueryByPkMethodCache(String mtId) {
        if (queryCacheMethods.containsKey(mtId = mtId.substring(0, mtId.lastIndexOf(".")))) {
            return queryCacheMethods.get(mtId).get(mtId + "." + CrudMethods.selectByPrimaryKey.name());
        }
        return null;
    }

    private QueryCacheMethodMetadata generateQueryByPKMethod(Class<?> mapperClass, Class<?> entityClass) {
        Field[] fields;
        QueryCacheMethodMetadata methodCache = null;
        for (Field field : fields = FieldUtils.getAllFields(entityClass)) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            methodCache = new QueryCacheMethodMetadata();
            methodCache.isPk = true;
            methodCache.collectionResult = false;
            methodCache.keyPattern = entityClass.getSimpleName() + ".id:%s";
            methodCache.methodName = mapperClass.getName() + "." + CrudMethods.selectByPrimaryKey.name();
            methodCache.expire = defaultCacheExpire;
            methodCache.cacheGroupKey = entityClass.getSimpleName() + GROUPKEY_SUFFIX;
            break;
        }
        groupKeys.add(methodCache.cacheGroupKey);
        return methodCache;
    }

    private void generateUpdateByPkCacheMethod(Class<?> mapperClass, Class<?> entityClass, String keyPatternForPK) {
        String methodName = null;
        methodName = mapperClass.getName() + "." + CrudMethods.insert.name();
        updatePkCacheMethods.put(methodName, new UpdateByPkCacheMethodMetadata(methodName, keyPatternForPK));
        methodName = mapperClass.getName() + "." + CrudMethods.insertSelective.name();
        updatePkCacheMethods.put(methodName, new UpdateByPkCacheMethodMetadata(methodName, keyPatternForPK));
        methodName = mapperClass.getName() + "." + CrudMethods.updateByPrimaryKey.name();
        updatePkCacheMethods.put(methodName, new UpdateByPkCacheMethodMetadata(methodName, keyPatternForPK));
        methodName = mapperClass.getName() + "." + CrudMethods.updateByPrimaryKeySelective.name();
        updatePkCacheMethods.put(methodName, new UpdateByPkCacheMethodMetadata(methodName, keyPatternForPK));
        methodName = mapperClass.getName() + "." + CrudMethods.deleteByPrimaryKey.name();
        updatePkCacheMethods.put(methodName, new UpdateByPkCacheMethodMetadata(methodName, keyPatternForPK));
    }

    private QueryCacheMethodMetadata generateQueryMethodCacheByMethod(MapperMetadata entityInfo, MapperMetadata.MapperMethod mapperMethod) {
        Method method = mapperMethod.getMethod();
        Cache cacheAnnotation = method.getAnnotation(Cache.class);
        String[] evictOnMethods = cacheAnnotation.evictOnMethods();
        Class<?> mapperClass = entityInfo.getMapperClass();
        Class<?> entityClass = entityInfo.getEntityClass();
        QueryCacheMethodMetadata methodCache = new QueryCacheMethodMetadata();
        methodCache.methodName = mapperClass.getName() + "." + method.getName();
        methodCache.concurrency = cacheAnnotation.concurrency();
        methodCache.uniqueIndex = cacheAnnotation.uniqueIndex();
        methodCache.cacheGroupKey = entityClass.getSimpleName() + GROUPKEY_SUFFIX;
        if (cacheAnnotation.userScope()) {
            methodCache.contextParam = CURRENT_USER_CONTEXT_NAME;
        } else if (cacheAnnotation.scopeContext().length > 0) {
            methodCache.contextParam = cacheAnnotation.scopeContext()[0];
        }
        if (cacheAnnotation.refKey().length > 0) {
            methodCache.refKey = cacheAnnotation.refKey()[0];
        }
        if (methodCache.contextParam != null && evictOnMethods.length == 0) {
            evictOnMethods = new String[]{"*"};
        }
        boolean bl = methodCache.checkExpired = evictOnMethods.length > 0;
        if (cacheAnnotation.expire() > 0L) {
            methodCache.expire = cacheAnnotation.expire();
        } else if (cacheAnnotation.userScope()) {
            long l = methodCache.expire = 600L < defaultCacheExpire ? 600L : defaultCacheExpire;
        }
        if (methodCache.uniqueIndex && method.getReturnType() != entityClass) {
            throw new MybatisHanlerInitException("@Cache with[uniqueIndex = true] but ReturnType not Match [" + entityClass.getName() + "]");
        }
        methodCache.collectionResult = method.getReturnType() == List.class || method.getReturnType() == Set.class;
        methodCache.groupRalated = methodCache.collectionResult || !methodCache.uniqueIndex;
        methodCache.fieldNames = new String[method.getParameterTypes().length];
        Annotation[][] annotations = method.getParameterAnnotations();
        boolean uniqueQuery = method.getReturnType().isAnnotationPresent(Table.class);
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] aa = annotations[i];
            if (aa.length <= 0) continue;
            String fieldName = null;
            for (Annotation annotation : aa) {
                if (!annotation.toString().contains(Param.class.getName())) continue;
                fieldName = ((Param)annotation).value();
                break;
            }
            if (!uniqueQuery || !entityInfo.getPropToColumnMappings().containsKey(fieldName)) continue;
            methodCache.fieldNames[i] = fieldName;
        }
        methodCache.keyPattern = entityClass.getSimpleName() + "." + method.getName() + ":%s";
        if (uniqueQuery) {
            for (String name : methodCache.fieldNames) {
                if (!StringUtils.isBlank((CharSequence)name)) continue;
                methodCache.fieldNames = null;
                break;
            }
        }
        this.buildEvictOnMethods(mapperClass.getName(), mapperMethod, evictOnMethods);
        return methodCache;
    }

    private void buildEvictOnMethods(String mapperClassName, MapperMetadata.MapperMethod method, String[] evictOnMethods) {
        if (evictOnMethods == null || evictOnMethods.length == 0) {
            return;
        }
        String targetMethodFullNamePrefix = mapperClassName.substring(0, mapperClassName.lastIndexOf(".") + 1);
        String targetMapperClassName = null;
        for (String methodName : evictOnMethods) {
            if ("*".equals(methodName)) {
                methodName = mapperClassName + ".*";
            } else if (!methodName.contains(".")) {
                methodName = mapperClassName + "." + methodName;
            }
            if (!methodName.startsWith(targetMethodFullNamePrefix)) {
                methodName = targetMethodFullNamePrefix + methodName;
            }
            targetMapperClassName = methodName.substring(0, methodName.lastIndexOf("."));
            if (!methodName.endsWith("*")) {
                this.addCacheCheckRelations(methodName, method.getFullName());
                continue;
            }
            MapperMetadata methodEntityInfo = MybatisMapperParser.getMapperMetadata(targetMapperClassName);
            if (methodEntityInfo == null) continue;
            for (MapperMetadata.MapperMethod mm : methodEntityInfo.getMapperMethods().values()) {
                if (mm.getSqlType() == SqlCommandType.SELECT || !mm.getFullName().contains(methodName.replace("*", ""))) continue;
                this.addCacheCheckRelations(mm.getFullName(), method.getFullName());
            }
        }
    }

    private void addCacheCheckRelations(String updateMethodName, String queryMethodName) {
        List<String> list = customUpdateCacheMapppings.get(updateMethodName);
        if (list == null) {
            list = new ArrayList<String>();
            customUpdateCacheMapppings.put(updateMethodName, list);
        }
        list.add(queryMethodName);
    }

    @Override
    public void close() {
        this.cleanCacheExecutor.shutdown();
    }

    @Override
    public int interceptorOrder() {
        return 1;
    }
}

