/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.cache;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.dromara.mendmix.cache.CacheUtils;
import org.dromara.mendmix.cache.RedisTemplateGroups;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class CacheProvider {
    protected static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    protected String groupName;
    protected int batchSize = 100;

    public CacheProvider(String groupName) {
        this.groupName = groupName;
    }

    public <T> T get(String key) {
        return (T)CacheUtils.get((String)key);
    }

    public String getStr(String key) {
        return CacheUtils.getStr((String)key);
    }

    public void set(String key, Object value, long expireSeconds) {
        CacheUtils.set((String)key, (Object)value, (long)expireSeconds);
    }

    public void setStr(String key, String value, long expireSeconds) {
        CacheUtils.setStr((String)key, (String)value, (long)expireSeconds);
    }

    public void remove(String ... keys) {
        CacheUtils.remove((String[])keys);
    }

    public boolean exists(String key) {
        return CacheUtils.exists((String)key);
    }

    public void setExpire(String key, long expireSeconds) {
        CacheUtils.setExpire((String)key, (long)expireSeconds);
    }

    public List<String> getListItems(String key, int start, int end) {
        return CacheUtils.getStrListItems((String)key, (int)start, (int)end);
    }

    public long getListSize(String key) {
        return CacheUtils.getListSize((String)key);
    }

    public boolean setnx(String key, String value, long expireSeconds) {
        return CacheUtils.setIfAbsent((String)key, (Object)value, (long)expireSeconds, (TimeUnit)TimeUnit.SECONDS);
    }

    public void putGroup(String cacheGroupKey, String key) {
        CacheUtils.addStrItemToList((String)cacheGroupKey, (String)key);
    }

    public void clearGroup(String groupName, String ... prefixs) {
        int toIndex;
        List<String> keys;
        String cacheGroupKey = groupName.endsWith("~keys") ? groupName : groupName + "~keys";
        int keyCount = (int)this.getListSize(cacheGroupKey);
        if (keyCount <= 0) {
            return;
        }
        boolean withPrefixs = prefixs != null && prefixs.length > 0 && prefixs[0] != null;
        for (int i = 0; i <= keyCount && !(keys = this.getListItems(cacheGroupKey, i, toIndex = i + this.batchSize > keyCount ? keyCount : i + this.batchSize)).isEmpty(); i += this.batchSize) {
            if (withPrefixs) {
                keys = keys.stream().filter(key -> {
                    for (String prefix : prefixs) {
                        if (!key.contains(prefix)) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
            }
            if (keys.isEmpty()) continue;
            this.remove(keys.toArray(new String[0]));
            StringRedisTemplate redisTemplate = RedisTemplateGroups.getDefaultStringRedisTemplate();
            for (String key2 : keys) {
                redisTemplate.opsForList().remove((Object)cacheGroupKey, 1L, (Object)key2);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug(">> auto_cache_process clearGroupKey finish -> group:{},keys:{}", (Object)groupName, (Object)Arrays.toString(keys.toArray()));
        }
    }
}

