/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.cache;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.dromara.mendmix.cache.CacheUtils;
import org.dromara.mendmix.mybatis.core.BaseEntity;
import org.dromara.mendmix.mybatis.plugin.cache.CacheHandler;

public class EntityCacheHelper {
    public static <T extends BaseEntity> void addCache(T bean, int expireSeconds) {
        String key = EntityCacheHelper.buildCacheKey(bean.getClass(), bean.getId());
        CacheUtils.set((String)key, bean, (long)expireSeconds);
    }

    public static <T> T queryTryCache(Class<? extends BaseEntity> entityClass, String key, Callable<T> dataCaller) {
        return EntityCacheHelper.queryTryCache(entityClass, key, CacheHandler.defaultCacheExpire, dataCaller);
    }

    public static <T> T queryTryCache(Class<? extends BaseEntity> entityClass, String key, long expireSeconds, Callable<T> dataCaller) {
        if (CacheHandler.cacheProvider == null) {
            try {
                return dataCaller.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String entityClassName = entityClass.getSimpleName();
        key = entityClassName + "." + key;
        Object result = CacheHandler.cacheProvider.get(key);
        if (result == null) {
            try {
                result = dataCaller.call();
                if (result != null) {
                    CacheHandler.cacheProvider.set(key, result, expireSeconds);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static void removeCache(Class<? extends BaseEntity> entityClass, String key) {
        if (CacheHandler.cacheProvider == null) {
            return;
        }
        String entityClassName = entityClass.getSimpleName();
        key = entityClassName + "." + key;
        CacheHandler.cacheProvider.remove(key);
    }

    public static <T extends BaseEntity> void removeCache(T bean) {
        if (CacheHandler.cacheProvider == null) {
            return;
        }
        String key = EntityCacheHelper.buildCacheKey(bean.getClass(), bean.getId());
        CacheHandler.cacheProvider.remove(key);
    }

    public static void removeCache(Class<? extends BaseEntity> entityClass) {
        if (CacheHandler.cacheProvider == null) {
            return;
        }
        String entityClassName = entityClass.getSimpleName();
    }

    public static String buildCacheKey(Class<?> entityClass, Serializable id) {
        return entityClass.getSimpleName() + ".id:" + id;
    }
}

