/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.datalog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.async.StandardThreadExecutor;
import org.dromara.mendmix.common.constants.DataChangeType;
import org.dromara.mendmix.common.model.ModifiedObject;
import org.dromara.mendmix.common.util.ExceptionFormatUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.core.BaseEntity;
import org.dromara.mendmix.mybatis.core.BaseMapper;
import org.dromara.mendmix.mybatis.crud.CrudMethods;
import org.dromara.mendmix.mybatis.kit.MapperBeanHolder;
import org.dromara.mendmix.mybatis.kit.MybatisMapperParser;
import org.dromara.mendmix.mybatis.kit.MybatisSqlRewriteUtils;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.OnceInterceptorStrategy;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.dromara.mendmix.mybatis.plugin.datalog.DataChangeItem;
import org.dromara.mendmix.mybatis.plugin.datalog.DataChangeLogPublisher;
import org.dromara.mendmix.mybatis.plugin.datalog.DataSnapshot;
import org.dromara.mendmix.mybatis.plugin.datalog.annotation.DataChangeLogeable;
import org.dromara.mendmix.spring.InstanceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChangeLogHandler
implements PluginInterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    private static final String CTX_BEFORE_CHANGE_ENTITIES = "_ctx_before_change_entities";
    private DataSource dataSource;
    private static PriorityBlockingQueue<ModifiedObject> taskQueue;
    private static ScheduledExecutorService syncEventHandler;
    private DataChangeLogPublisher dataChangeLogPublisher;
    private int delayMillis = ResourceUtils.getInt((String)"mendmix-cloud.mybatis.changelog.delayMillis", (int)5000);
    private boolean enabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataChangeLogPublisher getDataChangeLogPublisher() {
        if (this.dataChangeLogPublisher != null) {
            return this.dataChangeLogPublisher;
        }
        Class<DataChangeLogHandler> clazz = DataChangeLogHandler.class;
        synchronized (DataChangeLogHandler.class) {
            if (this.dataChangeLogPublisher != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.dataChangeLogPublisher;
            }
            this.dataChangeLogPublisher = (DataChangeLogPublisher)InstanceFactory.getInstance(DataChangeLogPublisher.class);
            if (this.dataChangeLogPublisher == null) {
                this.dataChangeLogPublisher = new DataChangeLogPublisher(){

                    @Override
                    public boolean publish(DataChangeItem item) {
                        logger.warn("DataChangeLogPublisher NOT FOUND,Ignore dataChangeLog:\n - {}", (Object)JsonUtils.toJson((Object)item));
                        return true;
                    }
                };
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.dataChangeLogPublisher;
        }
    }

    @Override
    public void start(MendmixMybatisInterceptor context) {
        this.dataSource = context.getDataSource();
        List<MapperMetadata> list = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        this.enabled = list.stream().anyMatch(o -> o.getEntityClass().isAnnotationPresent(DataChangeLogeable.class));
        if (!this.enabled) {
            return;
        }
        if (taskQueue == null) {
            taskQueue = new PriorityBlockingQueue(5000);
            syncEventHandler = Executors.newScheduledThreadPool(1, (ThreadFactory)new StandardThreadExecutor.StandardThreadFactory("dataChangeLogEventHandler"));
            syncEventHandler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (taskQueue.isEmpty()) {
                        return;
                    }
                    ModifiedObject object = (ModifiedObject)taskQueue.poll();
                    if (object == null) {
                        return;
                    }
                    if (System.currentTimeMillis() - object.getLastModifiedTime() < (long)DataChangeLogHandler.this.delayMillis) {
                        taskQueue.add(object);
                    } else {
                        DataChangeLogHandler.this.handleDataChange((DataSnapshot)object.getObject());
                    }
                }
            }, 1000L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public Object onInterceptor(OnceContextVal invocation) throws Throwable {
        if (!this.enabled || MybatisRuntimeContext.isIgnoreLoggingDataChange()) {
            return null;
        }
        MappedStatement mt = invocation.getMappedStatement();
        SqlCommandType sqlType = mt.getSqlCommandType();
        if (SqlCommandType.SELECT.equals((Object)sqlType)) {
            return null;
        }
        try {
            if (!invocation.getEntityInfo().getEntityClass().isAnnotationPresent(DataChangeLogeable.class)) {
                return null;
            }
            Object parameter = invocation.getParameter();
            List<Object> ids = null;
            if (mt.getId().endsWith(CrudMethods.deleteByPrimaryKey.name())) {
                ids = Arrays.asList(parameter);
            } else if (mt.getId().endsWith(CrudMethods.deleteByPrimaryKeys.name()) || mt.getId().endsWith(CrudMethods.batchLogicDelete.name()) || mt.getId().endsWith(CrudMethods.batchUpdateByPrimaryKeys.name())) {
                ids = (List<Object>)parameter;
            } else if (mt.getId().endsWith(CrudMethods.updateByPrimaryKey.name()) || mt.getId().endsWith(CrudMethods.updateByPrimaryKeySelective.name()) || mt.getId().endsWith(CrudMethods.updateByPrimaryKeyWithVersion.name())) {
                ids = Arrays.asList(((BaseEntity)parameter).getId());
            } else if (mt.getId().endsWith(CrudMethods.updateListByPrimaryKeys.name()) || mt.getId().endsWith(CrudMethods.updateListByPrimaryKeysSelective.name())) {
                List entities = (List)((Map)parameter).get("arg0");
                ids = new ArrayList<Object>(entities.size());
                for (BaseEntity entity : entities) {
                    ids.add(entity.getId());
                }
            } else if (!SqlCommandType.INSERT.equals((Object)sqlType)) {
                if (!invocation.getEntityInfo().getEntityClass().isAnnotationPresent(DataChangeLogeable.class)) {
                    return null;
                }
                ids = MybatisSqlRewriteUtils.dynaQueryConditionToIdList(this.dataSource, invocation);
            }
            List beforeEntities = null;
            if (mt.getId().endsWith(CrudMethods.insert.name()) || mt.getId().endsWith(CrudMethods.insertSelective.name())) {
                beforeEntities = Arrays.asList((BaseEntity)parameter);
            } else if (mt.getId().endsWith(CrudMethods.insertList.name())) {
                beforeEntities = (List)((Map)parameter).get("arg0");
            } else if (ids != null && !ids.isEmpty() && !SqlCommandType.DELETE.equals((Object)sqlType)) {
                BaseMapper baseMapper = MapperBeanHolder.getMappeBean(invocation.getMapperNameSpace());
                List<Object> _ids = ids;
                beforeEntities = OnceInterceptorStrategy.apply().ignoreRwRoute().ignoreTenant().ignoreSoftDeleteConditon().ignoreDataPermission().exec(() -> baseMapper.selectByPrimaryKeys(_ids));
            }
            if (beforeEntities != null || ids != null) {
                String mapperName = invocation.getMapperNameSpace();
                DataSnapshot snapshot = new DataSnapshot(mt.getId(), mapperName, ids, beforeEntities);
                ThreadLocalContext.set((String)CTX_BEFORE_CHANGE_ENTITIES, (Object)snapshot);
                if (logger.isDebugEnabled()) {
                    logger.debug(">>\u751f\u6210\u53d8\u66f4\u524d\u5feb\u7167\u4fe1\u606f:{}", (Object)snapshot);
                }
            }
        }
        catch (Exception e) {
            logger.error(">>\u751f\u6210\u53d8\u66f4\u524d\u5feb\u7167\u9519\u8bef<build_before_snapshot_error> -> mapper:{},error:{}", (Object)mt.getId(), (Object)ExceptionFormatUtils.buildExceptionMessages((Throwable)e));
        }
        return null;
    }

    @Override
    public void onFinished(OnceContextVal invocation, Object result) {
        if (!this.enabled || MybatisRuntimeContext.isIgnoreLoggingDataChange()) {
            return;
        }
        MappedStatement mt = invocation.getMappedStatement();
        if (SqlCommandType.SELECT.equals((Object)mt.getSqlCommandType())) {
            return;
        }
        if (!ThreadLocalContext.exists((String)CTX_BEFORE_CHANGE_ENTITIES)) {
            return;
        }
        DataSnapshot snapshot = (DataSnapshot)ThreadLocalContext.getAndRemove((String)CTX_BEFORE_CHANGE_ENTITIES);
        if (!mt.getId().equals(snapshot.sourceMethod)) {
            return;
        }
        taskQueue.add(new ModifiedObject((Object)snapshot));
    }

    private void handleDataChange(DataSnapshot snapshot) {
        MapperMetadata entityInfo = MybatisMapperParser.getMapperMetadata(snapshot.mapperName);
        int changeItemNums = snapshot.ids == null ? snapshot.entities.size() : snapshot.ids.size();
        ArrayList<DataChangeItem> changeItems = new ArrayList<DataChangeItem>(changeItemNums);
        Serializable id = null;
        BaseEntity oldValue = null;
        String pubEntityName = this.getEntityName(entityInfo.getEntityClass());
        for (int i = 0; i < changeItemNums; ++i) {
            id = snapshot.ids == null ? null : (Serializable)snapshot.ids.get(i);
            BaseEntity baseEntity = oldValue = snapshot.entities == null ? null : snapshot.entities.get(i);
            if (id == null && oldValue != null) {
                id = oldValue.getId();
            }
            DataChangeItem changeItem = new DataChangeItem(pubEntityName, id.toString(), snapshot.changeType, oldValue);
            if (snapshot.changeType == DataChangeType.update) {
                BaseMapper baseMapper = MapperBeanHolder.getMappeBean(snapshot.mapperName);
                Serializable _id = id;
                BaseEntity newValue = OnceInterceptorStrategy.apply().ignoreRwRoute().ignoreTenant().ignoreSoftDeleteConditon().ignoreDataPermission().exec(() -> baseMapper.selectByPrimaryKey(_id));
                if (newValue == null) continue;
                changeItem.updateNewValue(newValue);
            }
            changeItems.add(changeItem);
        }
        for (DataChangeItem item : changeItems) {
            if (DataChangeType.update == item.getChangeType() && (item.getChangeFields() == null || item.getChangeFields().isEmpty())) continue;
            this.getDataChangeLogPublisher().publish(item);
            if (!logger.isDebugEnabled()) continue;
            logger.debug(">>\u5b8c\u6210\u53d1\u5e03\u53d8\u66f4\u4e8b\u4ef6 ->changeType:{},id:{}", (Object)item.getChangeType(), (Object)item.getId());
        }
    }

    private String getEntityName(Class<?> entityClass) {
        DataChangeLogeable annotation = entityClass.getAnnotation(DataChangeLogeable.class);
        if (annotation == null) {
            return null;
        }
        String[] aliasName = annotation.entityAliasName();
        String entityName = aliasName.length == 1 ? aliasName[0] : entityClass.getSimpleName();
        return entityName;
    }

    @Override
    public int interceptorOrder() {
        return 9;
    }

    @Override
    public boolean compatibleSqlRewrite() {
        return true;
    }

    @Override
    public void close() {
        if (syncEventHandler != null) {
            syncEventHandler.shutdown();
        }
    }
}

