/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.datalog;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.constants.DataChangeType;
import org.dromara.mendmix.common.guid.GUID;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.mybatis.core.BaseEntity;

public class DataSnapshot {
    String changeId = GUID.uuid();
    String sourceMethod;
    String mapperName;
    List<Object> ids;
    List<? extends BaseEntity> entities;
    DataChangeType changeType;

    public DataSnapshot(String sourceMethod, String mapperName, List<Object> ids, List<? extends BaseEntity> entities) {
        this.sourceMethod = sourceMethod;
        this.mapperName = mapperName;
        this.ids = ids;
        this.entities = entities;
        this.changeType = ids == null ? DataChangeType.add : (entities == null ? DataChangeType.delete : DataChangeType.update);
    }

    public String buildSortEventContent() {
        List<Object> ids = this.ids;
        if (ids == null && this.entities != null) {
            ids = this.entities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        return this.changeType.name() + ":" + StringUtils.join((Object[])new List[]{ids});
    }

    public String toString() {
        return ">>EntityListWrapper" + "\n - mapper:" + this.sourceMethod + "\n - id:" + (this.ids == null ? null : JsonUtils.toJson(this.ids));
    }
}

