/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.deletebackup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.persistence.Table;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.async.StandardThreadExecutor;
import org.dromara.mendmix.common.util.CachingFieldUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.core.BaseEntity;
import org.dromara.mendmix.mybatis.core.BaseMapper;
import org.dromara.mendmix.mybatis.crud.CrudMethods;
import org.dromara.mendmix.mybatis.kit.MapperBeanHolder;
import org.dromara.mendmix.mybatis.kit.MybatisMapperParser;
import org.dromara.mendmix.mybatis.kit.MybatisSqlRewriteUtils;
import org.dromara.mendmix.mybatis.metadata.ColumnMetadata;
import org.dromara.mendmix.mybatis.metadata.EntityMetadata;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.dromara.mendmix.mybatis.metadata.MetadataHelper;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.OnceInterceptorStrategy;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.dromara.mendmix.mybatis.plugin.deletebackup.annotation.DeleteBackup;
import org.dromara.mendmix.spring.InstanceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class DeleteBackupHandler
implements PluginInterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    private static final String CTX_DELETED_ENTITIES = "__ctx_deleted_entities_";
    private Map<String, String> backupTableNameMapping = new HashMap<String, String>();
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private boolean asyncMode;
    private LinkedBlockingQueue<UpdateTask> asyncTaskQueue;
    private ScheduledExecutorService executor;
    private List<UpdateTask> asyncTaskTransferList;

    @Override
    public void start(MendmixMybatisInterceptor context) {
        this.dataSource = context.getDataSource();
        this.asyncMode = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.deletebackup.asyncMode", (boolean)true);
        if (this.asyncMode) {
            this.asyncTaskQueue = new LinkedBlockingQueue(5000);
            this.asyncTaskTransferList = new ArrayList<UpdateTask>(20);
            this.executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new StandardThreadExecutor.StandardThreadFactory("asyncDeleteBackupScheduler"));
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (DeleteBackupHandler.this.asyncTaskQueue.isEmpty()) {
                        return;
                    }
                    DeleteBackupHandler.this.asyncTaskTransferList.clear();
                    DeleteBackupHandler.this.asyncTaskQueue.drainTo(DeleteBackupHandler.this.asyncTaskTransferList, 20);
                    if (!DeleteBackupHandler.this.asyncTaskTransferList.isEmpty()) {
                        String entityName = ((UpdateTask)DeleteBackupHandler.this.asyncTaskTransferList.get(0)).getClass().getSimpleName();
                        logger.info(">>asyncDeleteBackup BEGIN  -> entityName:{},size:{}", (Object)entityName, (Object)DeleteBackupHandler.this.asyncTaskTransferList.size());
                    }
                    long currentTime = System.currentTimeMillis();
                    for (UpdateTask task : DeleteBackupHandler.this.asyncTaskTransferList) {
                        if (currentTime - task.operatorTime.getTime() < 5000L) {
                            DeleteBackupHandler.this.asyncTaskQueue.add(task);
                            continue;
                        }
                        DeleteBackupHandler.this.updateOperatorInfo(task.list, task.operatorBy, task.operatorTime);
                    }
                }
            }, 10000L, 5000L, TimeUnit.MILLISECONDS);
        }
        this.jdbcTemplate = InstanceFactory.getBeanCountOfType(JdbcTemplate.class) == 1 ? (JdbcTemplate)InstanceFactory.getInstance(JdbcTemplate.class) : (JdbcTemplate)InstanceFactory.getInstance((String)(context.getGroupName() + "JdbcTemplate"));
        List<MapperMetadata> list = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        for (MapperMetadata entityInfo : list) {
            if (!entityInfo.getEntityClass().isAnnotationPresent(DeleteBackup.class)) continue;
            String backupTable = entityInfo.getEntityClass().getAnnotation(DeleteBackup.class).backupTo();
            if (StringUtils.isBlank((CharSequence)backupTable)) {
                backupTable = entityInfo.getTableName() + "_deleted_his";
            }
            this.backupTableNameMapping.put(entityInfo.getTableName(), backupTable);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Object onInterceptor(OnceContextVal invocationVal) throws Throwable {
        MappedStatement mt = invocationVal.getMappedStatement();
        if (!SqlCommandType.DELETE.equals((Object)mt.getSqlCommandType())) {
            return null;
        }
        MapperMetadata entityInfo = invocationVal.getEntityInfo();
        if (entityInfo == null || !this.backupTableNameMapping.containsKey(entityInfo.getTableName())) {
            return null;
        }
        String mtId = invocationVal.getMappedStatement().getId();
        List<Object> ids = mtId.endsWith(CrudMethods.deleteByPrimaryKey.name()) ? Arrays.asList(invocationVal.getParameter()) : MybatisSqlRewriteUtils.dynaQueryConditionToIdList(this.dataSource, invocationVal);
        if (CurrentRuntimeContext.isDebugMode()) {
            logger.info("<debug_trace_logging> deleteBackupIdList ids:{}", ids);
        }
        if (!ids.isEmpty()) {
            BaseMapper baseMapper = MapperBeanHolder.getMappeBean(invocationVal.getMapperNameSpace());
            List list = OnceInterceptorStrategy.apply().ignoreRwRoute().ignoreTenant().ignoreSoftDeleteConditon().ignoreDataPermission().exec(() -> {
                if (ids.size() == 1) {
                    Object entity = baseMapper.selectByPrimaryKey(ids.get(0).toString());
                    if (entity != null) {
                        return Arrays.asList(entity);
                    }
                } else {
                    return baseMapper.selectByPrimaryKeys(ids);
                }
                return null;
            });
            if (list != null && !list.isEmpty()) {
                ThreadLocalContext.set((String)CTX_DELETED_ENTITIES, (Object)list);
                logger.debug(">>method[{}] \u751f\u6210\u9884\u5220\u9664\u8bb0\u5f55:{}", (Object)mt.getId(), (Object)list.size());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFinished(OnceContextVal invocationVal, Object result) {
        Map<String, String> oldRewriteTableNameRules;
        block10: {
            List list;
            block9: {
                if (!SqlCommandType.DELETE.equals((Object)invocationVal.getMappedStatement().getSqlCommandType())) {
                    return;
                }
                list = (List)ThreadLocalContext.get((String)CTX_DELETED_ENTITIES);
                oldRewriteTableNameRules = null;
                if (list != null && !list.isEmpty()) break block9;
                ThreadLocalContext.remove((String[])new String[]{CTX_DELETED_ENTITIES});
                MybatisRuntimeContext.setRewriteTableNameRules(oldRewriteTableNameRules);
                return;
            }
            try {
                this.setUpdatedFieldValues(list);
                oldRewriteTableNameRules = MybatisRuntimeContext.getRewriteTableNameRules();
                BaseMapper baseMapper = MapperBeanHolder.getMappeBean(invocationVal.getMapperNameSpace());
                MybatisRuntimeContext.setRewriteTableNameRules(this.backupTableNameMapping);
                OnceInterceptorStrategy.apply().ignoreTableSharding().ignoreLoggingDataChange().exec(() -> {
                    if (list.size() == 1) {
                        baseMapper.insert((BaseEntity)list.get(0));
                    } else {
                        baseMapper.insertList(list);
                    }
                    logger.debug(">>method[{}] \u63d2\u5165\u786c\u5220\u9664\u5907\u4efd\u8bb0\u5f55:{}", (Object)invocationVal.getMappedStatement().getId(), (Object)list.size());
                    return null;
                });
                String operatorBy = CurrentRuntimeContext.getCurrentUserId();
                Date operatorTime = new Date();
                if (this.asyncMode) {
                    UpdateTask task = new UpdateTask(list, operatorBy, operatorTime);
                    try {
                        this.asyncTaskQueue.add(task);
                    }
                    catch (Exception e) {
                        this.updateOperatorInfo(list, operatorBy, operatorTime);
                    }
                    break block10;
                }
                this.updateOperatorInfo(list, operatorBy, operatorTime);
            }
            catch (Exception e) {
                try {
                    logger.error("insertBackupData_ERROR", (Throwable)e);
                }
                catch (Throwable throwable) {
                    ThreadLocalContext.remove((String[])new String[]{CTX_DELETED_ENTITIES});
                    MybatisRuntimeContext.setRewriteTableNameRules(oldRewriteTableNameRules);
                    throw throwable;
                }
                ThreadLocalContext.remove((String[])new String[]{CTX_DELETED_ENTITIES});
                MybatisRuntimeContext.setRewriteTableNameRules(oldRewriteTableNameRules);
            }
        }
        ThreadLocalContext.remove((String[])new String[]{CTX_DELETED_ENTITIES});
        MybatisRuntimeContext.setRewriteTableNameRules(oldRewriteTableNameRules);
    }

    @Override
    public boolean compatibleSqlRewrite() {
        return true;
    }

    private void setUpdatedFieldValues(List<? extends BaseEntity> list) {
        EntityMetadata entityMapper = MetadataHelper.getEntityMapper(list.get(0).getClass());
        if (entityMapper != null) {
            String updatedAtField = null;
            String updatedByField = null;
            for (ColumnMetadata columnMetadata : entityMapper.getColumnsMapper()) {
                if (columnMetadata.isUpdatedAtField()) {
                    updatedAtField = columnMetadata.getProperty();
                }
                if (!columnMetadata.isUpdatedByField()) continue;
                updatedByField = columnMetadata.getProperty();
            }
            for (BaseEntity baseEntity : list) {
                if (updatedAtField != null) {
                    CachingFieldUtils.writeField((Object)baseEntity, (String)updatedAtField, (Object)new Date());
                }
                if (updatedByField == null) continue;
                CachingFieldUtils.writeField((Object)baseEntity, (String)updatedByField, (Object)MybatisRuntimeContext.getCurrentUserId());
            }
        }
    }

    @Override
    public int interceptorOrder() {
        return 9;
    }

    private void updateOperatorInfo(List<? extends BaseEntity> list, String operatorBy, Date operatorTime) {
        Class<?> entityClass = list.get(0).getClass();
        DeleteBackup annotation = entityClass.getAnnotation(DeleteBackup.class);
        boolean updateBy = operatorBy != null && StringUtils.isNotBlank((CharSequence)annotation.updateByColumn());
        boolean updateTime = StringUtils.isNotBlank((CharSequence)annotation.updateTimeColumn());
        if (!updateBy && !updateTime) {
            return;
        }
        Table tableAnnotation = entityClass.getAnnotation(Table.class);
        String tableName = this.backupTableNameMapping.get(tableAnnotation.name());
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>(0);
        sb.append("UPDATE ").append(tableName).append(" SET ");
        if (updateBy) {
            sb.append(annotation.updateByColumn()).append(" = ?");
            params.add(operatorBy);
        }
        if (updateTime) {
            if (updateBy) {
                sb.append(", ");
            }
            sb.append(annotation.updateTimeColumn()).append(" = ?");
            params.add(operatorTime);
        }
        sb.append(" WHERE id");
        if (list.size() == 1) {
            sb.append(" = ?");
            params.add(list.get(0).getId());
        } else {
            sb.append(" IN(");
            for (BaseEntity baseEntity : list) {
                sb.append("?,");
                params.add(baseEntity.getId());
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        }
        this.jdbcTemplate.update(sb.toString(), params.toArray());
    }

    private class UpdateTask {
        String operatorBy;
        Date operatorTime;
        List<? extends BaseEntity> list;

        public UpdateTask(List<? extends BaseEntity> list, String operatorBy, Date operatorTime) {
            this.operatorBy = operatorBy;
            this.operatorTime = operatorTime;
            this.list = list;
        }
    }
}

