/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.operProtect;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlCommandType;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.exception.MainErrorType;
import org.dromara.mendmix.mybatis.MybatisConfigs;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.kit.MybatisSqlRewriteUtils;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.dromara.mendmix.mybatis.plugin.operProtect.annotation.SensitiveOperProtect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveOperProtectHandler
implements PluginInterceptorHandler {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    private boolean allScopes;

    @Override
    public void start(MendmixMybatisInterceptor context) {
        this.allScopes = MybatisConfigs.getBoolean(context.getGroupName(), "mybatis.operProtect.allScopes", true);
    }

    @Override
    public void close() {
    }

    @Override
    public Object onInterceptor(OnceContextVal invocation) throws Throwable {
        boolean withCondition;
        if (MybatisRuntimeContext.isIgnoreOperProtect()) {
            return null;
        }
        if (invocation.getPageObject() != null) {
            return null;
        }
        if (invocation.getMappedStatement().getSqlCommandType().equals((Object)SqlCommandType.INSERT)) {
            return null;
        }
        SensitiveOperProtect annotation = MapperMetadata.getAnnotation(invocation, SensitiveOperProtect.class);
        if (annotation != null ? !annotation.value() : !this.allScopes) {
            return null;
        }
        BoundSql boundSql = invocation.getBoundSql();
        boolean bl = withCondition = !boundSql.getParameterMappings().isEmpty();
        if (!withCondition) {
            String sql = boundSql.getSql();
            withCondition = MybatisSqlRewriteUtils.withWhereConditions(sql);
        }
        if (!withCondition) {
            logger.error("<db_oper_protect> mapper:{},sql:{}", (Object)invocation.getMappedStatement().getId(), (Object)boundSql.getSql());
            throw new MendmixBaseException(MainErrorType.DB_OPTER_FORBIDDEN_ERROR);
        }
        return null;
    }

    @Override
    public void onFinished(OnceContextVal invocation, Object result) {
    }

    @Override
    public int interceptorOrder() {
        return 1;
    }
}

