/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.pagination;

import java.util.ArrayList;
import java.util.List;
import org.dromara.mendmix.common.model.Page;
import org.dromara.mendmix.common.model.PageParams;

public class PageExecutor {
    private static ThreadLocal<Page<?>> pageObjectHolder = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Page<T> doPagination(PageParams pageParam, long total, PageDataLoader<T> dataLoader) {
        Page page = new Page(pageParam, total, null);
        try {
            pageObjectHolder.set(page);
            dataLoader.load();
        }
        finally {
            pageObjectHolder.remove();
        }
        if (page.getData() != null) {
            dataLoader.afterLoad(page.getData());
        }
        return page;
    }

    public static <T> Page<T> pagination(PageParams pageParam, PageDataLoader<T> dataLoader) {
        return PageExecutor.pagination(pageParam, 0L, dataLoader);
    }

    public static <T> Page<T> pagination(PageParams pageParam, long total, PageDataLoader<T> dataLoader) {
        return PageExecutor.doPagination(pageParam, total, dataLoader);
    }

    public static <E, V> Page<V> pagination(PageParams pageParam, ConvertPageDataLoader<E, V> dataLoader) {
        return PageExecutor.pagination(pageParam, 0L, dataLoader);
    }

    public static <E, V> Page<V> pagination(PageParams pageParam, long total, ConvertPageDataLoader<E, V> dataLoader) {
        Page page = PageExecutor.doPagination(pageParam, total, dataLoader);
        ArrayList<V> convertDatas = new ArrayList<V>(page.getData().size());
        for (Object e : page.getData()) {
            convertDatas.add(dataLoader.convert(e));
        }
        return new Page(page, page.getTotal(), convertDatas);
    }

    public static void setPageObject(Page<?> page) {
        pageObjectHolder.set(page);
    }

    public static Page<?> getPageObject() {
        return pageObjectHolder.get();
    }

    public static void clearPageObject() {
        pageObjectHolder.remove();
    }

    public static interface ConvertPageDataLoader<E, V>
    extends PageDataLoader<E> {
        public V convert(E var1);
    }

    public static interface PageDataLoader<T> {
        public List<T> load();

        default public void afterLoad(List<T> datas) {
        }
    }
}

