/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.pagination;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.async.StandardThreadExecutor;
import org.dromara.mendmix.common.model.Page;
import org.dromara.mendmix.common.model.PageParams;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.MybatisConfigs;
import org.dromara.mendmix.mybatis.datasource.DatabaseType;
import org.dromara.mendmix.mybatis.exception.MybatisHanlerInitException;
import org.dromara.mendmix.mybatis.kit.MybatisMapperParser;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.dromara.mendmix.mybatis.plugin.pagination.PageSqlUtils;
import org.dromara.mendmix.mybatis.plugin.rewrite.SqlRewriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginationHandler
implements PluginInterceptorHandler {
    private static Logger logger = LoggerFactory.getLogger(PaginationHandler.class);
    private static final String PAGE_QUERY_EXECUTOR_THREAD_PREFIX = "pageQueryExecutor";
    private static final String PAGE_COUNT_SUFFIX = "_PageCount";
    public static Map<String, Boolean> pageMappedStatements = new HashMap<String, Boolean>();
    private DatabaseType dbType = DatabaseType.mysql;
    private boolean concurrency = ResourceUtils.getBoolean((String)"mendmix-cloud.mybatis.pagination.concurrency");
    private ThreadPoolExecutor concurrencyQueryExecutor;

    @Override
    public void start(MendmixMybatisInterceptor context) {
        this.dbType = DatabaseType.valueOf(MybatisConfigs.getDbType(context.getGroupName()));
        logger.info("<startup-logging>  dbType:{}", (Object)this.dbType.name());
        List<MapperMetadata> entityInfos = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        for (MapperMetadata ei : entityInfos) {
            Method[] methods;
            Class<?> mapperClass = ei.getMapperClass();
            for (Method method : methods = mapperClass.getDeclaredMethods()) {
                Class<?> clazz;
                Class<?>[] parameterTypes;
                if (method.getReturnType() != Page.class) continue;
                String msId = ei.getMapperClass().getName() + "." + method.getName();
                boolean withPageParams = false;
                Class<?>[] classArray = parameterTypes = method.getParameterTypes();
                int n = classArray.length;
                for (int i = 0; i < n && !(withPageParams = (clazz = classArray[i]) == PageParams.class || clazz.getSuperclass() == PageParams.class); ++i) {
                }
                if (!withPageParams) {
                    throw new MybatisHanlerInitException(String.format("method[%s] returnType is:Page,but not found Parameter[PageParams] in Parameters list", method.getName()));
                }
                pageMappedStatements.put(msId, true);
            }
        }
        if (this.concurrency) {
            StandardThreadExecutor.StandardThreadFactory threadFactory = new StandardThreadExecutor.StandardThreadFactory(PAGE_QUERY_EXECUTOR_THREAD_PREFIX);
            ThreadPoolExecutor.CallerRunsPolicy rejectedHandler = new ThreadPoolExecutor.CallerRunsPolicy();
            this.concurrencyQueryExecutor = new StandardThreadExecutor(1, 20, 60L, TimeUnit.SECONDS, 20, (ThreadFactory)threadFactory, (RejectedExecutionHandler)rejectedHandler);
        }
    }

    @Override
    public Object onInterceptor(final OnceContextVal invocation) throws Throwable {
        Page<?> pageObject = invocation.getPageObject();
        if (pageObject == null) {
            return null;
        }
        MappedStatement orignMappedStatement = invocation.getMappedStatement();
        if (!orignMappedStatement.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
            return null;
        }
        if (invocation.getSql() == null) {
            ArrayList list = new ArrayList(1);
            list.add(pageObject);
            return list;
        }
        final ResultHandler resultHandler = (ResultHandler)invocation.getArgs()[3];
        Long total = pageObject.getTotal();
        boolean concurrency = this.concurrency && pageObject.isConcurrency() && total == 0L;
        Future dataQueryFuture = null;
        if (total == 0L) {
            if (concurrency) {
                final Map contextVals = CurrentRuntimeContext.getAllContextVals();
                dataQueryFuture = this.concurrencyQueryExecutor.submit(new Callable<List<?>>(){

                    @Override
                    public List<?> call() throws Exception {
                        boolean usingSelfThread = Thread.currentThread().getName().startsWith(PaginationHandler.PAGE_QUERY_EXECUTOR_THREAD_PREFIX);
                        if (usingSelfThread) {
                            contextVals.forEach((k, v) -> ThreadLocalContext.set((String)k, (Object)v));
                        }
                        try {
                            List list = PaginationHandler.this.executeQuery(invocation, resultHandler);
                            return list;
                        }
                        finally {
                            if (usingSelfThread) {
                                ThreadLocalContext.unset();
                            }
                        }
                    }
                });
            }
            total = this.executeQueryCount(invocation, resultHandler);
        }
        List data = null;
        data = dataQueryFuture != null ? (List)dataQueryFuture.get() : (total > 0L ? this.executeQuery(invocation, resultHandler) : Lists.newArrayListWithCapacity((int)0));
        pageObject.setTotal(total.longValue());
        pageObject.setData(data);
        pageObject.setOrderBys(null);
        ArrayList list = new ArrayList(1);
        list.add(pageObject);
        return list;
    }

    private Long executeQueryCount(OnceContextVal invocation, ResultHandler resultHandler) throws IllegalAccessException, SQLException {
        MappedStatement countMappedStatement = this.getCountMappedStatement(invocation.getMappedStatement());
        Executor executor = invocation.getExecutor();
        Object parameter = invocation.getParameter();
        BoundSql boundSql = invocation.getBoundSql();
        CacheKey countKey = executor.createCacheKey(countMappedStatement, parameter, RowBounds.DEFAULT, boundSql);
        String countSql = PageSqlUtils.getCountSql(invocation.getSql());
        BoundSql countBoundSql = new BoundSql(countMappedStatement.getConfiguration(), countSql, boundSql.getParameterMappings(), parameter);
        SqlRewriteHandler.copyAdditionalParameters(boundSql, countBoundSql);
        List countResultList = executor.query(countMappedStatement, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql);
        try {
            Long count = (Long)countResultList.get(0);
            return count;
        }
        catch (IndexOutOfBoundsException e) {
            return 0L;
        }
    }

    private List executeQuery(OnceContextVal invocation, ResultHandler resultHandler) throws IllegalAccessException, SQLException {
        Executor executor = invocation.getExecutor();
        MappedStatement mappedStatement = invocation.getMappedStatement();
        BoundSql boundSql = invocation.getBoundSql();
        Object parameter = invocation.getParameter();
        String pageSql = PageSqlUtils.getLimitSQL(this.dbType, invocation.getSql(), invocation.getPageObject());
        BoundSql pageBoundSql = new BoundSql(mappedStatement.getConfiguration(), pageSql, boundSql.getParameterMappings(), parameter);
        SqlRewriteHandler.copyAdditionalParameters(boundSql, pageBoundSql);
        List resultList = executor.query(mappedStatement, parameter, RowBounds.DEFAULT, resultHandler, null, pageBoundSql);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedStatement getCountMappedStatement(MappedStatement ms) {
        String newMsId = ms.getId() + PAGE_COUNT_SUFFIX;
        MappedStatement statement = null;
        Configuration configuration = ms.getConfiguration();
        try {
            statement = configuration.getMappedStatement(newMsId);
            if (statement != null) {
                return statement;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Configuration configuration2 = configuration;
        synchronized (configuration2) {
            if (configuration.hasStatement(newMsId)) {
                return configuration.getMappedStatement(newMsId);
            }
            MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), newMsId, ms.getSqlSource(), ms.getSqlCommandType());
            builder.resource(ms.getResource());
            builder.fetchSize(ms.getFetchSize());
            builder.statementType(ms.getStatementType());
            builder.keyGenerator(ms.getKeyGenerator());
            if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
                StringBuilder keyProperties = new StringBuilder();
                for (String keyProperty : ms.getKeyProperties()) {
                    keyProperties.append(keyProperty).append(",");
                }
                keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
                builder.keyProperty(keyProperties.toString());
            }
            builder.timeout(ms.getTimeout());
            builder.parameterMap(ms.getParameterMap());
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            String id = newMsId + "-Inline";
            ResultMap resultMap = new ResultMap.Builder(configuration, id, Long.class, new ArrayList(0)).build();
            resultMaps.add(resultMap);
            builder.resultMaps(resultMaps);
            builder.resultSetType(ms.getResultSetType());
            builder.cache(ms.getCache());
            builder.flushCacheRequired(ms.isFlushCacheRequired());
            builder.useCache(ms.isUseCache());
            statement = builder.build();
            configuration.addMappedStatement(statement);
            return statement;
        }
    }

    @Override
    public void onFinished(OnceContextVal invocation, Object result) {
    }

    @Override
    public void close() {
        if (this.concurrencyQueryExecutor != null) {
            this.concurrencyQueryExecutor.shutdown();
        }
    }

    @Override
    public int interceptorOrder() {
        return 3;
    }
}

