/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.mybatis.MybatisConfigs;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.plugin.rewrite.ConditionPair;
import org.dromara.mendmix.mybatis.plugin.rewrite.annotation.DataPermission;
import org.dromara.mendmix.mybatis.plugin.rewrite.annotation.DataPermissionItem;

public class DataPermissionStrategy {
    private boolean allMatch;
    private boolean handleJoin;
    private boolean handleOwner;
    private boolean joinConditionWithOn;
    private boolean onlyHandleOwner;
    private Map<String, DataPermissionItem> strategies;

    public DataPermissionStrategy(DataPermission annotation) {
        this.handleJoin = annotation.handleJoin();
        this.handleOwner = annotation.handleOwner();
        this.joinConditionWithOn = annotation.joinConditionWithOn();
        if (annotation.strategy().length == 0) {
            this.allMatch = true;
        } else {
            this.strategies = new HashMap<String, DataPermissionItem>(annotation.strategy().length);
            for (DataPermissionItem policy : annotation.strategy()) {
                this.strategies.put(policy.table(), policy);
            }
            this.handleOwner = this.strategies.values().stream().anyMatch(a -> a.handleOwner());
        }
    }

    public DataPermissionStrategy(boolean allMatch, Map<String, DataPermissionItem> strategies) {
        this.allMatch = allMatch;
        this.handleJoin = allMatch;
        this.handleOwner = MybatisConfigs.DATA_PERM_HANDLE_OWNER;
        this.joinConditionWithOn = true;
        this.strategies = strategies;
        if (strategies != null) {
            this.handleOwner = strategies.values().stream().anyMatch(a -> a.handleOwner());
        }
    }

    public boolean isAllMatch() {
        return this.allMatch;
    }

    public void setHandleOwner(boolean handleOwner) {
        this.handleOwner = handleOwner;
    }

    public void setHandleJoin(boolean handleJoin) {
        this.handleJoin = handleJoin;
    }

    public boolean isJoinConditionWithOn() {
        return this.joinConditionWithOn;
    }

    public boolean isOnlyHandleOwner() {
        return this.onlyHandleOwner;
    }

    public void setOnlyHandleOwner(boolean onlyHandleOwner) {
        this.onlyHandleOwner = onlyHandleOwner;
    }

    public boolean isHandleJoin(String table) {
        if (!this.handleJoin) {
            return false;
        }
        return this.allMatch || this.hasTableStrategy(table);
    }

    public DataPermissionItem getTableStrategy(String table) {
        return this.strategies == null ? null : this.strategies.get(table);
    }

    public boolean hasTableStrategy(String table) {
        if (this.allMatch) {
            return true;
        }
        return this.strategies != null && this.strategies.containsKey(table);
    }

    public boolean handleOwner(String table) {
        if (this.allMatch || !this.handleOwner) {
            return this.handleOwner;
        }
        if (this.hasTableStrategy(table)) {
            return this.getTableStrategy(table).handleOwner();
        }
        return false;
    }

    public List<List<ConditionPair>> getOrRelationColumns(String table) {
        if (this.strategies == null || !this.strategies.containsKey(table)) {
            return null;
        }
        String[] relations = this.strategies.get(table).orRelations();
        if (relations.length == 0) {
            return null;
        }
        ArrayList<List<ConditionPair>> result = new ArrayList<List<ConditionPair>>(relations.length);
        for (String rel : relations) {
            String[] columns = StringUtils.split((String)rel, (String)",");
            ArrayList<ConditionPair> conditions = new ArrayList<ConditionPair>(columns.length);
            for (String column : columns) {
                conditions.add(new ConditionPair(column, null));
            }
            result.add(conditions);
        }
        return result;
    }

    public static void updateHandleOwner(boolean handleOwner) {
        DataPermissionStrategy strategy = MybatisRuntimeContext.getDataPermissionStrategy();
        if (strategy == null) {
            strategy = new DataPermissionStrategy(false, null);
            MybatisRuntimeContext.setDataPermissionStrategy(strategy);
        }
        strategy.setHandleOwner(handleOwner);
    }
}

