/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.rewrite;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.mybatis.MybatisConfigs;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.rewrite.OrganizationProvider;
import org.dromara.mendmix.mybatis.plugin.rewrite.SpecialPermType;
import org.dromara.mendmix.spring.InstanceFactory;

public class OrgPermissionHelper {
    protected static final String DEFAULT_POSITION_GROUP_NAME = "position";
    protected static final String CONTEXT_CURRENT_POSTION_ID = "_ctx_cur_postion_id";
    private static OrganizationProvider organizationProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OrganizationProvider getOrganizationProvider() {
        if (organizationProvider != null) {
            return organizationProvider;
        }
        Class<OrgPermissionHelper> clazz = OrgPermissionHelper.class;
        synchronized (OrgPermissionHelper.class) {
            organizationProvider = (OrganizationProvider)InstanceFactory.getInstance(OrganizationProvider.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return organizationProvider;
        }
    }

    public static void prepareOrganizationPermission(OnceContextVal invocation, Map<String, String[]> dataPermValues, String deptPropName) {
        String[] values = dataPermValues.get(MybatisConfigs.ORG_DATA_PERM_NAME);
        if (values == null) {
            return;
        }
        if (values.length == 0) {
            dataPermValues.put(deptPropName, values);
            return;
        }
        HashSet<String> valueList = new HashSet<String>(values.length);
        for (String value : values) {
            if (StringUtils.isBlank((CharSequence)value)) continue;
            value = value.trim();
            if (SpecialPermType.currentDept.name().equals(value)) {
                if (MybatisConfigs.DATA_PERM_ORG_USING_FULL_CODE_MODE) {
                    valueList.add(OrgPermissionHelper.getCurrentDeptCode());
                    continue;
                }
                valueList.add(OrgPermissionHelper.getCurrentDeptId());
                continue;
            }
            if (SpecialPermType.currentAndSubDept.name().equals(value)) {
                if (MybatisConfigs.DATA_PERM_ORG_USING_FULL_CODE_MODE) {
                    valueList.add(OrgPermissionHelper.getCurrentDeptCode() + "%");
                    continue;
                }
                List<String> subDepartmentIds = OrgPermissionHelper.findSubDepartmentIds(OrgPermissionHelper.getCurrentDeptId());
                if (subDepartmentIds == null || subDepartmentIds.isEmpty()) continue;
                valueList.addAll(subDepartmentIds);
                continue;
            }
            valueList.add(value);
        }
        if (!valueList.isEmpty()) {
            dataPermValues.put(deptPropName, valueList.toArray(new String[0]));
            MybatisRuntimeContext.setDataPermissionValues(dataPermValues, false);
        }
    }

    private static String getCurrentDeptId() {
        String departmentId;
        if (!ThreadLocalContext.exists((String)CONTEXT_CURRENT_POSTION_ID)) {
            departmentId = CurrentRuntimeContext.getAndValidateCurrentUser().getDeptId();
        } else {
            String positionId = ThreadLocalContext.getStringValue((String)CONTEXT_CURRENT_POSTION_ID);
            departmentId = OrgPermissionHelper.getOrganizationProvider().getPositionOwnDepartmentId(positionId);
        }
        if (StringUtils.isBlank((CharSequence)departmentId)) {
            throw new MendmixBaseException("\u5f53\u524d\u767b\u5f55\u7528\u6237\u90e8\u95e8ID\u4e3a\u7a7a");
        }
        return departmentId;
    }

    private static String getCurrentDeptCode() {
        String departmentId = OrgPermissionHelper.getCurrentDeptId();
        return OrgPermissionHelper.getOrganizationProvider().deptIdToFullCode(departmentId);
    }

    private static List<String> findSubDepartmentIds(String deptId) {
        return OrgPermissionHelper.getOrganizationProvider().findSubDepartments(deptId);
    }
}

