/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.rewrite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.model.AuthUser;
import org.dromara.mendmix.common.model.DataPermItem;
import org.dromara.mendmix.common.model.Page;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.mybatis.DeptPermType;
import org.dromara.mendmix.mybatis.MybatisConfigs;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.metadata.MetadataHelper;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.rewrite.DataPermissionStrategy;
import org.dromara.mendmix.mybatis.plugin.rewrite.OrgPermissionHelper;
import org.dromara.mendmix.mybatis.plugin.rewrite.RewriteTable;
import org.dromara.mendmix.mybatis.plugin.rewrite.SqlRewriteHandler;
import org.dromara.mendmix.mybatis.plugin.rewrite.annotation.DataPermissionItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteSqlOnceContext {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    OnceContextVal invocation;
    DataPermissionStrategy strategy;
    private Map<String, String[]> dataPermValues;
    boolean handleDataPerm;
    boolean handleTenant;
    boolean handleSoftDelete;
    boolean handleOrderBy;
    String currentGroupKey;
    List<RewriteTable> rewriteTables;
    AuthUser currentUser;
    String currentTenantId;
    boolean unionSelect;
    boolean loadedCurrentGroupPermData;
    boolean mainTableHandledTenant;
    boolean traceLogging = CurrentRuntimeContext.isDebugMode();

    public RewriteSqlOnceContext(OnceContextVal invocation, boolean isFieldTenantMode, boolean dynaDataPermEnaled) {
        this.currentUser = CurrentRuntimeContext.getCurrentUser();
        this.invocation = invocation;
        this.handleDataPerm = dynaDataPermEnaled && (this.currentUser == null || !this.currentUser.isAdmin()) && !MybatisRuntimeContext.isIgnoreDataPermission() && (this.strategy = MybatisRuntimeContext.getDataPermissionStrategy()) != null;
        this.handleTenant = isFieldTenantMode && !MybatisRuntimeContext.isIgnoreTenantMode() && !MybatisConfigs.ignoreTenant(invocation.getMapperNameSpace());
        Page<?> pageParam = invocation.getPageObject();
        boolean bl = this.handleOrderBy = pageParam != null && pageParam.getOrderBys() != null && !pageParam.getOrderBys().isEmpty();
        if (this.handleDataPerm && this.strategy == null) {
            this.strategy = MybatisRuntimeContext.getDataPermissionStrategy();
        }
        if (isFieldTenantMode) {
            this.currentTenantId = CurrentRuntimeContext.getTenantId();
        }
        if (this.traceLogging && !this.handleDataPerm) {
            logger.info("<trace_logging> handleDataPerm = false\n -currentUser:{}\n -ignoreDataPermission:{}\n -withStrategy:{}", new Object[]{this.currentUser == null ? null : (this.currentUser.isAdmin() ? "isAdmin" : "isNotAdmin"), MybatisRuntimeContext.isIgnoreDataPermission(), MybatisRuntimeContext.getDataPermissionStrategy() != null});
        }
    }

    public Map<String, String[]> getDataPermValues() {
        if (this.dataPermValues == null && this.handleDataPerm) {
            this.dataPermValues = MybatisRuntimeContext.getDataPermissionValues(this.currentGroupKey);
        }
        if (this.dataPermValues == null) {
            this.dataPermValues = new HashMap<String, String[]>(3);
            if (this.handleDataPerm) {
                MybatisRuntimeContext.setDataPermissionValues(this.dataPermValues, false);
            }
        }
        return this.dataPermValues;
    }

    public boolean withTableShardingRule() {
        return this.invocation.getTableNameMapping() != null && !this.invocation.getTableNameMapping().isEmpty();
    }

    public boolean withConditionReriteRule() {
        return this.handleDataPerm || this.handleTenant || this.handleSoftDelete || this.handleOrderBy;
    }

    public String[] getPermValues(String field) {
        return this.getDataPermValues().get(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadDataPermValues(SqlRewriteHandler handler) {
        if (!this.handleDataPerm || this.loadedCurrentGroupPermData) {
            return;
        }
        boolean withGroup = StringUtils.isNotBlank((CharSequence)this.currentGroupKey);
        try {
            if (withGroup) {
                if (this.traceLogging) {
                    logger.info("<trace_logging> reloadGroupDataPermValues:{}", (Object)this.currentGroupKey);
                }
                this.mainTableHandledTenant = false;
                if (this.currentGroupKey.startsWith("position")) {
                    String positionId = this.currentGroupKey.substring(this.currentGroupKey.indexOf(":") + 1);
                    ThreadLocalContext.set((String)"_ctx_cur_postion_id", (Object)positionId);
                }
                this.dataPermValues = null;
                MybatisRuntimeContext.setDataPermissionValues(null, false);
            }
            this.dataPermValues = this.getDataPermValues();
            boolean preparedOrgPermData = this.dataPermValues.containsKey(handler.getDeptPropName());
            if (this.rewriteTables != null) {
                if (handler.getDeptPropName() != null && this.dataPermValues.containsKey(MybatisConfigs.ORG_DATA_PERM_NAME) && this.rewriteTables.stream().anyMatch(o -> o.getRewriteColumnMapping().containsKey(handler.getDeptPropName()))) {
                    OrgPermissionHelper.prepareOrganizationPermission(this.invocation, this.dataPermValues, handler.getDeptPropName());
                    preparedOrgPermData = true;
                    if (withGroup) {
                        if (this.traceLogging) {
                            logger.info("<trace_logging> reloadPrepareOrganizationPermission for permGroup:{}", (Object)this.currentGroupKey);
                        }
                        ThreadLocalContext.remove((String[])new String[]{"_ctx_cur_postion_id"});
                    }
                }
                for (RewriteTable rewriteTable : this.rewriteTables) {
                    this.setTableOwnerColumns(handler, rewriteTable);
                    if (withGroup || !preparedOrgPermData || this.rewriteTables.size() <= 1) continue;
                    rewriteTable.setUsingGlobalOrgPerm(this.isUsingGroupOrgPerm(handler, rewriteTable));
                }
            }
            if (this.traceLogging) {
                logger.info(this.toLogString());
                logger.info("<trace_logging> loadDataPermValues\n -group:{}\n -values:{}", (Object)this.currentGroupKey, (Object)JsonUtils.toJson(this.getDataPermValues()));
            } else if (logger.isDebugEnabled()) {
                logger.debug(this.toLogString());
            }
            this.loadedCurrentGroupPermData = true;
            if (!withGroup) return;
        }
        catch (Throwable throwable) {
            if (!withGroup) throw throwable;
            ThreadLocalContext.remove((String[])new String[]{"x-referer-permGroup"});
            throw throwable;
        }
        ThreadLocalContext.remove((String[])new String[]{"x-referer-permGroup"});
    }

    public boolean isHandleGroupOrgPermission() {
        if (this.rewriteTables.size() <= 1) {
            return false;
        }
        boolean has = this.rewriteTables.stream().anyMatch(o -> o.isUsingGlobalOrgPerm());
        if (!has) {
            return has;
        }
        String[] values = this.getDataPermValues().get(MybatisConfigs.ORG_DATA_PERM_NAME);
        if (values == null) {
            return false;
        }
        for (String val : values) {
            has = !DeptPermType.none.name().equals(val);
            if (!has) continue;
            return has;
        }
        return false;
    }

    public List<String> getPermGroupKeys() {
        if (!this.handleDataPerm || !MybatisConfigs.DATA_PERM_USING_GROUP_MODE) {
            return null;
        }
        String group = CurrentRuntimeContext.getContextVal((String)"x-referer-permGroup", (boolean)false);
        if (StringUtils.isNotBlank((CharSequence)group)) {
            return Arrays.asList(StringUtils.split((String)group, (String)","));
        }
        List<DataPermItem> permssions = MybatisRuntimeContext.userPermissionProvider().findCurrentAllPermissions();
        if (permssions == null || permssions.isEmpty()) {
            return null;
        }
        List<String> groupKeys = permssions.stream().filter(o -> o.getGroupName() != null).map(o -> o.getGroupName()).distinct().collect(Collectors.toList());
        if (groupKeys.size() > 1) {
            for (String groupKey : groupKeys) {
                boolean withAllPerm = permssions.stream().filter(o -> groupKey.equals(o.getGroupName())).allMatch(o -> o.isAll() || o.getValues() != null && o.getValues().contains(DeptPermType._ALL_.name()));
                if (!withAllPerm) continue;
                if (this.traceLogging) {
                    logger.info("<trace_logging> permissionGroup:{} with AllPermission!!!", (Object)groupKey);
                }
                return Arrays.asList(DeptPermType._ALL_.name());
            }
        }
        if (this.traceLogging && !groupKeys.isEmpty()) {
            logger.info("<trace_logging> resolve permissionGroups:{}", groupKeys);
        }
        return groupKeys;
    }

    public void parseRewriteTable(SqlRewriteHandler handler, PlainSelect select) {
        SelectBody selectBody;
        RewriteTable rewriteTable;
        Table table;
        FromItem fromItem;
        if (this.rewriteTables == null) {
            this.rewriteTables = new ArrayList<RewriteTable>();
        }
        if ((fromItem = select.getFromItem()) instanceof Table) {
            table = (Table)select.getFromItem();
            rewriteTable = this.buildRewriteTable(handler, table, false);
            if (rewriteTable.getRewritedTableName() != null) {
                select.setFromItem((FromItem)rewriteTable.getTable());
            }
            rewriteTable.setAppendConditonTo(select);
        } else if (fromItem instanceof SubSelect && (selectBody = ((SubSelect)fromItem).getSelectBody()) instanceof PlainSelect) {
            this.parseRewriteTable(handler, (PlainSelect)selectBody);
        }
        List joins = select.getJoins();
        if (joins != null) {
            for (Join join : joins) {
                SelectBody selectBody2;
                if (join.getRightItem() instanceof Table) {
                    boolean appendConditonUsingOn;
                    table = (Table)join.getRightItem();
                    rewriteTable = this.buildRewriteTable(handler, table, true);
                    if (rewriteTable.getRewritedTableName() != null) {
                        join.setRightItem((FromItem)rewriteTable.getTable());
                    }
                    boolean bl = appendConditonUsingOn = join.getOnExpressions().size() > 0;
                    if (appendConditonUsingOn) {
                        if (this.strategy != null) {
                            appendConditonUsingOn = this.strategy.isJoinConditionWithOn();
                        } else if (join.isInner()) {
                            appendConditonUsingOn = MybatisConfigs.DATA_PERM_INNER_JOIN_USING_ON;
                        }
                    }
                    rewriteTable.setAppendConditonUsingOn(appendConditonUsingOn);
                    if (appendConditonUsingOn) {
                        rewriteTable.setAppendConditonTo(join);
                        continue;
                    }
                    rewriteTable.setAppendConditonTo(select);
                    continue;
                }
                if (!(join.getRightItem() instanceof SubSelect) || !((selectBody2 = ((SubSelect)join.getRightItem()).getSelectBody()) instanceof PlainSelect)) continue;
                this.parseRewriteTable(handler, (PlainSelect)selectBody2);
            }
        }
    }

    private RewriteTable buildRewriteTable(SqlRewriteHandler handler, Table table, boolean joinTable) {
        RewriteTable rewriteTable = new RewriteTable(table, joinTable);
        boolean _handleDataPerm = false;
        if (this.handleDataPerm && this.strategy != null) {
            _handleDataPerm = joinTable ? this.strategy.isHandleJoin(rewriteTable.getTableName()) : this.strategy.isAllMatch() || this.strategy.hasTableStrategy(rewriteTable.getTableName());
            rewriteTable.setTableStrategy(this.strategy.getTableStrategy(rewriteTable.getTableName()));
        }
        HashMap<String, List<String>> columnMapping = null;
        if (_handleDataPerm && !this.strategy.isAllMatch()) {
            DataPermissionItem tableStrategy = this.strategy.getTableStrategy(rewriteTable.getTableName());
            String[] columns = tableStrategy.columns();
            columnMapping = new HashMap(columns.length + 2);
            for (String column : columns) {
                String alias;
                if (column.contains(":")) {
                    String[] parts = StringUtils.split((String)column, (String)":");
                    column = parts[0];
                    alias = parts[1];
                } else {
                    alias = handler.getDataPermColumnAlias(rewriteTable.getTableName(), column);
                }
                ArrayList<String> tmpColumns = (ArrayList<String>)columnMapping.get(alias);
                if (tmpColumns == null) {
                    tmpColumns = new ArrayList<String>(3);
                    columnMapping.put(alias, tmpColumns);
                }
                tmpColumns.add(column);
            }
            handler.mergeTableColumnMapping(columnMapping, rewriteTable.getTableName());
        }
        if (_handleDataPerm && this.strategy.isAllMatch()) {
            columnMapping = handler.getTaleAllPermColumnMapping(rewriteTable.getTableName());
        }
        if (columnMapping == null) {
            columnMapping = new HashMap(3);
            handler.mergeTableColumnMapping(columnMapping, rewriteTable.getTableName());
        }
        rewriteTable.setRewriteColumnMapping(columnMapping);
        Map<String, String> rewritedTableMapping = this.invocation.getTableNameMapping();
        String originTableName = StringUtils.remove((String)table.getName(), (String)RewriteTable.nameDelimiter);
        if (rewritedTableMapping != null && rewritedTableMapping.containsKey(originTableName)) {
            rewriteTable.setRewritedTableName(rewritedTableMapping.get(originTableName));
            table.setName(rewriteTable.getRewritedTableName());
        }
        this.rewriteTables.add(rewriteTable);
        return rewriteTable;
    }

    private void setTableOwnerColumns(SqlRewriteHandler handler, RewriteTable table) {
        boolean handleOwner = this.strategy.handleOwner(table.getTableName());
        if (handleOwner && !this.strategy.isAllMatch()) {
            handleOwner = MybatisConfigs.DATA_PERM_HANDLE_OWNER;
        }
        String[] ownerColumns = null;
        if (handleOwner) {
            if (table.getTableStrategy() != null) {
                ownerColumns = table.getTableStrategy().ownerColumns();
            }
            if (!table.isUsingGlobalOrgPerm() && MybatisConfigs.DATA_PERM_HANDLE_OWNER && (ownerColumns == null || ownerColumns.length == 0) && MetadataHelper.hasTableColumn(table.getTableName(), handler.getCreatedByColumnName())) {
                ownerColumns = new String[]{handler.getCreatedByColumnName()};
            }
        }
        table.setOwnerColumns(ownerColumns);
        if (this.traceLogging && ownerColumns != null) {
            logger.info("<trace_logging> set[{}]OwnerColumns:{}", (Object)table.getTableName(), (Object)ownerColumns);
        }
    }

    private boolean isUsingGroupOrgPerm(SqlRewriteHandler handler, RewriteTable table) {
        String createdByColumn = handler.getCreatedByColumnName();
        String deptPropName = handler.getDeptPropName();
        boolean withDeptColumn = this.withDeptmentItem(table, deptPropName);
        table.setWithDeptColumn(withDeptColumn);
        boolean withOwnerColumn = false;
        if (table.getTableStrategy() != null) {
            Object column;
            String[] stringArray = table.getTableStrategy().ownerColumns();
            int n = stringArray.length;
            for (int i = 0; i < n && !(withOwnerColumn = !((String)(column = stringArray[i])).equals(createdByColumn)); ++i) {
            }
        }
        for (RewriteTable thisTable : this.rewriteTables) {
            if (thisTable.getTableName().equals(table.getTableName()) || thisTable.isAppendConditonUsingOn()) continue;
            if (withOwnerColumn && this.withDeptmentItem(thisTable, deptPropName)) {
                return true;
            }
            if (!withDeptColumn || thisTable.getTableStrategy() == null) continue;
            for (String column : thisTable.getTableStrategy().ownerColumns()) {
                if (column.equals(createdByColumn)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean withDeptmentItem(RewriteTable table, String deptPropName) {
        if (!table.getRewriteColumnMapping().containsKey(deptPropName)) {
            return false;
        }
        String[] values = this.getDataPermValues().get(deptPropName);
        if (values == null) {
            values = this.getDataPermValues().get(MybatisConfigs.ORG_DATA_PERM_NAME);
        }
        return values != null && (values.length != 1 || !DeptPermType.none.name().equals(values[0]));
    }

    public String toLogString() {
        StringBuilder builder = new StringBuilder();
        if (this.traceLogging) {
            builder.append("<trace_logging> ");
        }
        builder.append("RewriteSqlOnceContext[");
        builder.append(this.invocation.getMappedStatement().getId()).append("]");
        builder.append("\n - handleTenant:").append(this.handleTenant);
        builder.append("\n - handleDataPerm:").append(this.handleDataPerm);
        builder.append("\n - handleSoftDelete:").append(this.handleSoftDelete);
        builder.append("\n - handleOrderBy:").append(this.handleOrderBy);
        if (this.handleTenant) {
            builder.append("\n - currentTenantId:").append(this.currentTenantId);
        }
        if (this.rewriteTables != null) {
            builder.append("\n - rewriteTables:");
            if (this.traceLogging) {
                for (RewriteTable rewriteTable : this.rewriteTables) {
                    builder.append("\n  - ").append(rewriteTable);
                }
            } else {
                builder.append(this.rewriteTables.stream().map(o -> o.getTableName()).collect(Collectors.toList()));
            }
        }
        return builder.toString();
    }
}

