/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.rewrite;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.mybatis.plugin.rewrite.annotation.DataPermissionItem;

public class RewriteTable {
    public static String nameDelimiter = "`";
    private Table table;
    private String tableName;
    private String rewritedTableName;
    Map<String, List<String>> rewriteColumnMapping;
    private boolean join;
    private boolean appendConditonUsingOn;
    private Object appendConditonTo;
    private boolean handleOwner;
    private boolean withDeptColumn;
    private boolean usingGlobalOrgPerm;
    private String[] ownerColumns;
    private boolean ownerUsingAnd;
    private DataPermissionItem tableStrategy;
    private Map<String, Expression> groupExpressions;

    public RewriteTable(Table table, boolean joinTable) {
        this.table = table;
        this.tableName = StringUtils.remove((String)table.getName(), (String)nameDelimiter);
        this.join = joinTable;
    }

    public Table getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getRewritedTableName() {
        return this.rewritedTableName;
    }

    public void setRewritedTableName(String rewritedTableName) {
        this.rewritedTableName = rewritedTableName;
    }

    public Map<String, List<String>> getRewriteColumnMapping() {
        return this.rewriteColumnMapping;
    }

    public void setRewriteColumnMapping(Map<String, List<String>> rewriteColumnMapping) {
        this.rewriteColumnMapping = rewriteColumnMapping;
    }

    public boolean isHandleOwner() {
        return this.handleOwner;
    }

    public void setHandleOwner(boolean handleOwner) {
        this.handleOwner = handleOwner;
    }

    public boolean isJoin() {
        return this.join;
    }

    public void setJoin(boolean join) {
        this.join = join;
    }

    public boolean isAppendConditonUsingOn() {
        return this.appendConditonUsingOn;
    }

    public void setAppendConditonUsingOn(boolean appendConditonUsingOn) {
        this.appendConditonUsingOn = appendConditonUsingOn;
    }

    public void setAppendConditonTo(Object appendConditonTo) {
        this.appendConditonTo = appendConditonTo;
    }

    public boolean isWithDeptColumn() {
        return this.withDeptColumn;
    }

    public void setWithDeptColumn(boolean withDeptColumn) {
        this.withDeptColumn = withDeptColumn;
    }

    public boolean isUsingGlobalOrgPerm() {
        return this.usingGlobalOrgPerm;
    }

    public void setUsingGlobalOrgPerm(boolean usingGlobalOrgPerm) {
        this.usingGlobalOrgPerm = usingGlobalOrgPerm;
    }

    public String[] getOwnerColumns() {
        return this.ownerColumns;
    }

    public void setOwnerColumns(String[] ownerColumns) {
        this.ownerColumns = ownerColumns;
    }

    public boolean isOwnerUsingAnd() {
        return this.ownerUsingAnd;
    }

    public void setOwnerUsingAnd(boolean ownerUsingAnd) {
        this.ownerUsingAnd = ownerUsingAnd;
    }

    public DataPermissionItem getTableStrategy() {
        return this.tableStrategy;
    }

    public void setTableStrategy(DataPermissionItem tableStrategy) {
        this.tableStrategy = tableStrategy;
    }

    public Collection<Expression> getGroupExpressions() {
        return this.groupExpressions == null ? null : this.groupExpressions.values();
    }

    public void updateConditionExpression(Expression expression) {
        if (expression == null) {
            return;
        }
        if (this.appendConditonUsingOn) {
            LinkedList onExpressions = (LinkedList)((Join)this.appendConditonTo).getOnExpressions();
            onExpressions.set(0, expression);
        } else {
            ((PlainSelect)this.appendConditonTo).setWhere(expression);
        }
    }

    public Expression getOriginConditionExpression() {
        if (this.appendConditonUsingOn) {
            return ((Join)this.appendConditonTo).getOnExpressions().stream().findFirst().orElse(null);
        }
        return ((PlainSelect)this.appendConditonTo).getWhere();
    }

    public boolean containsRewriteField(String field) {
        return this.rewriteColumnMapping != null && this.rewriteColumnMapping.containsKey(field);
    }

    public boolean hasRewriteColumn() {
        return this.rewriteColumnMapping != null && !this.rewriteColumnMapping.isEmpty() || this.ownerColumns != null && this.ownerColumns.length > 0;
    }

    public void addGroupExpressions(Expression expression) {
        String key;
        if (expression == null) {
            return;
        }
        if (this.groupExpressions == null) {
            this.groupExpressions = new HashMap<String, Expression>(3);
        }
        if (!this.groupExpressions.containsKey(key = expression.toString())) {
            this.groupExpressions.put(key, expression);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Table[");
        builder.append(this.getTableName()).append("]");
        if (this.rewritedTableName != null) {
            builder.append("\n - rewritedTableName:").append(this.rewritedTableName);
        }
        builder.append("\n   - handleOwner:").append(this.handleOwner);
        builder.append("\n   - appendConditonUsingOn:").append(this.appendConditonUsingOn);
        builder.append("\n   - withDeptColumn:").append(this.withDeptColumn);
        builder.append("\n   - usingGroupOrgPerm:").append(this.usingGlobalOrgPerm);
        builder.append("\n   - rewriteColumnMapping:").append(this.rewriteColumnMapping);
        builder.append("\n   - ownerColumns:").append(this.ownerColumns == null ? null : JsonUtils.toJson((Object)this.ownerColumns));
        return builder.toString();
    }
}

